#include "neo.h"
#include <strings.h>
#include <string.h>

void neo_board_create(neo_board *b) {
  neo_board_set_number(b, 0);
  neo_board_set_notpresent(b);
  neo_board_set_descr(b, "");
  neo_board_set_uplinkdescr(b, "");
  neo_board_set_link_unknown(b);
  neo_board_set_speed(b, 0);
  neo_board_set_admin_unknown(b);
  neo_board_set_notuplink(b);
  neo_board_set_segment(b, 0);
}

void neo_board_set_number(neo_board *b, int in) {
  b->number=in;
}

int neo_board_get_number(neo_board *b) {
  return(b->number);
}

void neo_board_set_present(neo_board *b) {
  b->present=1;
}

void neo_board_set_notpresent(neo_board *b) {
  b->present=0;
}

int neo_board_is_present(neo_board *b) {
  if (b->present==1) return(1);
  return(0);
}
     
void neo_board_set_descr(neo_board *b, char *descr) {
  strcpy(b->descr, descr);
}

char *neo_board_get_descr(neo_board *b) {
  return(b->descr);
}

void neo_board_set_uplinkdescr(neo_board *b, char *descr) {
  strcpy(b->uplinkdescr, descr);
}

char *neo_board_get_uplinkdescr(neo_board *b) {
  return(b->uplinkdescr);
}

void neo_board_set_link_up(neo_board *b) {
  b->link=1;
}

void neo_board_set_link_down(neo_board *b) {
  b->link=0;
}

void neo_board_set_link_unknown(neo_board *b) {
  b->link=-1;
}

int neo_board_link_is_up(neo_board *b) {
  if (b->link==1) return(1);
  return(0);
}

int neo_board_link_is_down(neo_board *b) {
  if (b->link==0) return(1);
  return(0);
}

int neo_board_link_is_unknown(neo_board *b) {
  if (b->link==-1) return(1);
  return(0);
}

void neo_board_set_speed(neo_board *b, int speed) {
  b->speed=speed;
}

int neo_board_get_speed(neo_board *b) {
  return(b->speed);
}

void neo_board_set_admin_up(neo_board *b) {
  b->admin=1;
}

void neo_board_set_admin_down(neo_board *b) {
  b->admin=0;
}

void neo_board_set_admin_unknown(neo_board *b) {
  b->admin=-1;
}

int neo_board_admin_is_up(neo_board *b) {
  if (b->admin==1) return(1);
  return(0);
}

int neo_board_admin_is_down(neo_board *b) {
  if (b->admin==0) return(1);
  return(0);
}

int neo_board_admin_is_unknown(neo_board *b) {
  if (b->admin==-1) return(1);
  return(0);
}

void neo_board_set_uplink(neo_board *b) {
  b->uplink=1;
}

void neo_board_set_notuplink(neo_board *b) {
  b->uplink=0;
}

int neo_board_is_uplink(neo_board *b) {
  if (b->uplink==1) return(1);
  return(0);
}

void neo_board_set_segment(neo_board *b, int seg) {
  b->seg=seg;
}

int neo_board_get_segment(neo_board *b) {
  return(b->seg);
}

void neo_board_free_elements(neo_board *b) {
  /* WRITE */
}

void neo_board_free_complete(neo_board *b) {
  /* WRITE */
}

void neo_board_set_stats(neo_board *b, neo_stats *s) {
  memcpy(&(b->stats), s, sizeof(neo_stats));
}

neo_stats *neo_board_get_stats(neo_board *b) {
  return(&(b->stats));
}
