#include <stdio.h>
#include <netdb.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include "neo.h"

void command_arpfind(int argc, char **argv) {
  neo_searchable s;
  neo_macaddr m;
  neo_location loc;
  neo_device *d;
  int ret;
  char buff[1024];
  char *ipaddr;
#ifdef MIT
  char *ptr, router[300];
#endif
  int i, j;

  argc--;
  argv++;

#ifdef MIT
  if (argc < 1) {
    printf("Usage: arpfind <host> [<location>]\n");
    return;
  }
#else
  if (argc != 2) {
    printf("Usage: arpfind <host> <location>\n");
    return;
  }
#endif
  
  /* translate the item */
  neo_searchable_create_from_string(&s, argv[0]);
  
  if (neo_searchable_primary_is_macaddr(&s)) {
    printf("You must supply an IP address or hostname\n");
    return;
  }

  /* we want the ip addr if we have the host */
  if (neo_searchable_primary_is_hostname(&s)) {
    ret=neo_searchable_expand_hostip(&s);
    if (ret) {
      printf("Could not find ip address for host %s\n", argv[0]);
      return;
    }
  }

  ipaddr=neo_searchable_get_ipaddr(&s);

#ifdef MIT
  if (argc==1) {
    /* here we will figure out which MITnet router to ask */
    /* in the future we'll want to look at something like -k to get a list of hosts */
    strcpy(router, ipaddr);
    ptr=strchr(router, '.');
    if (!ptr) {
      printf("Invalid IP address %s\n", ipaddr);
      return;
    }
    ptr=strchr(ptr+1, '.');
    if (!ptr) {
      printf("Invalid IP address %s\n", ipaddr);
      return;
    }
    if (!strncmp(ptr-2, ".7.", 3)) {
      /* one more for 18.7.x.y */
      ptr=strchr(ptr+1, '.');
      if (!ptr) {
	printf("Invalid IP address %s\n", ipaddr);
	return;
      }
      router[ptr-router]='\0';
      strcat(router, ".1");
    } else {
      router[ptr-router]='\0';
      strcat(router, ".0.1");
    }
    ret=neo_location_create_from_string(&loc, router);
    
  } else if (argc==2) {
    ret=neo_location_create_from_string(&loc, argv[1]);
    if (ret) {
      printf("Could not parse location %s\n", argv[1]);
      return;
    }
  }
#else
  ret=neo_location_create_from_string(&loc, argv[1]);
  if (ret) {
    printf("Could not parse location %s\n", argv[1]);
    return;
  }
#endif
  
  j=neo_location_num_hosts(&loc);
  for (i=0; i<j; i++) {
    d=neo_location_get_device_n(&loc, i);

    ret=neo_function_arpfind(&m, ipaddr, neo_device_get_name(d));
    if (!ret) {
      neo_macaddr_to_string(&m, buff);
      printf("%s says %s is %s\n", neo_device_get_name(d), ipaddr, buff);
    }
  }
  neo_location_free_elements(&loc);
}
