#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include "neo.h"

void summary_print_boards(neo_boardlist *s);
void summary_print_ports(neo_portlist *s);

void command_device(int argc, char **argv) {
  argc--;
  argv++;

  if (argc<1) {
    printf("Not enough arguments for 'device'.\n");
    return;
  }
  
  if (commatch(argv[0], "type", NULL)) {
    neo_command_device_type(g, --argc, ++argv);
  } else if (commatch(argv[0], "info", NULL)) {
    neo_command_device_info(--argc, ++argv);
  } else if (commatch(argv[0], "set", NULL)) {
    neo_command_device_set(--argc, ++argv);
  } else if (commatch(argv[0], "summary", "summ", "sum", "su", NULL)) {
    neo_command_device_summary(g, --argc, ++argv);
  } else if (commatch(argv[0], "reset", NULL)) {
    neo_command_device_reset(g, --argc, ++argv);
  } else if (commatch(argv[0], "download", "downl", NULL)) {
    neo_command_device_load("download", --argc, ++argv);
  } else if (commatch(argv[0], "upload", NULL)) {
    neo_command_device_load("upload", --argc, ++argv);
  } else if (commatch(argv[0], "uplink", NULL)) {
    neo_command_device_uplink(--argc, ++argv);
  } else {
    printf("Unknown 'device' subcommand '%s'\n", argv[0]);
    return;
  }
}

void neo_command_device_type(neo_global *g, int argc, char **argv) {
  int i,j;
  neo_location loc;
  neo_device *d;
  int ret;

  if (argc<1) {
    printf("Not enough arguments for locate.\n");
    return;
  }

  ret=neo_location_create_from_string(&loc, argv[0]);
  if (ret) {
    printf("Could not parse location %s\n", argv[0]);
    return;
  }

  neo_location_set_deviceconsts(&loc, g);
  
  j=neo_location_num_hosts(&loc);
  for (i=0; i<j; i++) {
    d=neo_location_get_device_n(&loc, i);
    if (!neo_device_is_probed(d)) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
    } else {
      printf("%s: %s\n", neo_device_get_name(d), neo_device_get_devname(d));
    }
  }

  neo_location_free_elements(&loc);
}

void neo_command_device_set(int argc, char **argv) {
  int i, j;
  neo_location loc;
  neo_device *d;
  int ret;
  char val[1024];
  char *obj;

  if (argc<3) {
    printf("Not enough arguments for set.\n");
    return;
  }

  ret=neo_location_create_from_string(&loc, argv[0]);
  if (ret) {
    printf("Could not parse location %s\n", argv[0]);
    return;
  }

  if (!strcasecmp(argv[1], "system")) {
    if (!strcasecmp(argv[2], "contact")) {
      obj=".1.3.6.1.2.1.1.4.0";
    } else if (!strcasecmp(argv[2], "name")) {
      obj=".1.3.6.1.2.1.1.5.0";
    } else if (!strcasecmp(argv[2], "location")) {
      obj=".1.3.6.1.2.1.1.6.0";
    } else {
      printf("Unknown system object.\n");
      return;
    }
    if (argc<4) {
      printf("No value specified.\n");
      return;
    }
    strcpy(val, "");
    for (i=0; i<argc-3; i++) {
      if (i>0) strcat(val, " ");
      strcat(val, argv[i+3]);
    }
  } else if (!strncmp(argv[1], ".1.3.6", 6)) {
    obj=argv[1];
    
    if (argc<3) {
      printf("No value specified.\n");
      return;
    }
    strcpy(val, "");
    for (i=0; i<argc-2; i++) {
      if (i>0) strcat(val, " ");
      strcat(val, argv[i+2]);
    }
  } else {
    printf("Unknown object.\n");
    return;
  }

  neo_location_set_deviceconsts(&loc, g); /* do we really need this ? */
  
  j=neo_location_num_hosts(&loc);
  for (i=0; i<j; i++) {
    d=neo_location_get_device_n(&loc, i);
    if (!neo_device_is_probed(d)) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
    } else {
      neo_snmp_set_by_variable(neo_device_get_name(d), obj, "string", val);
      printf("Value set.\n");
    }
  }
  
  neo_location_free_elements(&loc);
}



void neo_command_device_reset(neo_global *g, int argc, char **argv) {
  int i, j, ret;
  neo_device *d;
  neo_location loc;
  
  if (argc<1) {
    printf("You must supply a location.\n");
    return;
  }

  ret=neo_location_create_from_string(&loc, argv[0]);
  if (ret) {
    printf("Could not parse location %s\n", argv[0]);
    return;
  }

  neo_location_set_deviceconsts(&loc, g);

  j=neo_location_num_hosts(&loc);
  if (j>1) {
    printf("WARNING! You have specified more than one device to reset.\n");
    if (!are_you_sure(NULL)) return;
  }
  
  for (i=0; i<j; i++) {
    d=neo_location_get_device_n(&loc, i);
    if (!neo_device_is_probed(d)) {
      printf("Could not contact host %s.\n", neo_device_get_name(d));
    } else {
      neo_device_command_reset(d);
    }
  }
  neo_location_free_elements(&loc);
}



void neo_command_device_uplink(int argc, char **argv) {
  neo_locationlist ans;
  int ret, y, x;

  if (argc!=1) {
    printf("Please supply one hostname\n");
    return;
  }
  
  neo_locationlist_create(&ans);
  ret=neo_function_get_uplink(&ans, argv[0]);
  if (ret) {
    printf("device_uplink: error getting uplink");
    return;
  }
  
  y=neo_locationlist_get_size(&ans);
  if (y>0) {
    for (x=0; x<y; x++) {
      printf("Uplink found on %s\n", neo_location_get_instr(neo_locationlist_get_element(&ans, x)));
    }
  }
  neo_locationlist_free_all(&ans);
}


