#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "neo.h"

void neo_command_device_info(int argc, char **argv) {
  neo_location loc;
  neo_device *d;
  int type, i, j, ret;

  if (argc<1) {
    printf("Not enough arguments, you must supply a location.\n");
    return;
  }

  if (argc==1) {
    /* do 'device info system' for backwards compat */
    neo_command_device_info_system(argc, argv);
    return;
  }
      
  if (!strcmp(argv[0], "system")) {
    neo_command_device_info_system(--argc, ++argv);
    return;
  } else if (!strcmp(argv[0], "power")) {
    type=NEO_COMMAND_DEVICE_INFO_POWER;
  } else if (!strcmp(argv[0], "weather")) {
    type=NEO_COMMAND_DEVICE_INFO_WEATHER;
  } else if (!strcmp(argv[0], "cpu")) {
    type=NEO_COMMAND_DEVICE_INFO_CPU;
  } else if (!strcmp(argv[0], "printer")) {
    type=NEO_COMMAND_DEVICE_INFO_PRINTER;
  } else if (!strcmp(argv[0], "ups")) {
    type=NEO_COMMAND_DEVICE_INFO_UPS;
  } else {
    printf("Unknown subcommand '%s'.\n", argv[0]);
    return;
  }

  /* loop on devices */
  ret=neo_location_create_from_string(&loc, argv[1]);
  if (ret) {
    printf("Could not parse location %s\n", argv[1]);
    return;
  }
  neo_location_set_deviceconsts(&loc, g);
  
  j=neo_location_num_hosts(&loc);
  for (i=0; i<j; i++) {
    d=neo_location_get_device_n(&loc, i);
    if (!neo_device_is_probed(d)) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
    } else {
      neo_device_command_info(d, type);
    }
  }
}

void neo_command_device_info_system(int argc, char **argv) {
  int i,j;
  int days, hours, minutes;
  long up;
  neo_location loc;
  neo_device *d;
  int ret;
  char buff[1024];

  if (argc<1) {
    printf("Not enough arguments, you must supply a location.\n");
    return;
  }

  ret=neo_location_create_from_string(&loc, argv[0]);
  if (ret) {
    printf("Could not parse location %s\n", argv[0]);
    return;
  }
  neo_location_set_deviceconsts(&loc, g);
  
  j=neo_location_num_hosts(&loc);
  for (i=0; i<j; i++) {
    d=neo_location_get_device_n(&loc, i);
    if (!neo_device_is_probed(d)) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
    } else {
      printf("%s\n", neo_device_get_name(d));
      printf("  Device type: %s\n", neo_device_get_devname(d));

      ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.1.4.0", buff);
      if (ret) {
	printf("Error getting sysContact.\n");
      } else {
	printf("  Contact    : %s\n", buff);
      }

      ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.1.5.0", buff);
      if (ret) {
	printf("Error getting sysName.\n");
      } else {
	printf("  Name       : %s\n", buff);
      }

      ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.1.6.0", buff);
      if (ret) {
	printf("Error getting sysLocation.\n");
      } else {
	printf("  Location   : %s\n", buff);
      }

      ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.1.3.0", buff);
      if (ret) {
	printf("Error getting sysUpTime.\n");
      } else {
	buff[strlen(buff)-2]='\0'; /* chop off last two digits */
	up=atol(buff);
	days=up/86400;
	up-=days*86400;
	hours=up/3600;
	up-=hours*3600;
	minutes=up/60;
	up-=minutes*60;
	printf("  Uptime     : %i days %2.2i:%2.2i:%2.2li\n", days, hours, minutes, up);
      }

      ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.1.2.0", buff);
      if (ret) {
	printf("Error getting sysObjectID.\n");
      } else {
	printf("  ObjectID   : %s\n", buff);
      }

      ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.1.1.0", buff);
      if (ret) {
	printf("Error getting sysDescr.\n");
      } else {
	printf("  Descr      : %s\n", buff);
      }


    }
  }

  neo_location_free_elements(&loc);
}
