#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include "neo.h"

void neo_command_device_load(char *op, int argc, char **argv) {
  neo_location loc;
  neo_device *d;
  int ret, type, direction;
  char *typestr, *tftphost, *filename;
  
  if (argc!=4) {
    printf("Usage: %s image|config <location> <tftphost> <filename>\n", op);
    return;
  }

  typestr=argv[0];
  tftphost=argv[2];
  filename=argv[3];

  /* set the type */
  if (!strcmp(typestr, "image")) {
    type=NEO_COMMAND_DEVICE_LOAD_IMAGE;
  } else if (!strcmp(typestr, "config")) {
    type=NEO_COMMAND_DEVICE_LOAD_CONFIG;
  } else {
    printf("Usage: %s image|config <location> <tftphost> <filename>\n", op);
    return;
  }

  /* set the direction */
  if (!strcmp(op, "download")) {
    direction=NEO_COMMAND_DEVICE_LOAD_DOWNLOAD;
  } else if (!strcmp(op, "upload")) {
    direction=NEO_COMMAND_DEVICE_LOAD_UPLOAD;
  } else {
    printf("Internal error\n");
    neo_location_free_elements(&loc);
    return;
  }
  
  ret=neo_location_create_from_string(&loc, argv[1]);
  if (ret) {
    printf("Could not parse location %s\n", argv[1]);
    return;
  }
  if (!neo_location_is_simplehost(&loc)) {
    printf("Please only specify one host for this operation\n");
    neo_location_free_elements(&loc);
    return;
  }

  
  neo_location_set_deviceconsts(&loc, g);

  d=neo_location_get_first_device(&loc);
  if (!neo_device_is_probed(d)) {
    printf("Could not contact device %s\n", neo_device_get_name(d));
  } else {
    ret=neo_device_command_load(d, &loc, type, direction, tftphost, filename);
    if (ret) {
      printf("Error doing load\n");
    }
  }
  neo_location_free_elements(&loc);
}
