#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include "neo.h"

void command_help(int argc, char **argv) {
  FILE *pager;
  char *pstr;

  argc--;
  argv++;

  pstr=getenv("PAGER");
  /* if (!pstr) pstr=getenv("VISUAL"); */
  /* maybe try to look for more if we still haven't found anything */

  if (!pstr) {
    pager=stdout;
  } else {
    pager=popen(pstr, "w");
  }
  
  if (argc==0) {
    fprintf(pager,"\n");
    fprintf(pager,"Type 'help' followed by any of the following for specifics.\n");
    fprintf(pager,"\n");
    fprintf(pager,"General topics:\n");
    fprintf(pager,"  general  - general neo info\n");
    fprintf(pager,"  version  - version specific information\n");
    fprintf(pager,"  syntax   - the location syntax\n");
    fprintf(pager,"  args     - arguments to neo\n");
    fprintf(pager,"  sample   - sample commands\n");
    fprintf(pager,"\n");
    fprintf(pager,"Neo commands:\n");
    fprintf(pager,"  arpfind   - translate ip to macaddress\n"); /* or vica-versa */
    fprintf(pager,"  locate    - locate a host\n");
    fprintf(pager,"  port      - get the status of a port, turn it on or off, find the\n");
    fprintf(pager,"                hosts on a port etc.\n");
    fprintf(pager,"  device    - device specific commands\n");
    fprintf(pager,"  stats     - network usage statistics\n");
    /*    fprintf(pager,"  network   -\n"); */
    fprintf(pager,"  location  - print attributes of a location\n");
    fprintf(pager,"  set       - set variables\n");
    fprintf(pager,"  print     - print variables\n");
    fprintf(pager,"  hostinfo  - get host information\n");
    fprintf(pager,"  exec      - exec a shell command\n");
    fprintf(pager,"  help      - help\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "arpfind")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (arpfind)\n");
    fprintf(pager,"\n");
    fprintf(pager,"NAME\n");
    fprintf(pager,"   arpfind - look up the mac address of a host in the router's arpcache\n");
    fprintf(pager,"\n");
    fprintf(pager,"SYNOPSYS\n");
#ifdef MIT    
    fprintf(pager,"   arpfind <hostname> [<router>]\n");
#else
    fprintf(pager,"   arpfind <hostname> <router>\n");
#endif
    fprintf(pager,"\n");
    fprintf(pager,"DESCRIPTION\n");
#ifdef MIT
    fprintf(pager,"   Arpfind will look up the mac address of <hostname> on the appropriate\n");
    fprintf(pager,"   router or on the router specified.  Note that because this build has\n");
    fprintf(pager,"   MIT extensions the <router> argument is not required, as it is at other\n");
    fprintf(pager,"   places.\n");
#else
    fprintf(pager,"   Arpfind will look up the mac address of <hostname> on <router>\n");
#endif
    fprintf(pager,"\n");
    fprintf(pager,"OPTIONS\n");
    fprintf(pager,"\n");
    fprintf(pager,"BUGS\n");
    fprintf(pager,"   Doesn't do reverse lookups yet\n\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "locate")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (locate)\n");
    fprintf(pager,"\n");
    fprintf(pager,"NAME\n");
    fprintf(pager,"   locate - locate a node on a set of devices\n");
    fprintf(pager,"\n");
    fprintf(pager,"SYNOPSYS\n");
    fprintf(pager,"   locate [-v] <mac> <location>\n");
    /* fprintf(pager,"   locate [-v] <ipaddr>|<macaddr> <location>\n"); */
    /* fprintf(pager,"   locate [-v] [-p ip|mac] <ipaddr>|<macaddr> [-k <key>]\n"); */
    fprintf(pager,"\n");
    fprintf(pager,"DESCRIPTION\n");
    fprintf(pager,"   locate will search the devices in <location> for the presence\n");
    fprintf(pager,"   of the given mac address on any of its ports.\n");
    fprintf(pager,"\n");
    fprintf(pager,"OPTIONS\n");
    fprintf(pager,"   -v  Verbose.  Display the name of each device as it's being searched\n");
    fprintf(pager,"\n");
    /*
    fprintf(pager,"BUGS\n");
    fprintf(pager,"   Doesn't let you force an ip or mac lookup yet.\n\n");
    fprintf(pager,"   Doesn't do a hostname lookup if not forced.\n\n");
    fprintf(pager,"\n");
    */
  } else  if (!strcmp(argv[0], "port")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (port)\n");
    fprintf(pager,"\n");
    fprintf(pager,"NAME\n");
    fprintf(pager,"   port - check the status of a port, enable it, disable, or lookup hosts\n");
    fprintf(pager,"          using it\n");
    fprintf(pager,"\n");
    fprintf(pager,"SYNOPSYS\n");
    fprintf(pager,"   port status|enable|disable <location>\n");
    fprintf(pager,"   port search <location>\n");
    fprintf(pager,"\n");
    fprintf(pager,"DESCRIPTION\n");
    fprintf(pager,"   The port command can modify or check the admin status of a drop with the.\n");
    fprintf(pager,"   'enable', 'disable' and 'status' sub-commands.\n");
    fprintf(pager,"\n");
    fprintf(pager,"   The 'search' sub-command will return the mac addresses a device as seen on\n");
    fprintf(pager,"   a port.\n");
    fprintf(pager,"\n");
    fprintf(pager,"OPTIONS\n");
    fprintf(pager,"   enable   turn the drop on\n");
    fprintf(pager,"\n");
    fprintf(pager,"   disable  turn the drop off\n");
    fprintf(pager,"\n");
    fprintf(pager,"   status   check the status of the drop\n");
    fprintf(pager,"\n");
    fprintf(pager,"   search   search for the mac addresses on this port\n");
    fprintf(pager,"\n");
    fprintf(pager,"BUGS\n");
    fprintf(pager,"   Search is not yet supported, but is implemented for some devices.\n");
    fprintf(pager,"\n");
    fprintf(pager,"   There are other port commands to be done, i.e. duplex, bulk-disable, \n");
    fprintf(pager,"   bulk-enable, info, etc.\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "stats")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (stats)\n");
    fprintf(pager,"\n");
    fprintf(pager,"NAME\n");
    fprintf(pager,"   stats - get network statistics.\n");
    fprintf(pager,"\n");
    fprintf(pager,"SYNOPSYS\n");
    fprintf(pager,"   stats <location>\n");
    fprintf(pager,"\n");
    fprintf(pager,"DESCRIPTION\n");
    fprintf(pager,"   The stats command gets network statics on a device or a group of devices.\n");
    fprintf(pager,"   This may include bandwidth usage, pps stats, link status etc.\n");
    fprintf(pager,"\n");
    fprintf(pager,"OPTIONS\n");
    fprintf(pager,"\n");
    fprintf(pager,"BUGS\n");
    fprintf(pager,"   Stats does not yet work across multiple devices at the same time.\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "location")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                        (location)\n");
    fprintf(pager,"\n");
    fprintf(pager,"NAME\n");
    fprintf(pager,"   location - print attributes of a location\n");
    fprintf(pager,"\n");
    fprintf(pager,"SYNOPSYS\n");
    fprintf(pager,"   location print <location>\n");
    fprintf(pager,"\n");
    fprintf(pager,"DESCRIPTION\n");
    fprintf(pager,"   The location print command will display all devices associated with\n");
    fprintf(pager,"   the named location.  For example 'location print @k:18.18' will list\n");
    fprintf(pager,"   all the devices in the keys file for 18.18.  For another example:\n");
    fprintf(pager,"\n");
    fprintf(pager,"      neo: location print 2/4@foo,bar\n");
    fprintf(pager,"      Devices (2) are:\n");
    fprintf(pager,"      foo\n");
    fprintf(pager,"      bar\n");
    fprintf(pager,"\n");
    fprintf(pager,"OPTIONS\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "print")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (print)\n");
    fprintf(pager,"\n");
    fprintf(pager,"NAME\n");
    fprintf(pager,"   print - print a variable's value.\n");
    fprintf(pager,"\n");
    fprintf(pager,"SYNOPSYS\n");
    fprintf(pager,"   print [ <variable> ]\n");
    fprintf(pager,"\n");
    fprintf(pager,"DESCRIPTION\n");
    fprintf(pager,"   Print the value of <variable>.  If no variable is specified then all\n");
    fprintf(pager,"   variable values are printed.\n");
    fprintf(pager,"\n");
    fprintf(pager,"   Legal variables are:\n");
    fprintf(pager,"      writecom\n");
    fprintf(pager,"      readcom\n");
    fprintf(pager,"      keyfile\n");
    fprintf(pager,"      timeout\n");
    fprintf(pager,"      statsdelay\n");
    fprintf(pager,"      macmode\n");
    fprintf(pager,"      version\n");
    fprintf(pager,"\n");
    fprintf(pager,"   For more information on the meaning of each variable consult 'help set'.\n");
    fprintf(pager,"\n");
    fprintf(pager,"OPTIONS\n");
    fprintf(pager,"\n");
    fprintf(pager,"BUGS\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "set")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (set)\n");
    fprintf(pager,"\n");
    fprintf(pager,"NAME\n");
    fprintf(pager,"   set - set a variable's value.\n");
    fprintf(pager,"\n");
    fprintf(pager,"SYNOPSYS\n");
    fprintf(pager,"   set <variable> [ <value> ]\n");
    fprintf(pager,"\n");
    fprintf(pager,"DESCRIPTION\n");
    fprintf(pager,"   Set the value of a <variable> to <value>.  If the variable is either\n");
    fprintf(pager,"   writecom or readcom you may leave the value off the line and you'll be\n");
    fprintf(pager,"   prompted to enter it on a line where your keystrokes will not be\n");
    fprintf(pager,"   echoed.\n");
    fprintf(pager,"\n");
    fprintf(pager,"   Legal variables are:\n");
    fprintf(pager,"      writecom\n");
    fprintf(pager,"      readcom\n");
    fprintf(pager,"      keyfile\n");
    fprintf(pager,"      timeout\n");
    fprintf(pager,"      statsdelay\n");
    fprintf(pager,"      macmode\n");
    fprintf(pager,"\n");
    fprintf(pager,"   writecom:\n");
    fprintf(pager,"      This sets the SNMP community used for write requests.  It can be\n");
    fprintf(pager,"      set to any string and is case sensitive.\n");
    fprintf(pager,"   readcom:\n");
    fprintf(pager,"      This sets the SNMP community used for read requests.  It can be\n");
    fprintf(pager,"      set to any string and is case sensitive.\n");
    fprintf(pager,"   keyfile:\n");
    fprintf(pager,"      This sets the name of the file used to do keyfile lookups (@k:<key>)\n");
    fprintf(pager,"      See 'help syntax' for further information on the keyfile.\n");
    fprintf(pager,"   timeout:\n");
    fprintf(pager,"      This sets the time in seconds that neo should wait for responses\n");
    fprintf(pager,"      to SNMP queries.  The default is 8 seconds.\n");
    fprintf(pager,"   statsdelay:\n");
    fprintf(pager,"      This sets the minimum amount of time in seconds for the delta in\n");
    fprintf(pager,"      stats gathering.  The default is 2 seconds.\n");
    fprintf(pager,"   macmode:\n");
    fprintf(pager,"      This sets the format that should be used for displaying mac\n");
    fprintf(pager,"      addresses.  Valid options are 'standard', 'cisco', and 'dash'.\n");
    fprintf(pager,"\n");
    fprintf(pager,"OPTIONS\n");
    fprintf(pager,"\n");
    fprintf(pager,"BUGS\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "sample")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (sample)\n");
    fprintf(pager,"\n");
    fprintf(pager,"Locating a host:\n");
    fprintf(pager,"\n");
#ifdef MIT
    fprintf(pager,"  neo:  arpfind plugs-out\n");
#else
    fprintf(pager,"  neo:  arpfind plugs-out nw12-rtr-bb\n");
#endif
    fprintf(pager,"  18.18.0.1 says 18.18.1.101 is 08:00:20:7D:48:1B\n");
    fprintf(pager,"  neo:  locate 08:00:20:7D:48:1B @k:18.18\n");
    fprintf(pager,"  Found on 2/14@W92-165T-SW-ENTRY\n");
    fprintf(pager,"  Found on 3@W92-165T-SW-13\n");
    fprintf(pager,"\n");
    fprintf(pager,"Disabling a drop:\n");
    fprintf(pager,"\n");
    fprintf(pager,"  neo:  set writecom foobar\n");
    fprintf(pager,"  neo:  port disable 3@W92-165T-SW-13\n");
    fprintf(pager,"  3@W92-165T-SW-13 disabled\n");
    fprintf(pager,"\n");
    fprintf(pager,"Getting a sumary of connections on a device:\n");
    fprintf(pager,"\n");
    fprintf(pager,"  neo:  device summary w20-410t-rep-1\n");
    fprintf(pager,"  Board summary:\n");
    fprintf(pager,"   b type       sg  ul ultype     \n");
    fprintf(pager,"  -------------------------------\n");
    fprintf(pager,"   1 Mgmt        1                \n");
    fprintf(pager,"   2 RJ21-Top*   1  10 UTP-MAU    \n");
    fprintf(pager,"   3 RJ21-Bot*   1                \n");
    fprintf(pager,"   4 RJ21-Top*   2                \n");
    fprintf(pager,"   5 RJ21-Bot*   2                \n");
    fprintf(pager,"   6 RJ21-Top*   2  10 UTP-MAU    \n");
    fprintf(pager,"   7 RJ21-Bot*   2                \n");
    fprintf(pager,"\n");
    fprintf(pager,"  neo:  dev sum 2/*@w20-410t-rep-1\n", "*/"); /* hilight mode eit */
    fprintf(pager,"  Port summary:\n");
    fprintf(pager,"   p type  u lnk adm ap\n");
    fprintf(pager,"  ---------------------\n");
    fprintf(pager,"   1 10T       -  On \n");
    fprintf(pager,"   2 10T      10  On \n");
    fprintf(pager,"   3 10T       -  On \n");
    fprintf(pager,"   4 10T      10  On \n");
    fprintf(pager,"   5 10T      10  On \n");
    fprintf(pager,"   6 10T      10  On \n");
    fprintf(pager,"   7 10T      10  On \n");
    fprintf(pager,"   8 10T      10  On \n");
    fprintf(pager,"   9 10T      10  On \n");
    fprintf(pager,"  10 10T       -  On \n");
    fprintf(pager,"  11 10T      10  On \n");
    fprintf(pager,"  12 10T      10  On \n");
    fprintf(pager,"  13 UTP-M *  10  On \n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "syntax")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (syntax)\n");
    fprintf(pager,"\n");
    fprintf(pager,"The location syntax is made up of two parts: the board and/or port and host\n");
    fprintf(pager,"or hosts involved.  For example board 5, port 2 on w92-165t-sw-entry is\n");
    fprintf(pager,"reperesented as:\n");
    fprintf(pager,"\n");
    fprintf(pager,"         5/2@w92-165t-sw-entry\n");
    fprintf(pager,"\n");
    fprintf(pager,"If the device doesn't have any boards, then only the port is given, as in:\n");
    fprintf(pager,"\n");
    fprintf(pager,"          3@w92-165t-sw-13\n");
    fprintf(pager,"\n");
    fprintf(pager,"If you need to refer to a board itself and not any particular port on that\n");
    fprintf(pager,"board use:\n");
    fprintf(pager,"\n");
    fprintf(pager,"         5/@w92-165t-sw-entry\n");
    fprintf(pager,"\n");
    fprintf(pager,"Which would refer to board 5 on that device.  You can also use an asterisk\n");
    fprintf(pager,"('*') to denote multiple boards or ports.  To refer to all ports on a device\n");
    fprintf(pager,"with no boards you would use:\n");
    fprintf(pager,"\n");
    fprintf(pager,"          *@w92-165t-sw-13\n");
    fprintf(pager,"\n");
    fprintf(pager,"If the device does have boards then you can do a number of different things\n");
    fprintf(pager,"to refer to different groups of ports or boards.  I.e.:\n");
    fprintf(pager,"\n");
    fprintf(pager,"          */@w92-165t-sw-entry       all boards\n");
    fprintf(pager,"         */*@w92-165t-sw-entry       all ports (on all boards)\n");
    fprintf(pager,"         5/*@w92-165t-sw-entry       all ports on board 5\n");
    fprintf(pager,"\n");
    fprintf(pager,"You can also use a period ('.') in place of an asterisk.\n");
    fprintf(pager,"\n");
    fprintf(pager,"If you need to specify a host, and not any boards or ports on that host, just\n");
    fprintf(pager,"use:\n");
    fprintf(pager,"\n");
    fprintf(pager,"         @w92-165t-sw-1\n");
    fprintf(pager,"\n");
    fprintf(pager,"If you need to refer to a small list of hosts you can use:\n");
    fprintf(pager,"\n");
    fprintf(pager,"         @w92-165t-sw-1,w92-165t-sw-2,w92-165t-sw-3\n");
    fprintf(pager,"\n");
    fprintf(pager,"If you need to refer to a list of hosts from a file:\n");
    fprintf(pager,"         @f:/var/tmp/hostlist\n");
    fprintf(pager,"\n");
    fprintf(pager,"And if you need to refer to hosts matching a key from a keyfile:\n");
    fprintf(pager,"\n");
    fprintf(pager,"         @k:18.18\n");
    fprintf(pager,"\n");
    fprintf(pager,"You can also mix and match the above board and port possiblities with\n");
    fprintf(pager,"the host options.  For example:\n");
    fprintf(pager,"\n");
    fprintf(pager,"         3/*@k:18.18\n");
    fprintf(pager,"\n");
    fprintf(pager,"would be all ports on board 3 on every device on 18.18.  Which is kind of\n");
    fprintf(pager,"silly, granted.\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "general")) {
    fprintf(pager,"\n");
    fprintf(pager,"Neo is a free network administration tool.  It works across multiple\n");
    fprintf(pager,"types of network hardware and is designed so that it is easy to add\n");
    fprintf(pager,"support for new types of hardware.  If you write modules for new hardware\n");
    fprintf(pager,"or have hardware I can test against for new modules send mail to\n");
    fprintf(pager,"bug-neo@mit.edu\n");
    fprintf(pager,"\n");
    fprintf(pager,"This is neo version %s  The neo distribution is available at\n", neo_global_get_version(g));
    fprintf(pager,"http://web.mit.edu/ktools.  Check there for new releases and other information.\n");
    fprintf(pager,"\n");
    fprintf(pager,"Neo was written by James Kretchmar at the Massachusetts Institute of Technology.\n");
    fprintf(pager,"\n");
    fprintf(pager,"\n");
    fprintf(pager,"Copyright 2000 by the Massachusetts Institute of Technology.\n");
    fprintf(pager,"\n");
    fprintf(pager,"Permission to use, copy, modify, and distribute this\n");
    fprintf(pager,"software and its documentation for any purpose and without\n");
    fprintf(pager,"fee is hereby granted, provided that the above copyright\n");
    fprintf(pager,"notice appear in all copies and that both that copyright\n");
    fprintf(pager,"notice and this permission notice appear in supporting\n");
    fprintf(pager,"documentation, and that the name of M.I.T. not be used in\n");
    fprintf(pager,"advertising or publicity pertaining to distribution of the\n");
    fprintf(pager,"software without specific, written prior permission.\n");
    fprintf(pager,"M.I.T. makes no representations about the suitability of\n");
    fprintf(pager,"this software for any purpose.  It is provided \"as is\"\n");
    fprintf(pager,"without express or implied warranty.\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "device")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (device)\n");
    fprintf(pager,"\n");
    fprintf(pager,"NAME\n");
    fprintf(pager,"   device - get information about a device\n");
    fprintf(pager,"\n");
    fprintf(pager,"SYNOPSYS\n");
    fprintf(pager,"   device type <location>\n");
    fprintf(pager,"   device summary <location>\n");
    fprintf(pager,"   device info <location>\n");
    fprintf(pager,"   device info weather <location>\n");
    fprintf(pager,"   device info power <location>\n");
    fprintf(pager,"\n");
    fprintf(pager,"DESCRIPTION\n");
    fprintf(pager,"   The 'device type' command will display what kind of device the location is.\n");
    fprintf(pager,"   The 'device summary' command will print a summary of the connections in\n");
    fprintf(pager,"   use at the location.\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "args")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (args)\n");
    fprintf(pager,"\n");
    fprintf(pager,"  Neo can execute any of it's commands on the command line.  In addition\n");
    fprintf(pager,"  the following command line arguments are avaliable:\n");
    fprintf(pager,"\n");
    fprintf(pager,"  -k <keyfile>\n");
    fprintf(pager,"        Set the kefyile to <keyfile>.\n");
    fprintf(pager,"\n");
    fprintf(pager,"  -w <community>\n");
    fprintf(pager,"        Set the write community to <community>.\n");
    fprintf(pager,"\n");
    fprintf(pager,"  -r <community>\n");
    fprintf(pager,"        Set the read community to <community>.\n");
    fprintf(pager,"\n");
    fprintf(pager,"  -c <community>\n");
    fprintf(pager,"        Set both the read and write communities to <community>\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "hostinfo")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (hostinfo)\n");
    fprintf(pager,"\n");
    fprintf(pager,"NAME\n");
    fprintf(pager,"   hostinfo - look information on a host or ip address.\n");
    fprintf(pager,"\n");
    fprintf(pager,"SYNOPSYS\n");
    fprintf(pager,"   hostinfo <host>\n");
    fprintf(pager,"\n");
    fprintf(pager,"DESCRIPTION\n");
    fprintf(pager,"   Hostinfo will return the ip address, hostname and hostinfo of the\n");
    fprintf(pager,"   specified host.\n");
    fprintf(pager,"\n");
    fprintf(pager,"OPTIONS\n");
    fprintf(pager,"\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "exec")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                           (exec)\n");
    fprintf(pager,"\n");
    fprintf(pager,"NAME\n");
    fprintf(pager,"   exec - exec a shell command.\n");
    fprintf(pager,"\n");
    fprintf(pager,"SYNOPSYS\n");
    fprintf(pager,"   exec <command>\n");
    fprintf(pager,"\n");
    fprintf(pager,"DESCRIPTION\n");
    fprintf(pager,"   exec runs the specified command in a subshell.\n");
    fprintf(pager,"\n");
  } else if (!strcmp(argv[0], "version")) {
    fprintf(pager,"\n");
    fprintf(pager,"neo help                                                        (version)\n");
    fprintf(pager,"\n");
    fprintf(pager,"This is neo version %s.  Major new features for\n", neo_global_get_version(g));
    fprintf(pager,"recent versions are:\n");
    fprintf(pager,"\n");
    fprintf(pager,"     Support for MGE UPS's\n");
    fprintf(pager,"     Support for using the standard bridge mib on unknown devices\n");
    fprintf(pager,"     Support for HP2524 switch\n");
    fprintf(pager,"     Support for HP Printers\n");
    fprintf(pager,"     Support for the Cisco 4500 router\n");
    fprintf(pager,"     'dev info cpu' for Cisco routers\n");
    fprintf(pager,"     -u option to locate\n");
    fprintf(pager,"\n");
    fprintf(pager,"The devices fully supported in this version are:\n");
    fprintf(pager,"\n");
    fprintf(pager,"     Cabletron 2200\n");
    fprintf(pager,"     Asante 2072\n");
    fprintf(pager,"     Asante 1012\n");
    fprintf(pager,"     Asante 5324\n");
    fprintf(pager,"     Catalyst 2948\n");
    fprintf(pager,"     Catalyst 4000\n");
    fprintf(pager,"     Catalyst 5000\n");
    fprintf(pager,"     Catalyst 5002\n");
    fprintf(pager,"     Cisco 2500 Router\n");
    fprintf(pager,"     Cisco 2600 Router\n");
    fprintf(pager,"     Cisco 3500 Router\n");
    fprintf(pager,"     Cisco 4500 Router\n");
    fprintf(pager,"     Cisco 6509 Router\n");
    fprintf(pager,"     Cisco 7500 Router\n");
    fprintf(pager,"     Cisco 8500 Router\n");
    fprintf(pager,"     Extreme Summit 1i\n");
    fprintf(pager,"     Extreme Summit 24\n");
    fprintf(pager,"     Extreme Summit 48\n");
    fprintf(pager,"     Extreme Alpine\n");
    fprintf(pager,"     Extreme Black Diamond\n");
    fprintf(pager,"     Lucent WavePoint 1000\n");
    fprintf(pager,"     Cisco Aironet\n");
    fprintf(pager,"     HP Printers\n");
    fprintf(pager,"     APC UPS's\n");
    fprintf(pager,"\n");
    fprintf(pager,"The functions fully supported in this version are:\n");
    fprintf(pager,"\n");
    fprintf(pager,"     locate\n");
    fprintf(pager,"     port enable/disable\n");
    fprintf(pager,"     port search\n");
    fprintf(pager,"     arpfind\n");
    fprintf(pager,"     device summary\n");
    fprintf(pager,"     device info\n");
    fprintf(pager,"     stats\n");
    fprintf(pager,"     help\n");
    fprintf(pager,"\n");
    fprintf(pager,"Every supported function that applies to a specific device is fully\n");
    fprintf(pager,"supported for all supported devices.\n");
    fprintf(pager,"\n");
    fprintf(pager,"The following functions are not fully supported, but may work on some\n");
    fprintf(pager,"devices.  More support is being worked on:\n");
    fprintf(pager,"\n");
    fprintf(pager,"     board statistics\n");
    fprintf(pager,"     device statistics\n");
    fprintf(pager,"     device reset\n");
    fprintf(pager,"\n");
    fprintf(pager,"The current functionality grid is below.  Note that even if a function\n");
    fprintf(pager,"is available on a device it is only gaurenteed to work if it is a\n");
    fprintf(pager,"supported device and a supported function for this release.\n");
    fprintf(pager,"\n");
    fprintf(pager,"             psed  locate  pstats dstats  search reset\n");
    fprintf(pager,"cab 2200       *      *       *              *        \n");
    fprintf(pager,"asn 5324       *      *       *              *        \n");
    fprintf(pager,"asn 2072       *      *       *              *     *  \n");
    fprintf(pager,"asn 1012       *      *       *              *     *  \n");
    fprintf(pager,"cat 2948       *      *       *              *        \n");
    fprintf(pager,"cat 4000       *      *       *              *        \n");
    fprintf(pager,"cat 5000       *      *       *              *        \n");
    fprintf(pager,"ext summit1    *      *       *              *        \n");
    fprintf(pager,"ext summit48   *      *       *              *        \n");
    fprintf(pager,"ext alpine     *      *       *              *        \n");
    fprintf(pager,"ext blackdia   *      *       *              *        \n");
    fprintf(pager,"lucentwav      -      *       -              *     *  \n");
    fprintf(pager,"Cisco Aironet  -      *       -              *     -  \n");
    fprintf(pager,"Cisco rtr 7500 *      -       *              -        \n");
    fprintf(pager,"Cisco rtr 8540                                        \n");
    fprintf(pager,"Cisco rtr 6509                                        \n");
    fprintf(pager,"Cisco rtr oth.                                        \n");
    fprintf(pager,"HP Printer                                         *  \n");
    
    fprintf(pager,"\n");
  } else {
    fprintf(pager, "No help is avaliable on that topic.\n");
  }
  if (pstr) pclose(pager);
  return;
}
