#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <resolv.h>
#include <arpa/nameser.h>
#include <string.h>
#include "neo.h"

void command_hostinfo(int argc, char **argv) {
  struct hostent *he;
  struct sockaddr_in addr;
  char answer[PACKETSZ], buff[1024];
  int ret, i, len;
  const HEADER *hp;
  char *foo;

  argc--;
  argv++;

  if (argc<1) {
    printf("Not enough arguments to the 'hostinfo' command.\n");
    return;
  }


  /* printf("Desired host:   %s\n", argv[0]); */

  he=gethostbyname(argv[0]);
  if (!he) {
    printf("Could not resolve hostname '%s'.\n", argv[0]);
    return;
  }
  memcpy(&(addr.sin_addr.s_addr), he->h_addr, he->h_length);
  he=gethostbyaddr((char *) &(addr.sin_addr), sizeof(addr.sin_addr), AF_INET);

  if (!he) {
    printf("Could not resolve hostname '%s'.\n", argv[0]);
    return;
  }
  printf("Official name:  %s\n", he->h_name);
  printf("Host address:   %s\n", inet_ntoa(addr.sin_addr));


  /* query for hinfo */
  ret=res_query(he->h_name, C_IN, T_HINFO, answer, sizeof(answer));
  hp=(HEADER *) answer;
  if (hp->ancount==0) return; /* no hostinfo to return */
  if (ret<0 || hp->rcode != NOERROR) {
    perror("Error in res_query");
    return;
  }

  /* see RFC 1035 */
  
  /* skip through the question section */
  foo=answer+HFIXEDSZ;
  for (i=0; i<ntohs(hp->qdcount); i++) {
    foo=strchr(foo, '\0'); /* this is sort of cheating */
    if (!foo) {
      printf("Error.\n");
      return;
    }
    foo+=5; /* 1 + 4 */
  }
  
  /* now the answers */
  for (i=0; i<ntohs(hp->ancount); i++) {
    if ((((unsigned char) foo[0]) & 0xc0) == 0xc0) {
      /* it's compressed format */
      /* just skip the next byte */
      foo+=2;
    } else {
      foo+=((unsigned char) foo[0])+1;
    }
    
    if (((unsigned char) foo[1]) != 13) {
      /* it's not hinfo, so figure out where the next answer starts */
      foo+=2+2+4; /* this + type + ttl */
      /* now get the length */
      len=((unsigned char)foo[0])<<8;
      len+=(unsigned char)foo[1];
      foo+=2+len;
      continue;
    }
    foo+=2;
    
    if (((unsigned char) foo[1]) != 1) {
      printf("Unexpected type field in DNS response.\n");
      return;
    }
    foo+=2;
    
    /* skip the ttl */
    foo+=4;
    
    /* skip the length for now */
    foo+=2;
    
    len=(unsigned char) foo[0];
    foo++;
    strncpy(buff, foo, len);
    buff[len]='\0';
    printf("Host CPU:       %s\n", buff);
    foo+=len;
    
    len=(unsigned char) foo[0];
    foo++;
    strncpy(buff, foo, len);
    buff[len]='\0';
    printf("Host OS:        %s\n", buff);
  }
}
