#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include "neo.h"

void command_locate(int argc, char **argv) {
  int verbose, ret, i, j, findcount, uplink;
  neo_searchable s;
  neo_location loc;
  neo_locationlist ans;
  neo_device *d;

  argc--;
  argv++;

  verbose=0;
  uplink=0;
  while (argc>2) {
    if (!strcmp(argv[0], "-v")) {
      verbose=1;
      argv++;
      argc--;
    } else if (!strcmp(argv[0], "-u")) {
      uplink=1;
      argv++;
      argc--;
    } else {
      printf("Invalid argument to the locate.\n");
      return;
    }
  }
      
  if (argc!=2) {
    printf("Not enough arguments for locate.\n");
    return;
  }

  neo_searchable_create_from_string(&s, argv[0]);

  if (!neo_searchable_primary_is_macaddr(&s)) {
    printf("You must specify a macaddress for searching\n");
    return;
  }
  
  argv++;
  argc--;

  ret=neo_location_create_from_string(&loc, argv[0]);
  if (ret) {
    printf("Could not parse location %s\n", argv[0]);
    return;
  }

  if (verbose) printf("Probing devices ...\n");
  neo_location_set_deviceconsts(&loc, g);

  findcount=0;
  j=neo_location_num_hosts(&loc);
  if (j==0) printf("No devices selected\n");
  for (i=0; i<j; i++) {
    d=neo_location_get_device_n(&loc, i);
    if (!neo_device_is_probed(d)) {
      if (verbose) printf("Skipping device %s\n", neo_device_get_name(d));
    } else {
      if (verbose) printf("Searching %s ...\n", neo_device_get_name(d));
      neo_locationlist_create(&ans);
      ret=neo_device_command_locate(d, &s, &ans, uplink);
      if (ret<0) {
	if (neo_error==NEO_ERR_INCAPABLE) {
	  printf("Incapable of doing locates on %s which is a %s\n", neo_device_get_name(d), neo_device_get_devname(d));
	} else if (neo_error==NEO_ERR_CONTACT) {
	  printf("Could not contact device %s\n", neo_device_get_name(d));
	} else {
	  printf("Error doing locates on %s\n", neo_device_get_name(d));
	}
      } else {
	int x, y;
	y=neo_locationlist_get_size(&ans);
	findcount+=y;
	if (y>0) {
	  for (x=0; x<y; x++) {
	    printf("Found on %s\n", neo_location_get_instr(neo_locationlist_get_element(&ans, x)));
	  }
	}
      }
      neo_locationlist_free_all(&ans);
    }
  }

  if (findcount==0) {
    printf("Not found\n");
  }

  if (verbose && findcount) {
    printf("%i locations found\n", findcount);
  }

  neo_location_free_elements(&loc);
}

int neo_command_locate_standardbridge_helper(neo_device *d, neo_searchable *s) {
  /* return the port number or -1 if there was a problem.  don't touch neo_error */
  neo_macaddr *m;
  char obj[1024], tmp[300], val[30];
  int ret;

  m=neo_searchable_get_macaddr(s);
  neo_macaddr_to_dotted_ints_string(m, tmp);

  strcpy(obj, ".1.3.6.1.2.1.17.4.3.1.2.");
  strcat(obj, tmp);

  ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
    
  if (ret) {
    return(ret);
  }
  return(atoi(val));
}
