#include <stdio.h>
#include "neo.h"

void command_location(int argc, char **argv) {
  argc--;
  argv++;

  if (argc<1) {
    printf("Not enough arguments for the 'location' command.\n");
    return;
  }

  if (commatch(argv[0], "print", "pr", NULL)) {
    command_location_print(--argc, ++argv);
  } else {
    printf("Unknown subcommand '%s' to location command.\n", argv[0]);
    return;
  }
  return;
}

void command_location_print(int argc, char **argv) {
  int ret, i, j;
  neo_location loc;
  
  ret=neo_location_create_from_string(&loc, argv[0]);
  if (ret) {
    printf("Could not parse location %s\n", argv[0]);
    return;
  }

  j=neo_location_num_hosts(&loc);
  if (j==0) {
    printf("No devices in location %s.\n", argv[0]);
    return;
  }

  printf("Devices (%i) are:\n", j);
  for (i=0; i<j; i++) {
    printf("  %s\n", neo_device_get_name(neo_location_get_device_n(&loc, i)));
  }
  return;
}
