#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "neo.h"

void command_port(int argc, char **argv) {
  argc--;
  argv++;

  if (argc<1) {
    printf("Not enough arguments to port command.\n");
    return;
  }
  
  if (commatch(argv[0], "enable", "ena", "en", NULL)) {
    command_port_sed(g, argc, argv);
  } else if (commatch(argv[0], "disable", "dis", NULL)) {
    command_port_sed(g, argc, argv);
  } else if (commatch(argv[0], "status", "sta", "stat", NULL)) {
    command_port_sed(g, argc, argv);
  } else if (commatch(argv[0], "search", NULL)) {
    command_port_search(g, argc, argv);
  } else if (commatch(argv[0], "summary", "summ", "sum", "su", NULL)) {
    argc--; argv++;
    neo_command_device_summary(g, argc, argv);
  } else {
    printf("Invalid argument '%s' to port command.\n", argv[0]);
    return;
  }
}

void command_port_sed(neo_global *g, int argc, char **argv) {
  int command=0, ret, i, j;
  neo_location loc;
  neo_device *d;
#ifdef MIT
  char buff[1024];
#endif

  if (commatch(argv[0], "enable", "ena", "en", NULL)) {
    command=NEO_COMMAND_PORT_ENABLE;
  } else if (commatch(argv[0], "disable", "dis", NULL)) {
    command=NEO_COMMAND_PORT_DISABLE;
  } else if (commatch(argv[0], "status", "sta", "stat", NULL)) {
    command=NEO_COMMAND_PORT_STATUS;
  }
  
  argc--;
  argv++;
  
  if (argc>1) {
    printf("Sorry, only one location for now.\n");
    return;
  } else if (argc<1) {
    printf("Not enough arguments\n");
    return;
  }

  ret=neo_location_create_from_string(&loc, argv[0]);
  if (ret) {
    printf("Could not parse location %s\n", argv[0]);
    return;
  }

  if (neo_location_star_board(&loc)) {
    printf("You can not currently access multiple boards at a time.\n");
    return;
  }
  if (neo_location_star_port(&loc)) {
    printf("You can not currently access multiple ports at a time.\n");
    return;
  }
  if (!neo_location_has_port(&loc)) {
    printf("You must specify a port to access\n");
    return;
  }

  neo_location_set_deviceconsts(&loc, g);

  j=neo_location_num_hosts(&loc);
  if (j>1) {
    /* there's no reason we can't do this, it just seems like a bad idea to let the user do it */
    printf("You can not currently turn off ports on more than one device at a time.\n");
    return;
  }

  /* we'll write the code to do many anyway */
  for (i=0; i<j; i++) {
    d=neo_location_get_device_n(&loc, i);

    if (neo_device_has_boards(d) && !neo_location_has_board(&loc)) {
      printf("You must specify a board for '%s' since it is a %s and has boards\n",
	     neo_device_get_name(d), neo_device_get_devname(d));
      return;
    }
    if (!neo_device_has_boards(d) && neo_location_has_board(&loc)) {
      printf("You have specified a board for '%s' but it is a %s and has no boards\n",
	     neo_device_get_name(d), neo_device_get_devname(d));
      return;
    }

#ifdef MIT
    if (command==NEO_COMMAND_PORT_ENABLE) {
      sprintf(buff, "port enable request %s", neo_location_get_instr(&loc));
      neo_register(buff);
    } else if (command==NEO_COMMAND_PORT_DISABLE) {
      sprintf(buff, "port disable request %s", neo_location_get_instr(&loc));
      neo_register(buff);
    }
#endif
    
    ret=neo_device_command_port_sed(d, &loc, command);
      
    if (ret==NEO_COMMAND_PORT_IS_ENABLED) {
      printf("%s enabled\n", neo_location_get_instr(&loc));
    } else if (ret==NEO_COMMAND_PORT_IS_DISABLED) {
      printf("%s disabled\n", neo_location_get_instr(&loc));
    } else if (ret==NEO_COMMAND_PORT_IS_UNKNOWN) {
      printf("Unknown port status for %s\n", neo_location_get_instr(&loc));
    } else if (ret==NEO_COMMAND_PORT_IS_SILENTERR) {
      /* do nothing */
    } else if (ret==-1) {
      if (neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", neo_device_get_name(d));
      } else {
	printf("Error talking to device %s\n", neo_device_get_name(d));
      }
    }

#ifdef MIT
    if (command==NEO_COMMAND_PORT_ENABLE && ret==NEO_COMMAND_PORT_IS_ENABLED) {
      sprintf(buff, "port enable success %s", neo_location_get_instr(&loc));
      neo_register(buff);
    } else if (command==NEO_COMMAND_PORT_DISABLE && ret==NEO_COMMAND_PORT_IS_DISABLED) {
      sprintf(buff, "port disable success %s", neo_location_get_instr(&loc));
      neo_register(buff);
    }
#endif

    neo_location_free_elements(&loc);
  }
}

int neo_command_port_sed_standardbridge_helper(neo_location *loc, int command, int ifnum) {
  char obj[1024], val[20];
  int a, ret;
  char *name;

  name=neo_device_get_name(neo_location_get_first_device(loc));
  
  sprintf(obj, ".1.3.6.1.2.1.17.2.15.1.4.%i", ifnum);

  if (command == NEO_COMMAND_PORT_STATUS) {
    ret=neo_snmp_request_by_variable(name, obj, val);
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n.", name);
      } else {
	printf("Error getting port status for %s.\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    a=atoi(val);
    if (a==1) return(NEO_COMMAND_PORT_IS_ENABLED);
    if (a==2) return(NEO_COMMAND_PORT_IS_DISABLED);
    return(NEO_COMMAND_PORT_IS_UNKNOWN);
  } else if (command == NEO_COMMAND_PORT_ENABLE) {
    ret=neo_snmp_set_by_variable(name, obj, "int", "1");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", name);
      } else {
	printf("Error getting port status for %s.\n",neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_ENABLED);
  } else if (command == NEO_COMMAND_PORT_DISABLE) {
    ret=neo_snmp_set_by_variable(name, obj, "int", "2");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", name);
      } else {
	printf("Error getting port status for %s.\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_DISABLED);
  }
  return(0);
}
