#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include "neo.h"

void command_port_search(neo_global *g, int argc, char **argv) {
  int ret, i, j;
  neo_location loc;
  neo_device *d;

  argc--;
  argv++;

  if (argc<1) {
    printf("Not enough arguments to port search command.\n");
    return;
  }

  ret=neo_location_create_from_string(&loc, argv[0]);
  if (ret) {
    printf("Could not parse location %s\n", argv[0]);
    return;
  }

  if (neo_location_star_board(&loc)) {
    printf("You can not currently search multiple boards at a time.\n");
    return;
  }
  if (neo_location_star_port(&loc)) {
    printf("You can not currently search multiple ports at a time.\n");
    return;
  }

  /* we've removed this because on things like the wireless AP's
   * you don't want to give a port number to search.
   * the device-specific functions are now responsbile for this
   * checking
   */
  /*
  if (!neo_location_has_port(&loc)) {
    printf("You must specify a port to search.\n");
    return;
  }
  */
  neo_location_set_deviceconsts(&loc, g);

  j=neo_location_num_hosts(&loc);
  for (i=0; i<j; i++) {
    d=neo_location_get_device_n(&loc, i);
    ret=neo_device_command_port_search(d, &loc);
  }

  neo_location_free_elements(&loc);
}

int neo_command_port_search_standardbridge_helper(neo_device *d, int ifnum) {
  neo_macaddr m;
  neo_snmpresponselist *rl;
  int i, j, ret, x;
  char *var, *val, buff[50], val2[1024], obj[1024];

  rl=neo_snmp_many_requests_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.17.4.3.1.2");

  if (rl==NULL) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
      neo_snmpresponselist_free_all(rl);
      return(-1);
    } else {
      printf("Error talking to device %s\n", neo_device_get_name(d));
      return(0);
    }
  }

  j=neo_snmpresponselist_get_size(rl);
  for (i=0; i<j; i++) {
    val=neo_snmpresponselist_get_val(rl, i);
    if (atoi(val)==ifnum) {
      /* check that it's not self known */
      var=neo_snmpresponselist_get_var(rl, i);
      strcpy(obj, var);
      obj[22]='3';
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val2);
      x=atoi(val2);
      if (x==4) {
	/* it's the interface address, don't display it */
	continue;
      }
      neo_macaddr_create_from_dotted_ints(&m, var+strlen(".1.3.6.1.2.1.17.4.3.1.2."));
      neo_macaddr_to_string(&m, buff);
      printf("%s", buff);
      if (x==3 || x==0) {
	printf("\n");
      } else {
	printf("     (status %i)\n", atoi(val2));
      }

    }
  }
  return(0);
}
