#include <stdio.h>
#include <strings.h>
#include <string.h>
#include "neo.h"

void command_print(int argc, char **argv) {
  argc--;
  argv++;

  if (argc>1) {
    printf("Too many arguments to the 'print' command\n");
    return;
  }

  if (argc==0) {
    printf("writecom = '%s'\n", neo_global_get_writecom(g));
    printf("readcom = '%s'\n", neo_global_get_readcom(g));
    printf("keyfile = '%s'\n", neo_global_get_keyfile(g));
    printf("statsdelay = %i\n", neo_global_get_statsdelay(g));
    printf("timeout = %i\n", neo_global_get_timeout(g));
    printf("macmode = '%s'\n", neo_global_get_macmode_string(g));
    printf("version = '%s'\n", neo_global_get_version(g));
    printf("burst = %i\n", neo_global_get_burst(g));
    return;
  }
  
  if (!strcmp(argv[0], "writecom")) {
    printf("writecom = '%s'\n", neo_global_get_writecom(g));
  } else if (!strcmp(argv[0], "readcom")) {
    printf("readcom = '%s'\n", neo_global_get_readcom(g));
  } else if (!strcmp(argv[0], "burst")) {
    printf("burst = %i\n", neo_global_get_burst(g));
  } else if (!strcmp(argv[0], "keyfile")) {
    printf("keyfile = '%s'\n", neo_global_get_keyfile(g));
  } else if (!strcmp(argv[0], "statsdelay")) {
    printf("statsdelay = %i\n", neo_global_get_statsdelay(g));
  } else if (!strcmp(argv[0], "timeout")) {
    printf("timeout = %i\n", neo_global_get_timeout(g));
  } else if (!strcmp(argv[0], "macmode")) {
    printf("macmode = '%s'\n", neo_global_get_macmode_string(g));
  } else if (!strcmp(argv[0], "version")) {
    printf("version = '%s'\n", neo_global_get_version(g));
  } else {
    printf("Unknown variable '%s'.\n", argv[0]);
  }
}
