#include "neo.h"
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>

void command_set(int argc, char **argv) {
  char buff[1024];
  argc--;
  argv++;

  if (argc>2) {
    printf("Too many arguments to the 'set' command\n");
    return;
  }

  if (argc<1) {
    printf("Not enough arguments to the 'set' command\n");
    return;
  }
  
  if (!strcmp(argv[0], "writecom")) {
    if (argc==2) {
      neo_global_set_writecom(g, argv[1]);
      return;
    } else if (argc==1) {
      if (get_pass("Write community: ", buff, 1024)) {
	return;
      }
      neo_global_set_writecom(g, buff);
      return;
    }
  } else if (!strcmp(argv[0], "readcom")) {
    if (argc==2) {
      neo_global_set_readcom(g, argv[1]);
      return;
    } else if (argc==1) {
      if (get_pass("Read community: ", buff, 1024)) {
	return;
      }
      neo_global_set_readcom(g, buff);
      return;
    }
  }

  if (argc<2) {
    printf("Not enough arguments to the 'set' command\n");
    return;
  }

  if (!strcmp(argv[0], "burst")) { /* check for too few args */
    neo_global_set_burst(g, atoi(argv[1]));
  } else if (!strcmp(argv[0], "keyfile")) {  /* check for too few args */
    neo_global_set_keyfile(g, argv[1]);
  } else if (!strcmp(argv[0], "statsdelay")) {
    neo_global_set_statsdelay(g, atoi(argv[1]));
  } else if (!strcmp(argv[0], "timeout")) {
    neo_global_set_timeout(g, atoi(argv[1]));
  } else if (!strcmp(argv[0], "macmode")) {
    if (neo_global_set_macmode_from_string(g, argv[1])<0) {
      printf("Invalid mode for mac format.  Please choose from 'standard',\n");
      printf("'cisco', or 'dash'.\n");
    }
  } else if (!strcmp(argv[0], "version")) {
    printf("You may not change the variable 'version'.\n");
  } else {
    printf("Unknown variable '%s'.\n", argv[0]);
  }

}
