#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include "neo.h"

int neo_command_port_sed_1012(neo_location *loc, int command) {
  int board, port;
  char obj[1024], val[30];
  int a, ret;
  char *device;

  board=neo_location_get_boardnum(loc);
  port=neo_location_get_portnum(loc);

  if (board==1) {
    printf("This is an internal board and can not be accessed\n.");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }
  
  if (board != 2) {
    printf("Invalid board\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  if (port<1 || port>13) {
    printf("Invalid port\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  if (port==13) {
    printf("Warning, this is likely the uplink port\n");
    if (!are_you_sure(NULL)) return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  device=neo_device_get_name(neo_location_get_first_device(loc));
  sprintf(obj, ".1.3.6.1.4.1.298.1.3.4.1.1.1.9.%i.%i", board, port);

  if (command == NEO_COMMAND_PORT_STATUS) {
    ret=neo_snmp_request_by_variable(device, obj, val);
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", device);
      } else {
	printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    a=atoi(val);
    if (a==2) return(NEO_COMMAND_PORT_IS_ENABLED);
    if (a==3) return(NEO_COMMAND_PORT_IS_DISABLED);
    return(NEO_COMMAND_PORT_IS_UNKNOWN);
  } else if (command == NEO_COMMAND_PORT_ENABLE) {
    ret=neo_snmp_set_by_variable(device, obj, "int", "2");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", device);
      } else {
	printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_ENABLED);
  } else if (command == NEO_COMMAND_PORT_DISABLE) {
    ret=neo_snmp_set_by_variable(device, obj, "int", "3");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", device);
      } else {
	printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_DISABLED);
  }
  return(0); /* really just so -Wall shuts up */
}


int neo_command_device_summary_1012(neo_device *d, neo_location *loc, neo_list *out) {
  int high, low, board, i, j, ret;
  neo_portlist *pl;
  neo_port *p;
  neo_boardlist *bl;
  neo_board *b;
  char buff[30], obj[1024];

  if (neo_location_has_port(loc)) {
    /* do port summary */

    if (neo_location_star_board(loc)) {
      printf("Cannot currently summarize multiple ports on multiple boards at one time\n");
      return(-1);
    }
    board=neo_location_get_boardnum(loc);

    if (neo_location_star_port(loc)) {
      /* we should maybe get this from the MIB */
      if (board != 1) {
	low=1;
	high=12;
      } else {
	low=1;
	high=2;
      }
    } else {
      high=low=neo_location_get_portnum(loc);
    }

    pl=out;
    for(i=low; i<=high; i++) {
      p=malloc(sizeof(neo_port));
      neo_portlist_append_element(pl, p);

      neo_port_create(p);
      neo_port_set_number(p, i);

      if (board != 1) {
	neo_port_set_descr(p, "10T");
	neo_port_set_uplink(p, 0);
      } else {
	/* need to do this */
      }

      neo_port_set_speed(p, 10000000);

      /* link */
      sprintf(obj, ".1.3.6.1.4.1.298.1.3.4.1.1.1.4.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	continue;
      } else {
	if (atoi(buff) == 2) {
	  neo_port_set_link_up(p);
	} else if (atoi(buff) == 3) {
	  neo_port_set_link_down(p);
	} else {
	  neo_port_set_link_unknown(p);
	}
      }

      /* is it auto partitioned? */
      sprintf(obj, ".1.3.6.1.4.1.298.1.3.4.1.1.1.6.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	continue;
      } else {
	if (atoi(buff) == 2) {
	  neo_port_set_link_autopart(p);
	}
      }

      /* admin */
      sprintf(obj, ".1.3.6.1.4.1.298.1.3.4.1.1.1.9.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (atoi(buff) == 2) {
	neo_port_set_admin(p, 1);
      } else if (atoi(buff) == 3) {
	neo_port_set_admin(p, 0);
      } else {
	neo_port_set_admin(p, -1);
      }
      
    }
    return(NEO_TYPE_PORTLIST);
  } else {
    /* do board summary */
    if (!neo_location_has_board(loc) || neo_location_star_board(loc)) {
      low=1;
      high=2;
    } else {
      low=high=neo_location_get_boardnum(loc);
    }

    bl=out;
    for(i=low; i<=high; i++) {
      b=malloc(sizeof(neo_board));
      neo_boardlist_append_element(bl, b);

      neo_board_create(b);
      neo_board_set_number(b, i);

      /* present & type */
      sprintf(obj, ".1.3.6.1.4.1.298.1.3.1.1.8.1.3.%i", i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) continue;

      j=atoi(buff);
      if (j==5) {
	neo_board_set_notpresent(b);
      } else {
	neo_board_set_present(b);
      }
    
      if (j==6) {
	neo_board_set_descr(b, "Mgmt");
      } else if (j==5) {
	neo_board_set_descr(b, "Empty");
      } else if (j==9) {
	neo_board_set_descr(b, "RJ21");
      } else if (j==10) {
	neo_board_set_descr(b, "RJ21-Top");
      } else if (j==26) {
	neo_board_set_descr(b, "RJ21-Top*");
      } else if (j==25) {
	neo_board_set_descr(b, "RJ21-Bot*");
      } else if (j==3) {
	neo_board_set_descr(b, "3in1-uLnk"); /* ah1012-3in1UpLink-Bridge(3) */
      } else if (j==2) {
	neo_board_set_descr(b, "12xRJ45");
      } else if (j==1) {
	neo_board_set_descr(b, "3in1-uLnk"); /* ah1012-3in1UpLink-SNMP(1) */
      } else {
	neo_board_set_descr(b, "Unknown");
      }

      if (j==5) continue;

      /* link */
      if (i==1) {
	sprintf(obj, ".1.3.6.1.4.1.298.1.3.4.1.1.1.4.%i.1", i);
	ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
	if (ret) continue;
	if (atoi(buff) == 2) {
	  neo_board_set_link_up(b);
	} else if (atoi(buff) == 3) {
	  neo_board_set_link_down(b);
	} else {
	  neo_board_set_link_unknown(b);
	}
      } else {
	neo_board_set_link_down(b);
      }

      /* speed hack */
      neo_board_set_speed(b, 10000000);


    }
    return(NEO_TYPE_BOARDLIST);
  }
  /* PRINT A WARNING */
}


int neo_command_stats_1012(neo_location *loc, neo_list *out) {
  neo_statstransfer *st, *a, *b;
  neo_portlist *pl;
  neo_port *p;
  neo_boardlist *bl;
  neo_board *bd;
  neo_device *d;
  neo_list *stlist1, *stlist2, *stlistcur; /* stats transfer list */
  int ret, i, j, run, portnum, boardnum;
  neo_sleeper sleeper;
  neo_stats *s;
  char obj[1024], val[30];
  unsigned x;

  d=neo_location_get_first_device(loc);
  ret=neo_command_device_summary_1012(d, loc, out);
  if (ret==NEO_TYPE_PORTLIST) {
    pl=out;
    j=neo_portlist_get_size(pl);
    stlist1=malloc(sizeof(neo_list));
    stlist2=malloc(sizeof(neo_list));
    neo_list_create(stlist1);
    neo_list_create(stlist2);

    neo_sleeper_create(&sleeper, neo_global_get_statsdelay(g));
    boardnum=neo_location_get_boardnum(loc);
    
    /* do it twice first with stlistcur=stlist1 then stlistcur=stlist2 */
    run=0;
    for (stlistcur=stlist1,run=0; run<2; stlistcur=stlist2, run++) {
      if (run==0) {
	printf("Getting first set of stats...\n");
      } else {
	printf("Getting second set of stats...\n");
      }
      for (i=0; i<j; i++) {
	p=neo_portlist_get_element(pl, i);
	portnum=neo_port_get_number(p);

	/* append st to current list */
	st=malloc(sizeof(neo_statstransfer));
	neo_list_append_element(stlistcur, st);

	/* set all the stats transfer things */

	neo_statstransfer_init(st);

	/* things we don't have */
	neo_statstransfer_set_generic(st, NEO_ST_OUTKBS, NEO_ST_UNAVAIL, 0);
	neo_statstransfer_set_generic(st, NEO_ST_INKBS, NEO_ST_UNAVAIL, 0);
	neo_statstransfer_set_generic(st, NEO_ST_OUTPPSU, NEO_ST_UNAVAIL, 0);
	neo_statstransfer_set_generic(st, NEO_ST_OUTPPSNU, NEO_ST_UNAVAIL, 0);

	/* .1.3.6.1.4.1.298.1.3.3.1.4.1.3.%i.%i */
	sprintf(obj, ".1.3.6.1.4.1.298.1.3.3.1.4.1.3.%i.%i", boardnum, portnum);
	ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
	if (ret && (neo_error!=NEO_ERR_SNMP_NOVAR)) {
	  neo_statstransfer_set_generic(st, NEO_ST_INPPSU, NEO_ST_ERROR, 0);
	} else {
	  x=atoi(val);
	  neo_statstransfer_set_generic(st, NEO_ST_INPPSU, NEO_ST_INT, x);
	}
	neo_statstransfer_set_clk_inppsu(st);

	/* hack around non-unicast */
	neo_statstransfer_set_generic(st, NEO_ST_INPPSNU, NEO_ST_INT, 0);
	neo_statstransfer_set_clk_inppsnu(st);

	/* errors */
	sprintf(obj, ".1.3.6.1.4.1.298.1.3.3.1.4.1.14.%i.%i", boardnum, portnum);
	ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
	if (ret && (neo_error!=NEO_ERR_SNMP_NOVAR)) {
	  neo_statstransfer_set_generic(st, NEO_ST_INERRPS, NEO_ST_ERROR, 0);
	  neo_statstransfer_set_generic(st, NEO_ST_OUTERRPS, NEO_ST_ERROR, 0);
	} else {
	  x=atoi(val);
	  neo_statstransfer_set_generic(st, NEO_ST_INERRPS, NEO_ST_INT, x);
	  neo_statstransfer_set_generic(st, NEO_ST_OUTERRPS, NEO_ST_INT, x);
	}
	neo_statstransfer_set_clk_inerrps(st);
	neo_statstransfer_set_clk_outerrps(st);
      }

      /* do the necessary delay here */
      if (run==0) {
	neo_sleeper_dowait(&sleeper);
      }
    }

    s=malloc(sizeof(neo_stats));
    /* now for each port do the stats transfer calculation */
    for (i=0; i<j; i++) {
      p=neo_portlist_get_element(pl, i);
      a=neo_list_get_element(stlist1, i);
      b=neo_list_get_element(stlist2, i);

      /* calculate and set for port */
      neo_statstransfer_compute_stats(a, b, s);
      neo_port_set_stats(p, s);
    }

    /* free the statstransfer lists */
    /* MUST COME BACK AND DO THIS */
    
    return(NEO_TYPE_PORTLIST);
    
  } else if (ret==NEO_TYPE_BOARDLIST) {
    bl=out;
    j=neo_boardlist_get_size(bl);
    stlist1=malloc(sizeof(neo_list));
    stlist2=malloc(sizeof(neo_list));
    neo_list_create(stlist1);
    neo_list_create(stlist2);

    neo_sleeper_create(&sleeper, neo_global_get_statsdelay(g));
    
    /* do it twice first with stlistcur=stlist1 then stlistcur=stlist2 */
    run=0;

    for (stlistcur=stlist1,run=0; run<2; stlistcur=stlist2, run++) {
      if (run==0) {
	printf("Getting first set of stats...\n");
      } else {
	printf("Getting second set of stats...\n");
      }

      for (i=0; i<j; i++) {
	bd=neo_boardlist_get_element(bl, i);
	boardnum=neo_board_get_number(bd);

	/* append st to current list */
	st=malloc(sizeof(neo_statstransfer));
	neo_list_append_element(stlistcur, st);

	/* set all the stats transfer things */

	neo_statstransfer_init(st);
	neo_statstransfer_set_generic(st, NEO_ST_OUTKBS, NEO_ST_UNAVAIL, 0);
	neo_statstransfer_set_generic(st, NEO_ST_INKBS, NEO_ST_UNAVAIL, 0);
	neo_statstransfer_set_generic(st, NEO_ST_OUTPPSU, NEO_ST_UNAVAIL, 0);
	neo_statstransfer_set_generic(st, NEO_ST_OUTPPSNU, NEO_ST_UNAVAIL, 0);

	/* in octets */
	sprintf(obj, ".1.3.6.1.4.1.298.1.3.3.1.3.1.2.%i", boardnum);
	ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
	if (ret && (neo_error!=NEO_ERR_SNMP_NOVAR)) {
	  neo_statstransfer_set_generic(st, NEO_ST_INPPSU, NEO_ST_ERROR, 0);
	} else {
	  neo_statstransfer_set_generic(st, NEO_ST_INPPSU, NEO_ST_INT, atoi(val));
	}
	neo_statstransfer_set_clk_inppsu(st);

	/* hack around non-unicast */
	neo_statstransfer_set_generic(st, NEO_ST_INPPSNU, NEO_ST_INT, 0);
	neo_statstransfer_set_clk_inppsnu(st);
      }

      /* do the necessary delay here */
      if (run==0) {
	neo_sleeper_dowait(&sleeper);
      }
    }

    s=malloc(sizeof(neo_stats));
    /* now for each port do the stats transfer calculation */
    for (i=0; i<j; i++) {
      bd=neo_boardlist_get_element(bl, i);
      a=neo_list_get_element(stlist1, i);
      b=neo_list_get_element(stlist2, i);

      /* calculate and set for port */
      neo_statstransfer_compute_stats(a, b, s);
      neo_board_set_stats(bd, s);
    }

    /* free the statstransfer lists */
    /* MUST COME BACK AND DO THIS */
    
    return(NEO_TYPE_BOARDLIST);

  } else {
    printf("Error getting summary for statistics\n");
    return(-1);
  }
}
