#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include "neo.h"

int neo_command_port_sed_2072(neo_location *loc, int command) {
  int board, port;
  char obj[1024], val[30];
  int a, ret;
  char *device;

  board=neo_location_get_boardnum(loc);
  port=neo_location_get_portnum(loc);

  if (board==1) {
    if (port==1 || port==2) {
      printf("WARNING! this is likely the mangement board.\n");
      if (!are_you_sure(NULL)) return(NEO_COMMAND_PORT_IS_SILENTERR);
    } else {
      printf("Invalid port for this device.\n");
      return(NEO_COMMAND_PORT_IS_SILENTERR);
    }
  }
  
  if (board<2 || board>7) {
    printf("Invalid board\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  if (port<1 || port>13) {
    printf("Invalid port\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  if (port==13) {
    printf("Warning, this is likely the uplink port\n");
    if (!are_you_sure(NULL)) return(0);
  }

  device=neo_device_get_name(neo_location_get_first_device(loc));
  sprintf(obj, ".1.3.6.1.4.1.298.1.3.4.1.1.1.9.%i.%i", board, port);

  if (command == NEO_COMMAND_PORT_STATUS) {
    ret=neo_snmp_request_by_variable(device, obj, val);
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", device);
      } else {
	printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    a=atoi(val);
    if (a==2) return(NEO_COMMAND_PORT_IS_ENABLED);
    if (a==3) return(NEO_COMMAND_PORT_IS_DISABLED);
    return(NEO_COMMAND_PORT_IS_UNKNOWN);
  } else if (command == NEO_COMMAND_PORT_ENABLE) {
    ret=neo_snmp_set_by_variable(device, obj, "int", "2");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", device);
      } else {
	printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_ENABLED);
  } else if (command == NEO_COMMAND_PORT_DISABLE) {
    ret=neo_snmp_set_by_variable(device, obj, "int", "3");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", device);
      } else {
	printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_DISABLED);
  }
  return(0);
}

int neo_command_locate_2072(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink) {
  /* see docs for contract */
  neo_snmpresponselist *rl;
  neo_macaddr *m;
  char macints[300], locbuff[300];
  int ret, i, j, board, port;
  neo_location *loc;

  m=neo_searchable_get_macaddr(s);
  neo_macaddr_to_dotted_ints_string(m, macints);

  rl=neo_snmp_many_requests_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.298.1.3.5.1.1.1");

  if (rl==NULL) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
      neo_snmpresponselist_free_all(rl);
      return(-1);
    } else {
      return(0);
    }
  }

  /* see if any match as the source mac addr */
  j=neo_snmpresponselist_get_size(rl);
  for (i=0; i<j; i++) {
    char *ptr1, *ptr2, *ptr3;
    char *var;

    var=neo_snmpresponselist_get_var(rl, i);
    ptr1=var+29; /* + strlen(".1.3.6.1.4.1.298.1.3.5.1.1.1.") */
    ptr2=strchr(ptr1,'.')+1;
    ptr3=strchr(ptr2,'.')+1;
    /* printf("DEBUG: %s %s\n", macints, ptr3); */
    if (!strncmp(macints, ptr3, strlen(macints))) {
      /* printf("DEBUG: %s\n", locbuff); */
      /* memset(ptr2-1, 0, 1); */
      /* memset(ptr3-1, 0, 1); */
      board=atoi(ptr1);
      port=atoi(ptr2);
      if (uplink || port!=13) {
	sprintf(locbuff, "%i/%i@%s", board, port, neo_device_get_name(d));
	loc=malloc(sizeof(neo_location));
	ret=neo_location_create_from_string(loc, locbuff);
	if (ret) {
	  printf("Internal error creating location from string '%s'\n", locbuff);
	}
	neo_locationlist_append_element(ans, loc);
      }
    }
  }

  /* Did we forget to free stuff here? */

  return(0);
}

int neo_command_device_summary_2072(neo_device *d, neo_location *loc, neo_list *out) {
  int high, low, board, i, j, ret;
  neo_portlist *pl;
  neo_port *p;
  neo_boardlist *bl;
  neo_board *b;
  char buff[30], obj[1024];

  if (neo_location_has_port(loc)) {
    /* do port summary */

    if (neo_location_star_board(loc)) {
      printf("Cannot currently summarize multiple ports on multiple boards at one time\n");
      return(-1);
    }
    board=neo_location_get_boardnum(loc);

    if (neo_location_star_port(loc)) {
      /* we should get this from the MIB */
      if (board != 1) {
	low=1;
	high=13;
      } else {
	low=13;
	high=13;
      }
    } else {
      high=low=neo_location_get_portnum(loc);
    }
    pl=out;
    for(i=low; i<=high; i++) {
      p=malloc(sizeof(neo_port));
      neo_portlist_append_element(pl, p);

      neo_port_create(p);
      neo_port_set_number(p, i);

      /* port descr */
      if (i<13) {
	neo_port_set_descr(p, "10T");
	neo_port_set_uplink(p, 0);
      } else if (i==13) {
	sprintf(obj, ".1.3.6.1.4.1.298.1.3.1.1.8.1.10.%i", board);
	ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
	if (ret) continue;

	neo_port_set_uplink(p, 1);
	j=atoi(buff);
	if (j==1) {
	  if (i!=1) {
	    neo_port_set_descr(p, "not-AUI");
	  }
	} else if (j==2) {
	  neo_port_set_descr(p, "Empty"); /* empty */
	  neo_port_set_uplink(p, 0);
	} else if (j==3) {
	  neo_port_set_descr(p, "AUI");
	} else if (j==4) {
	  neo_port_set_descr(p, "UTP-MAU");
	} else if (j==5) {
	  neo_port_set_descr(p, "fiber-MAU");
	} else if (j==6) {
	  neo_port_set_descr(p, "BNC-MAU");
	} else {
	  neo_port_set_descr(p, "unknown");
	}
      }
      
      neo_port_set_speed(p, 10000000);

      /* link */
      sprintf(obj, ".1.3.6.1.4.1.298.1.3.4.1.1.1.4.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	continue;
      } else {
	if (atoi(buff) == 2) {
	  neo_port_set_link_up(p);
	} else if (atoi(buff) == 3) {
	  neo_port_set_link_down(p);
	} else {
	  neo_port_set_link_unknown(p);
	}
      }

      /* is it auto partitioned? */
      sprintf(obj, ".1.3.6.1.4.1.298.1.3.4.1.1.1.6.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	continue;
      } else {
	if (atoi(buff) == 2) {
	  neo_port_set_link_autopart(p);
	}
      }

      /* admin */
      sprintf(obj, ".1.3.6.1.4.1.298.1.3.4.1.1.1.9.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (atoi(buff) == 2) {
	neo_port_set_admin(p, 1);
      } else if (atoi(buff) == 3) {
	neo_port_set_admin(p, 0);
      } else {
	neo_port_set_admin(p, -1);
      }
      
    }
    return(NEO_TYPE_PORTLIST);
  } else {
    /* do board summary */
    if (!neo_location_has_board(loc) || neo_location_star_board(loc)) {
      low=1;
      high=7;
    } else {
      low=high=neo_location_get_boardnum(loc);
    }

    bl=out;
    for(i=low; i<=high; i++) {
      b=malloc(sizeof(neo_board));
      neo_boardlist_append_element(bl, b);

      neo_board_create(b);
      neo_board_set_number(b, i);

      /* present & type */
      sprintf(obj, ".1.3.6.1.4.1.298.1.3.1.1.8.1.3.%i", i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) continue;

      j=atoi(buff);
      if (j==5) {
	neo_board_set_notpresent(b);
      } else {
	neo_board_set_present(b);
      }
    
      if (j==6) {
	neo_board_set_descr(b, "Mgmt");
      } else if (j==5) {
	neo_board_set_descr(b, "Empty");
      } else if (j==9) {
	neo_board_set_descr(b, "RJ21");
      } else if (j==10) {
	neo_board_set_descr(b, "RJ21-Top");
      } else if (j==26) {
	neo_board_set_descr(b, "RJ21-Top*");
      } else if (j==25) {
	neo_board_set_descr(b, "RJ21-Bot*");
      } else if (j==3) {
	neo_board_set_descr(b, "3in1-uLnk"); /* ah1012-3in1UpLink-Bridge(3) */
      } else if (j==2) {
	neo_board_set_descr(b, "12xRJ45");
      } else if (j==1) {
	neo_board_set_descr(b, "3in1-uLnk"); /* ah1012-3in1UpLink-SNMP(1) */
      } else if (j==13) {
	neo_board_set_descr(b, "BNC");
      } else {
	neo_board_set_descr(b, "Unknown");
      }

      if (j==5) continue;
      
      /* uplink descr */
      sprintf(obj, ".1.3.6.1.4.1.298.1.3.1.1.8.1.10.%i", i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) continue;
      
      j=atoi(buff);
      if (j==1) {
	if (i!=1) {
	  neo_board_set_uplinkdescr(b, "not-AUI");
	}
      } else if (j==2) {
	neo_board_set_uplinkdescr(b, ""); /* empty */
      } else if (j==3) {
	neo_board_set_uplinkdescr(b, "AUI");
      } else if (j==4) {
	neo_board_set_uplinkdescr(b, "UTP-MAU");
      } else if (j==5) {
	neo_board_set_uplinkdescr(b, "fiber-MAU");
      } else if (j==6) {
	neo_board_set_uplinkdescr(b, "BNC-MAU");
      } else {
	neo_board_set_uplinkdescr(b, "unknown");
      }

      /* link */
      if (i==1) {
	neo_board_set_link_down(b);
      } else {
	sprintf(obj, ".1.3.6.1.4.1.298.1.3.4.1.1.1.4.%i.13", i);
	ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
	if (ret) continue;
	if (atoi(buff) == 2) {
	  neo_board_set_link_up(b);
	} else if (atoi(buff) == 3) {
	  neo_board_set_link_down(b);
	} else {
	  neo_board_set_link_unknown(b);
	}
      }

      /* speed hack */
      neo_board_set_speed(b, 10000000);

      /* segment */
      sprintf(obj, ".1.3.6.1.4.1.298.1.3.1.1.8.1.9.%i", i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) continue;
      j=atoi(buff+6); /* hack */
      neo_board_set_segment(b, j);

    }
    return(NEO_TYPE_BOARDLIST);
  }
  /* PRINT A WARNING */
}


int neo_command_stats_2072(neo_location *loc, neo_list *out) {
  neo_statstransfer *st, *a, *b;
  neo_portlist *pl;
  neo_port *p;
  neo_boardlist *bl;
  neo_board *bd;
  neo_device *d;
  neo_list *stlist1, *stlist2, *stlistcur; /* stats transfer list */
  int ret, i, j, run, portnum, boardnum;
  neo_sleeper sleeper;
  neo_stats *s;
  char obj[1024], val[30];
  unsigned x;

  d=neo_location_get_first_device(loc);
  ret=neo_command_device_summary_2072(d, loc, out);
  if (ret==NEO_TYPE_PORTLIST) {
    pl=out;
    j=neo_portlist_get_size(pl);
    stlist1=malloc(sizeof(neo_list));
    stlist2=malloc(sizeof(neo_list));
    neo_list_create(stlist1);
    neo_list_create(stlist2);

    neo_sleeper_create(&sleeper, neo_global_get_statsdelay(g));
    boardnum=neo_location_get_boardnum(loc);
    
    /* do it twice first with stlistcur=stlist1 then stlistcur=stlist2 */
    run=0;
    for (stlistcur=stlist1,run=0; run<2; stlistcur=stlist2, run++) {
      if (run==0) {
	printf("Getting first set of stats...\n");
      } else {
	printf("Getting second set of stats...\n");
      }
      for (i=0; i<j; i++) {
	p=neo_portlist_get_element(pl, i);
	portnum=neo_port_get_number(p);

	/* append st to current list */
	st=malloc(sizeof(neo_statstransfer));
	neo_list_append_element(stlistcur, st);

	/* set all the stats transfer things */

	neo_statstransfer_init(st);

	/* things we don't have */
	neo_statstransfer_set_generic(st, NEO_ST_OUTKBS, NEO_ST_UNAVAIL, 0);
	neo_statstransfer_set_generic(st, NEO_ST_OUTPPSU, NEO_ST_UNAVAIL, 0);
	neo_statstransfer_set_generic(st, NEO_ST_OUTPPSNU, NEO_ST_UNAVAIL, 0);

	/* in octets */
	/* enterprises.asante.products.concentrator.concStatistics.eStatistics.ePortStatisticsTable.ePortStatisticsEntry.ePortStatReadableOctets.%i.%i */
	sprintf(obj, ".1.3.6.1.4.1.298.1.3.3.1.4.1.20.%i.%i", boardnum, portnum);
	ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
	if (ret && (neo_error!=NEO_ERR_SNMP_NOVAR)) {
	  neo_statstransfer_set_generic(st, NEO_ST_INKBS, NEO_ST_ERROR, 0);
	} else {
	  x=(atoi(val)*8)/1000;
	  neo_statstransfer_set_generic(st, NEO_ST_INKBS, NEO_ST_INT, x);
	}
	neo_statstransfer_set_clk_inkbs(st);

	/* .1.3.6.1.4.1.298.1.3.3.1.4.1.3.%i.%i */
	sprintf(obj, ".1.3.6.1.4.1.298.1.3.3.1.4.1.3.%i.%i", boardnum, portnum);
	ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
	if (ret && (neo_error!=NEO_ERR_SNMP_NOVAR)) {
	  neo_statstransfer_set_generic(st, NEO_ST_INPPSU, NEO_ST_ERROR, 0);
	} else {
	  x=atoi(val);
	  neo_statstransfer_set_generic(st, NEO_ST_INPPSU, NEO_ST_INT, x);
	}
	neo_statstransfer_set_clk_inppsu(st);

	/* hack around non-unicast */
	neo_statstransfer_set_generic(st, NEO_ST_INPPSNU, NEO_ST_INT, 0);
	neo_statstransfer_set_clk_inppsnu(st);

	/* errors */
	sprintf(obj, ".1.3.6.1.4.1.298.1.3.3.1.4.1.14.%i.%i", boardnum, portnum);
	ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
	if (ret && (neo_error!=NEO_ERR_SNMP_NOVAR)) {
	  neo_statstransfer_set_generic(st, NEO_ST_INERRPS, NEO_ST_ERROR, 0);
	  neo_statstransfer_set_generic(st, NEO_ST_OUTERRPS, NEO_ST_ERROR, 0);
	} else {
	  x=atoi(val);
	  neo_statstransfer_set_generic(st, NEO_ST_INERRPS, NEO_ST_INT, x);
	  neo_statstransfer_set_generic(st, NEO_ST_OUTERRPS, NEO_ST_INT, x);
	}
	neo_statstransfer_set_clk_inerrps(st);
	neo_statstransfer_set_clk_outerrps(st);
      }

      /* do the necessary delay here */
      if (run==0) {
	neo_sleeper_dowait(&sleeper);
      }
    }

    s=malloc(sizeof(neo_stats));
    /* now for each port do the stats transfer calculation */
    for (i=0; i<j; i++) {
      p=neo_portlist_get_element(pl, i);
      a=neo_list_get_element(stlist1, i);
      b=neo_list_get_element(stlist2, i);

      /* calculate and set for port */
      neo_statstransfer_compute_stats(a, b, s);
      neo_port_set_stats(p, s);
    }

    /* free the statstransfer lists */
    /* MUST COME BACK AND DO THIS */
    
    return(NEO_TYPE_PORTLIST);
    
  } else if (ret==NEO_TYPE_BOARDLIST) {
    bl=out;
    stlist1=malloc(sizeof(neo_list));
    stlist2=malloc(sizeof(neo_list));
    neo_list_create(stlist1);
    neo_list_create(stlist2);

    neo_sleeper_create(&sleeper, neo_global_get_statsdelay(g));
    
    /* do it twice first with stlistcur=stlist1 then stlistcur=stlist2 */
    run=0;
    for (stlistcur=stlist1,run=0; run<2; stlistcur=stlist2, run++) {
      if (run==0) {
	printf("Getting first set of stats...\n");
      } else {
	printf("Getting second set of stats...\n");
      }

      j=neo_boardlist_get_size(bl);
      for (i=0; i<j; i++) {
	bd=neo_boardlist_get_element(bl, i);
	boardnum=neo_board_get_number(bd);

	/* append st to current list */
	st=malloc(sizeof(neo_statstransfer));
	neo_list_append_element(stlistcur, st);

	/* set all the stats transfer things */
	neo_statstransfer_init(st);
	neo_statstransfer_set_generic(st, NEO_ST_OUTKBS, NEO_ST_UNAVAIL, 0);
	neo_statstransfer_set_generic(st, NEO_ST_INKBS, NEO_ST_UNAVAIL, 0);
	neo_statstransfer_set_generic(st, NEO_ST_OUTPPSU, NEO_ST_UNAVAIL, 0);
	neo_statstransfer_set_generic(st, NEO_ST_OUTPPSNU, NEO_ST_UNAVAIL, 0);

	/* in packets */
	sprintf(obj, ".1.3.6.1.4.1.298.1.3.3.1.3.1.2.%i", boardnum);
	ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
	if (ret && (neo_error!=NEO_ERR_SNMP_NOVAR)) {
	  neo_statstransfer_set_generic(st, NEO_ST_INPPSU, NEO_ST_ERROR, 0);
	} else {
	  neo_statstransfer_set_generic(st, NEO_ST_INPPSU, NEO_ST_INT, atol(val));
	}
	neo_statstransfer_set_clk_inppsu(st);

	/* hack inppsnu to 0 */
	neo_statstransfer_set_generic(st, NEO_ST_INPPSNU, NEO_ST_INT, 0);
	neo_statstransfer_set_clk_inppsnu(st);
      }

      /* do the necessary delay here */
      if (run==0) {
	neo_sleeper_dowait(&sleeper);
      }
    }

    s=malloc(sizeof(neo_stats));
    /* now for each port do the stats transfer calculation */
    for (i=0; i<j; i++) {
      bd=neo_boardlist_get_element(bl, i);
      a=neo_list_get_element(stlist1, i);
      b=neo_list_get_element(stlist2, i);

      /* calculate and set for port */
      neo_statstransfer_compute_stats(a, b, s);
      neo_board_set_stats(bd, s);
    }

    /* free the statstransfer lists */
    /* MUST COME BACK AND DO THIS */
    
    return(NEO_TYPE_BOARDLIST);

  } else {
    printf("Error getting summary for statistics\n");
    return(-1);
  }
}


int neo_command_device_reset_2072(neo_device *d) {
  int ret;

  ret=neo_snmp_set_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.298.1.1.1.9.0", "int", "2");
  if (ret) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s.\n", neo_device_get_name(d));
    } else {
      printf("Error contacting device %s for reset.\n", neo_device_get_name(d));
    }
    return(-1);
  }
  return(0);
}


int neo_command_port_search_2072(neo_location *loc) {
  neo_device *d;
  neo_snmpresponselist *rl;
  char buff[1024], *ptr1, *ptr2;
  int  i, j, board, port, x;
  neo_macaddr m;

  if (!neo_location_has_port(loc) || !neo_location_has_board(loc)) {
    printf("You must specify a board/port to search.\n");
    return(-1);
  }
  board=neo_location_get_boardnum(loc);
  port=neo_location_get_portnum(loc);

  d=neo_location_get_first_device(loc);
  
  rl=neo_snmp_many_requests_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.298.1.3.5.1.1.1");
  
  if (rl==NULL) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
      neo_snmpresponselist_free_all(rl);
      return(-1);
    } else {
      return(0);
    }
  }
  /* see if any match the board/port */
  j=neo_snmpresponselist_get_size(rl);
  for (i=0; i<j; i++) {
    char *var;
    
    var=neo_snmpresponselist_get_var(rl, i);
    sprintf(buff, ".1.3.6.1.4.1.298.1.3.5.1.1.1.%i.%i", board, port);
    if (!strncmp(var, buff, strlen(buff))) {
      ptr1=ptr2=var+strlen(buff)+1;
      for (x=0; x<6; x++) {
	ptr2=strchr(ptr2, '.');
	if (!ptr2) {
	  printf("Error parsing response.\n");
	  break;
	}
	ptr2++;
      }
      strncpy(buff, ptr1, ptr2-ptr1-1);
      buff[ptr2-ptr1-1]='\0';
      neo_macaddr_create_from_dotted_ints(&m, buff);
      neo_macaddr_to_string(&m, buff);
      printf("%s\n", buff);
    }
  }
  return(0);
}

