#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "neo.h"

void neo_command_device_info_apcups(neo_device *d, int type) {
  int ret, i;
  char val[1024], timebuff[1024];
  
  if (type==NEO_COMMAND_DEVICE_INFO_POWER || type==NEO_COMMAND_DEVICE_INFO_UPS) {

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.1.1.1.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("  Type             : %s\n", val);
    }


    printf("  Name             : \n");
    printf("  # Alarms Present : <unsupported>\n");

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.4.1.1.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("  Status           : ");
      if (i==1) {
	printf("Other\n"); /* Unknown */
      } else if (i==2) {
	printf("Normal\n"); /* on line */
      } else if (i==3) {
	printf("Battery\n");
      } else if (i==4) {
	printf("Other\n"); /* Smart Boost */
      } else if (i==5) {
	printf("Other\n"); /* Timed Sleeping */
      } else if (i==6) {
	printf("Bypass\n"); /* Software Bypass */
      } else if (i==7) {
	printf("None\n"); /* Off */
      } else if (i==8) {
	printf("Other\n"); /* Rebooting */
      } else if (i==9) {
	printf("Bypass"); /* Switched Bypass */
      } else if (i==10) {
	printf("Bypass\n"); /* Hardware Failure Bypass */
      } else if (i==11) {
	printf("Other\n"); /* Sleeping until power return */
      } else if (i==12) {
	printf("Other\n"); /* Smart Trim */
      } else {
	printf("Unknown value (%i)\n",i);
      }
    }

    printf("\n");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.2.2.1.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("  Battery Capacity : %i%%\n", i);
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.2.2.3.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      val[strlen(val)-2]='\0'; /* chop off last two digits */
      neo_timeformat(timebuff, atoi(val));
      printf("  Battery Run Time : %s\n", timebuff);
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.2.1.2.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      val[strlen(val)-2]='\0'; /* chop off last two digits */
      neo_timeformat(timebuff, atoi(val));
      printf("  Time On Battery  : %s\n", timebuff);
    }

    
    printf("  Battery Voltage  : <unsupported>\n");
    printf("  Battery Current  : <unsupported>\n");

    printf("\n");
    
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.3.2.1.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("  Input 1 Voltage  : %i V\n", i);
    }

    printf("  Input 1 Current  : <unsupported>\n");

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.3.2.4.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("  Input 1 Freq.    : %i Hz\n", i);
    }

    printf("\n");
    
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.4.2.1.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("  Output 1 Voltage : %i V\n", i);
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.4.2.4.0", val);
    if (ret) {
      printf("  Output 1 Current : <unsupported>\n");
    } else {
      i=atoi(val);
      printf("  Output 1 Current : %i A\n", i);
    }


    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.4.2.2.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("  Output 1 Freq.   : %i Hz\n", i);
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.4.2.3.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("  Output 1 Load    : %i%%\n", i);
    }

    printf("\n    (device specific section)\n\n");
    
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.2.2.4.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("  Battery Status   : ");
      if (i==1) {
	printf("All batteries OK\n");
      } else if (i==2) {
	printf("One or more bad!\n");
      } else {
	printf("Unknown value (%i)\n", i);
      }
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.318.1.1.1.3.2.5.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("  Last Fail Cause  : ");
      if (i==0) {
	printf("No Alarm\n");
      } else if (i==1) {
	printf("No Transfer\n");
      } else if (i==2) {
	printf("High Line Voltage\n");
      } else if (i==3) {
	printf("Brownout\n");
      } else if (i==4) {
	printf("Blackout\n");
      } else if (i==5) {
	printf("Small Momentary Sag\n");
      } else if (i==6) {
	printf("Deep Momentary Sag\n");
      } else if (i==7) {
	printf("Small Momentary Spike\n");
      } else if (i==8) {
	printf("Large Momentary Spike\n");
      } else if (i==9) {
	printf("Self Test\n");
      } else if (i==10) {
	printf("Rate of Voltage Change\n");
      } else {
	printf("Unknown value (%i)\n", i);
      }
    }






    
  } else {

  }
}
