#include "neo.h"
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>

int neo_command_port_sed_cat2948(neo_location *loc, int command) {
  int board, port, ifport, ret;

  board=neo_location_get_boardnum(loc);
  port=neo_location_get_portnum(loc);

  if (board==1) {
    printf("Board 1 is an internal board an can not be accessed.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  if (board!=2) {
    printf("You have specified an invald board for a 2948.  The only vaild board is 2.\n");
  }

  if (port<1 || port>50) {
    printf("Invalid port.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  if (port==49 || port==50) {
    printf("Warning this may be the uplink.\n");
    if (!are_you_sure(NULL)) return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  ifport=neo_device_cat5000_boardport_to_ifnum_two(neo_location_get_first_device(loc), board, port);
  if (ifport==-1) {
    printf("Invalid board/port pair.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  ret=neo_command_port_sed_standardbridge_helper(loc, command, ifport);
  return(ret);
}


/*
 *  The only reason this crap is necessary is because of a bug in the
 *  2900's and 4000's.
 *
 *  Cisco sucks.
 */


int neo_command_locate_cat2948(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink) {
  /* see docs for contract */
  neo_snmpresponselist *rl;
  neo_macaddr *m;
  char macints[300], locbuff[300];
  int ret, i, j, board, port;
  neo_location *loc;

  m=neo_searchable_get_macaddr(s);
  neo_macaddr_to_dotted_ints_string(m, macints);

  rl=neo_snmp_many_requests_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.17.4.3.1.2");

  if (rl==NULL) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
      neo_snmpresponselist_free_all(rl);
      return(-1);
    } else {
      return(0);
    }
  }

  /* see if any match as the source mac addr */
  j=neo_snmpresponselist_get_size(rl);
  for (i=0; i<j; i++) {
    char *ptr1, *ptr2;
    char *var, *val;

    var=neo_snmpresponselist_get_var(rl, i);
    ptr1=var+23;
    ptr2=strchr(ptr1,'.')+1;
    if (!strncmp(macints, ptr2, strlen(macints))) {
      val=neo_snmpresponselist_get_val(rl, i);
      ret=atoi(val);
      board=(ret/64)+1;
      port=ret%64;

      if (!uplink && port>48) {
	continue;
      }
      loc=malloc(sizeof(neo_location));
      sprintf(locbuff, "%i/%i@%s", board, port, neo_device_get_name(d));
      ret=neo_location_create_from_string(loc, locbuff);
      if (ret) {
	printf("Internal error generating neo_location from answer\n");
	neo_error=NEO_ERR_INTERNAL;
	return(-1);
      }
      neo_locationlist_append_element(ans, loc);
      return(0);
    }
  }
  return(0);
}
