#include <stdio.h>
#include <stdlib.h>
#include "neo.h"

int neo_command_port_sed_cat4000(neo_location *loc, int command) {
  int board, port, ifport, ret;

  board=neo_location_get_boardnum(loc);
  port=neo_location_get_portnum(loc);

  if (board<1 || board>6) {
    printf("Invalid board.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  if (board==1) {
    printf("Warning, this may be the uplink as it's on board 1.\n");
    if (!are_you_sure(NULL)) return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  if (port<1 || port>64) {
    printf("Invalid port.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  /* figure out the port from the board/port */
  /* maybe of a hack, we could look it up if we have to */
  ifport=64*(board-1)+port;

  if (ifport==-1) {
    printf("Invalid board/port pair.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  ret=neo_command_port_sed_standardbridge_helper(loc, command, ifport);
  return(ret);
}

int neo_command_device_summary_cat4000(neo_device *d, neo_location *loc, neo_list *out) {
  int high, low, board, i, j, ret, index;
  neo_portlist *pl;
  neo_port *p;
  neo_boardlist *bl;
  neo_board *b;
  char buff[30], obj[1024];

  if (neo_location_has_port(loc)) {
    /* do port summary */
    if (neo_location_star_board(loc)) {
      printf("Cannot currently summarize multiple ports on multiple boards at one time\n");
      return(-1);
    }
    board=neo_location_get_boardnum(loc);
    
    if (neo_location_star_port(loc)) {
      sprintf(obj, ".1.3.6.1.4.1.9.5.1.3.1.1.14.%i", board);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	/* need an error */
	return(-1);
      }
      low=1;
      high=atoi(buff);
    } else {
      high=low=neo_location_get_portnum(loc);
    }
    pl=out;
    for(i=low; i<=high; i++) {
      p=malloc(sizeof(neo_port));
      neo_portlist_append_element(pl, p);

      neo_port_create(p);
      neo_port_set_number(p, i);

      sprintf(obj, ".1.3.6.1.4.1.9.5.1.4.1.1.5.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) continue;
      j=atoi(buff);
      if (j==1) {
	neo_port_set_descr(p, "other");
      } else if (j==2) {
	neo_port_set_descr(p, "CDDI");
      } else if (j==3) {
	neo_port_set_descr(p, "FDDI(mm)");
      } else if (j==4) {
	neo_port_set_descr(p, "UTP-FDDI");
      } else if (j==5) {
	neo_port_set_descr(p, "UTP-FDDI");
      } else if (j==6) {
	neo_port_set_descr(p, "STP-FDDI");
      } else if (j==7) {
	neo_port_set_descr(p, "FDDI(sm)");
      } else if (j==8) {
	neo_port_set_descr(p, "10T");
      } else if (j==9) {
	neo_port_set_descr(p, "10F");
      } else if (j==10) {
	neo_port_set_descr(p, "FDDI(scf)");
      } else if (j==11) {
	neo_port_set_descr(p, "100TX");
      } else if (j==12) {
	neo_port_set_descr(p, "100T4");
      } else if (j==13) {
	neo_port_set_descr(p, "100F(mm)");
      } else if (j==14) {
	neo_port_set_descr(p, "OC3-ATM(mm)");
      } else if (j==15) {
	neo_port_set_descr(p, "OC3-ATM(sm)");
      } else if (j==16) {
	neo_port_set_descr(p, "OC3-ATM(utp)");
      } else if (j==17) {
	neo_port_set_descr(p, "100F(sm)");
      } else if (j==18) {
	neo_port_set_descr(p, "10/100T");
      } else if (j==19) {
	neo_port_set_descr(p, "MII");
      } else if (j==20) {
	neo_port_set_descr(p, "VLAN-RTR");
      } else if (j==21) {
	neo_port_set_descr(p, "remote-rtr");
      } else if (j==22) {
	neo_port_set_descr(p, "tkn-ring");
      } else if (j==23) {
	neo_port_set_descr(p, "OC12-ATM(mm)");
      } else if (j==24) {
	neo_port_set_descr(p, "OC12-ATM(sm)");
      } else if (j==25) {
	neo_port_set_descr(p, "DS3-ATM");
      } else if (j==26) {
	neo_port_set_descr(p, "tkn-ring(mm)");
      } else if (j==27) {
	neo_port_set_descr(p, "1000LX");
      } else if (j==28) {
	neo_port_set_descr(p, "1000SX");
      } else if (j==29) {
	neo_port_set_descr(p, "1000CX");
      } else if (j==30) {
	neo_port_set_descr(p, "net-anlsys");
      } else if (j==31) {
	neo_port_set_descr(p, "Empty (GBIC)");
      } else if (j==32) {
	neo_port_set_descr(p, "1000LH");
      } else if (j==33) {
	neo_port_set_descr(p, "1000T");
      } else if (j==34) {
	neo_port_set_descr(p, "GBIC");
      } else if (j==35) {
	neo_port_set_descr(p, "1000ZX");
      } else if (j==36) {
	neo_port_set_descr(p, "Dphone");
      } else if (j==37) {
	neo_port_set_descr(p, "T1");
      } else if (j==38) {
	neo_port_set_descr(p, "E1");
      } else if (j==39) {
	neo_port_set_descr(p, "FXS");
      } else if (j==40) {
	neo_port_set_descr(p, "FX0");
      } else if (j==41) {
	neo_port_set_descr(p, "T-DSP");
      } else if (j==42) {
	neo_port_set_descr(p, "C-DSP");
      } else if (j==55) {
	neo_port_set_descr(p, "Intru-Detect");
      } else if (j==61) {
	neo_port_set_descr(p, "1000T");
      } else {
	char tmpbuff[1024];
	sprintf(tmpbuff, "Unknown (%i)", j);
	neo_port_set_descr(p, tmpbuff);
      }
	
      /* link */
      sprintf(obj, ".1.3.6.1.4.1.9.5.1.4.1.1.6.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (atoi(buff)==2) {
	neo_port_set_link_up(p);
      } else if (atoi(buff)==1) {
	neo_port_set_link_down(p);
      } else {
	neo_port_set_link_unknown(p);
      }

      /* speed */
      sprintf(obj, ".1.3.6.1.4.1.9.5.1.4.1.1.11.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      index=atoi(buff);

      sprintf(obj, ".1.3.6.1.2.1.2.2.1.5.%i", index);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      neo_port_set_speed(p, atoi(buff));

      /* admin */
      sprintf(obj, ".1.3.6.1.2.1.17.2.15.1.4.%i", 64*(board-1)+i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) continue;
      if (atoi(buff) == 1) {
	neo_port_set_admin(p, 1);
      } else if (atoi(buff) == 2) {
	neo_port_set_admin(p, 0);
      } else {
	neo_port_set_admin(p, -1);
      }
    }
    return(NEO_TYPE_PORTLIST);

  } else {
    if (!neo_location_has_board(loc) || neo_location_star_board(loc)) {
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.5.1.2.14.0", buff);
      if (ret) {
	/* some kind of error */
	return(-1);
      }
      low=1;
      high=atoi(buff);
    } else {
      low=high=neo_location_get_boardnum(loc);
    }

    bl=out;
    for(i=low; i<=high; i++) {
      b=malloc(sizeof(neo_board));
      neo_boardlist_append_element(bl, b);

      neo_board_create(b);
      neo_board_set_number(b, i);

      /* present & type */
      sprintf(obj, ".1.3.6.1.4.1.9.5.1.3.1.1.2.%i", i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	if (neo_error==NEO_ERR_SNMP_NOVAR) {
	  neo_board_set_descr(b, "Empty");
	  neo_board_set_notpresent(b);
	}
	continue;
      }

      j=atoi(buff);
      if (j==2) {
	neo_board_set_descr(b, "Empty");
	neo_board_set_notpresent(b);
	continue;
      }
      neo_board_set_present(b);
      if (j==300) {
	neo_board_set_descr(b, "Mgmt (4012)");
      } else if (j==301) {
	neo_board_set_descr(b, "48 10/100Tx");
      } else if (j==302) {
	neo_board_set_descr(b, "2 1000X 32 10/100Tx");
      } else if (j==303) {
	neo_board_set_descr(b, "6 1000X GBIC");
      } else if (j==304) {
	neo_board_set_descr(b, "18 1000X GBIC");
      } else if (j==305) {
	neo_board_set_descr(b, "2 1000X 16 1000T");
      } else if (j==306) {
	neo_board_set_descr(b, "12 1000X GBIC");
      } else if (j==307) {
	neo_board_set_descr(b, "48 10/100Tx + 2 1000X");
      } else if (j==309) {
	neo_board_set_descr(b, "Internal Mgmt");
      } else if (j==310) {
	neo_board_set_descr(b, "Mgmt (4912)");
      } else if (j==311) {
	neo_board_set_descr(b, "24 1000SX");
      } else if (j==312) {
	neo_board_set_descr(b, "UL + 32 10/100T");
      } else if (j==313) {
	neo_board_set_descr(b, "48 10/100TX");
      } else if (j==317) {
	neo_board_set_descr(b, "24 100FX (mm)");
      } else if (j==318) {
	neo_board_set_descr(b, "Mgmt2 2 1000X");
      } else if (j==319) {
	neo_board_set_descr(b, "32 10/100TX 2 1000X(R)");
      } else if (j==320) {
	neo_board_set_descr(b, "1 1000(R) + card");
      } else if (j==321) {
	neo_board_set_descr(b, "2 1000X 12 1000T");
      } else if (j==322) {
	neo_board_set_descr(b, "Mgmt (for 2000)");
      } else if (j==323) {
	neo_board_set_descr(b, "48 10/100TX");
      } else if (j==324) {
	neo_board_set_descr(b, "32 10/100TX 2 1000X");
      } else if (j==325) {
	neo_board_set_descr(b, "Switch Fabric Module");
      } else if (j==326) {
	neo_board_set_descr(b, "48 10/100T Voice Power");
      } else if (j==330) {
	neo_board_set_descr(b, "24 10/100/1000T");
      } else {
	char tmpbuff[1024];
	sprintf(tmpbuff, "Unknown (%i)", j);
	neo_board_set_descr(b, tmpbuff);
      }

      neo_board_set_link_down(b);
      
    }
    return(NEO_TYPE_BOARDLIST);
  }
}
