#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include "neo.h"

int neo_command_port_sed_cat5000(neo_location *loc, int command) {
  int board, port, ifport, ret;

  board=neo_location_get_boardnum(loc);
  port=neo_location_get_portnum(loc);

  if (board<1 || board>5) {
    printf("Invalid board.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  if (board==1) {
    printf("Warning, this may be the uplink as it's on board 1.\n");
    if (!are_you_sure(NULL)) return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  if (port<1 || port>64) {
    printf("Invalid port.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  /* figure out the port from the board/port */
  /* maybe of a hack, we could look it up if we have to */
  ifport=64*(board-1)+port;

  if (ifport==-1) {
    printf("Invalid board/port pair.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  ret=neo_command_port_sed_standardbridge_helper(loc, command, ifport);
  return(ret);
}


int neo_command_locate_cat5000(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink) {
  /* see docs for contract */
  neo_location *loc;
  int ret;
  char tmp[300];
  int board, port;

  ret=neo_command_locate_standardbridge_helper(d, s);
  if (ret==-1) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
      return(-1);
    } else {
      return(0);
    }
  }

  board=(ret/64)+1;
  port=ret%64;

  /* we won't do any uplink filtering here for now */
  
  loc=malloc(sizeof(neo_location));
  sprintf(tmp, "%i/%i@%s", board, port, neo_device_get_name(d));
  ret=neo_location_create_from_string(loc, tmp);
  if (ret) {
    printf("Internal error generating neo_location from answer\n");
    neo_error=NEO_ERR_INTERNAL;
    return(-1);
  }
  neo_locationlist_append_element(ans, loc);
  return(0);
}

int neo_command_device_summary_cat5000(neo_device *d, neo_location *loc, neo_list *out) {
  int high, low, board, i, j, ret, index;
  neo_portlist *pl;
  neo_port *p;
  neo_boardlist *bl;
  neo_board *b;
  char buff[30], obj[1024];

  if (neo_location_has_port(loc)) {
    /* do port summary */
    if (neo_location_star_board(loc)) {
      printf("Cannot currently summarize multiple ports on multiple boards at one time\n");
      return(-1);
    }
    board=neo_location_get_boardnum(loc);
    
    if (neo_location_star_port(loc)) {
      sprintf(obj, ".1.3.6.1.4.1.9.5.1.3.1.1.14.%i", board);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	/* need an error */
	return(-1);
      }
      low=1;
      high=atoi(buff);
    } else {
      high=low=neo_location_get_portnum(loc);
    }
    pl=out;
    for(i=low; i<=high; i++) {
      p=malloc(sizeof(neo_port));
      neo_portlist_append_element(pl, p);

      neo_port_create(p);
      neo_port_set_number(p, i);

      sprintf(obj, ".1.3.6.1.4.1.9.5.1.4.1.1.5.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) continue;
      j=atoi(buff);
      if (j==1) {
	neo_port_set_descr(p, "other");
      } else if (j==2) {
	neo_port_set_descr(p, "CDDI");
      } else if (j==3) {
	neo_port_set_descr(p, "FDDI(mm)");
      } else if (j==4) {
	neo_port_set_descr(p, "UTP-FDDI");
      } else if (j==5) {
	neo_port_set_descr(p, "UTP-FDDI");
      } else if (j==6) {
	neo_port_set_descr(p, "STP-FDDI");
      } else if (j==7) {
	neo_port_set_descr(p, "FDDI(sm)");
      } else if (j==8) {
	neo_port_set_descr(p, "10T");
      } else if (j==9) {
	neo_port_set_descr(p, "10F");
      } else if (j==10) {
	neo_port_set_descr(p, "FDDI(scf)");
      } else if (j==11) {
	neo_port_set_descr(p, "100TX");
      } else if (j==12) {
	neo_port_set_descr(p, "100T4");
      } else if (j==13) {
	neo_port_set_descr(p, "100F(mm)");
      } else if (j==14) {
	neo_port_set_descr(p, "OC3-ATM(mm)");
      } else if (j==15) {
	neo_port_set_descr(p, "OC3-ATM(sm)");
      } else if (j==16) {
	neo_port_set_descr(p, "OC3-ATM(utp)");
      } else if (j==17) {
	neo_port_set_descr(p, "100F(sm)");
      } else if (j==18) {
	neo_port_set_descr(p, "10/100T");
      } else if (j==19) {
	neo_port_set_descr(p, "MII");
      } else if (j==20) {
	neo_port_set_descr(p, "VLAN-RTR");
      } else if (j==21) {
	neo_port_set_descr(p, "remote-rtr");
      } else if (j==22) {
	neo_port_set_descr(p, "tkn-ring");
      } else if (j==23) {
	neo_port_set_descr(p, "OC12-ATM(mm)");
      } else if (j==24) {
	neo_port_set_descr(p, "OC12-ATM(sm)");
      } else if (j==25) {
	neo_port_set_descr(p, "DS3-ATM");
      } else if (j==26) {
	neo_port_set_descr(p, "tkn-ring(mm)");
      } else if (j==27) {
	neo_port_set_descr(p, "1000LX");
      } else if (j==28) {
	neo_port_set_descr(p, "1000SX");
      } else if (j==29) {
	neo_port_set_descr(p, "1000CX");
      } else if (j==30) {
	neo_port_set_descr(p, "net-anlsys");
      } else if (j==31) {
	neo_port_set_descr(p, "Empty (GBIC)");
      } else if (j==32) {
	neo_port_set_descr(p, "1000LH");
      } else if (j==33) {
	neo_port_set_descr(p, "1000T");
      } else if (j==34) {
	neo_port_set_descr(p, "GBIC");
      } else if (j==35) {
	neo_port_set_descr(p, "1000ZX");
      } else if (j==36) {
	neo_port_set_descr(p, "Dphone");
      } else if (j==37) {
	neo_port_set_descr(p, "T1");
      } else if (j==38) {
	neo_port_set_descr(p, "E1");
      } else if (j==39) {
	neo_port_set_descr(p, "FXS");
      } else if (j==40) {
	neo_port_set_descr(p, "FX0");
      } else if (j==41) {
	neo_port_set_descr(p, "T-DSP");
      } else if (j==42) {
	neo_port_set_descr(p, "C-DSP");
      } else if (j==55) {
	neo_port_set_descr(p, "Intru-Detect");
      }

      /* link */
      sprintf(obj, ".1.3.6.1.4.1.9.5.1.4.1.1.6.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (atoi(buff)==2) {
	neo_port_set_link_up(p);
      } else if (atoi(buff)==1) {
	neo_port_set_link_down(p);
      } else {
	neo_port_set_link_unknown(p);
      }

      /* speed */
      sprintf(obj, ".1.3.6.1.4.1.9.5.1.4.1.1.11.%i.%i", board, i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      index=atoi(buff);

      sprintf(obj, ".1.3.6.1.2.1.2.2.1.5.%i", index);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      neo_port_set_speed(p, atoi(buff));

      /* admin */
      sprintf(obj, ".1.3.6.1.2.1.17.2.15.1.4.%i", 64*(board-1)+i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) continue;
      if (atoi(buff) == 1) {
	neo_port_set_admin(p, 1);
      } else if (atoi(buff) == 2) {
	neo_port_set_admin(p, 0);
      } else {
	neo_port_set_admin(p, -1);
      }
    }
    return(NEO_TYPE_PORTLIST);
  } else {
    if (!neo_location_has_board(loc) || neo_location_star_board(loc)) {
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.5.1.2.14.0", buff);
      if (ret) {
	/* some kind of error */
	return(0);
      }
      low=1;
      high=atoi(buff);
    } else {
      low=high=neo_location_get_boardnum(loc);
    }

    bl=out;
    for(i=low; i<=high; i++) {
      b=malloc(sizeof(neo_board));
      neo_boardlist_append_element(bl, b);

      neo_board_create(b);
      neo_board_set_number(b, i);

      /* present & type */
      sprintf(obj, ".1.3.6.1.4.1.9.5.1.3.1.1.2.%i", i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	if (neo_error==NEO_ERR_SNMP_NOVAR) {
	  neo_board_set_descr(b, "Empty");
	  neo_board_set_notpresent(b);
	}
	continue;
      }

      j=atoi(buff);
      if (j==2) {
	neo_board_set_descr(b, "Empty");
	neo_board_set_notpresent(b);
	continue;
      }
      neo_board_set_present(b);
      if (j==23) {
	neo_board_set_descr(b, "Mgmt-1 (100TX)"); /* 2 x 100Tx */
      } else if (j==24) {
	neo_board_set_descr(b, "24 10T");
      } else if (j==25) {
	neo_board_set_descr(b, "12 10FL(st)");
      } else if (j==26) {
	neo_board_set_descr(b, "14 10T(tel)");
      } else if (j==27) {
	neo_board_set_descr(b, "12 100TX");
      } else if (j==28) {
	neo_board_set_descr(b, "1 FDDI");
      } else if (j==29) {
	neo_board_set_descr(b, "1 CDDI");
      } else if (j==30) {
	neo_board_set_descr(b, "1 FDDI(sm)");
      } else if (j==32) {
	neo_board_set_descr(b, "1 OC3(mm)");
      } else if (j==33) {
	neo_board_set_descr(b, "1 OC3(sm)");
      } else if (j==38) {
	neo_board_set_descr(b, "Mgmt-1 FX");
      } else if (j==39) {
	neo_board_set_descr(b, "Mgmt-1 FX");
      } else if (j==40) {
	neo_board_set_descr(b, "Mgmt-2 TX");
      } else if (j==41) {
	neo_board_set_descr(b, "Mgmt-2 FX");
      } else if (j==42) {
	neo_board_set_descr(b, "Mgmt-2 FX");
      } else if (j==49 || j==79 || j==74) {
        neo_board_set_descr(b, "24 10T");
      } else if (j==53) {
        neo_board_set_descr(b, "12 10T");
      } else if (j==57) {
	neo_board_set_descr(b, "Mgmt-3");
      } else if (j==68) {
	neo_board_set_descr(b, "9 1000X");
      } else if (j==73) {
	neo_board_set_descr(b, "12 100FX");
      } else if (j==77) {
	neo_board_set_descr(b, "24 100FX");
      } else {
        neo_board_set_descr(b, "Unknown");
      }

      neo_board_set_link_down(b);
      
    }
    return(NEO_TYPE_BOARDLIST);
  }
}




int neo_command_stats_cat5000(neo_location *loc, neo_portlist *pl) {
  neo_statstransfer *st, *a, *b;
  neo_device *d;
  neo_list *stlist1, *stlist2, *stlistcur;
  neo_port *p;
  neo_stats *s;
  neo_sleeper sleeper;
  int i, j, portnum, ret, done;
  char obj[1024], val[1024];

  d=neo_location_get_first_device(loc);
  printf("Getting device summary ...\n");
  ret=neo_device_command_summary(d, loc, pl);
  if (ret==NEO_TYPE_BOARDLIST) {
    printf("--> Currently you may only get stats on ports or groups or ports, not boards <--\n");
    return(0);
  }

  j=neo_portlist_get_size(pl);
  stlist1=malloc(sizeof(neo_list));
  stlist2=malloc(sizeof(neo_list));
  neo_list_create(stlist1);
  neo_list_create(stlist2);

  neo_sleeper_create(&sleeper, neo_global_get_statsdelay(g));
  /* do it twice first with stlistcur=stlist1 then stlistcur=stlist2 */
  done=0;
  for (stlistcur=stlist1,done=0; done<2; stlistcur=stlist2, done++) {
    if (done==0) {
      printf("Getting first set of stats...\n");
    } else {
      printf("Getting second set of stats...\n");
    }


    sprintf(obj, ".1.3.6.1.4.1.9.5.1.4.1.1.11.%i.%i", neo_location_get_boardnum(loc), 1);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
    if (ret) {
      if (neo_error==NEO_ERR_SNMP_NOVAR) {
	printf("Error looking up port number\n");
	return(-1);
      } else {
	printf("Unknown error looking up port number\n");
	return(-1);
      }
    }
    portnum=atoi(val);

    for (i=0; i<j; i++) {
      p=neo_portlist_get_element(pl, i);
      
      st=malloc(sizeof(neo_statstransfer));
      neo_list_append_element(stlistcur, st);

      neo_statstransfer_init(st);
      neo_command_stats_standardbridge_helper(d, st, portnum+neo_port_get_number(p)-1);
    }
    /* do the necessary delay here */
    if (done==0) {
      neo_sleeper_dowait(&sleeper);
    }
  }

  s=malloc(sizeof(neo_stats));
  /* now for each port do the stats transfer calculation */
  for (i=0; i<j; i++) {
    p=neo_portlist_get_element(pl, i);
    a=neo_list_get_element(stlist1, i);
    b=neo_list_get_element(stlist2, i);

    /* calculate and set for port */
    neo_statstransfer_compute_stats(a, b, s);
    neo_port_set_stats(p, s);
  }

  /* free the statstransfer lists */
  return(NEO_TYPE_PORTLIST);
}



int neo_command_device_load_cat5000(neo_location *loc, int type, int direction, char *host, char *file) {
  neo_device *d;
  int ret, action;
  char val[10];

  /*
    enterprises.cisco.workgroup.ciscoStackMIB.tftpGrp.tftpHost.0 = "18.86.0.37"
    enterprises.cisco.workgroup.ciscoStackMIB.tftpGrp.tftpFile.0 = "cat5000-sup3.4-5-1.bin"
    enterprises.cisco.workgroup.ciscoStackMIB.tftpGrp.tftpModule.0 = 1
    enterprises.cisco.workgroup.ciscoStackMIB.tftpGrp.tftpAction.0 = other(1)
    enterprises.cisco.workgroup.ciscoStackMIB.tftpGrp.tftpResult.0 = success(2)
  */

  d=neo_location_get_first_device(loc);

  ret=neo_snmp_set_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.5.1.5.1.0", "string", host);
  if (ret) {
    printf("Error setting hostname on switch\n");
    return(-1);
  }

  ret=neo_snmp_set_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.5.1.5.2.0", "string", file);
  if (ret) {
    printf("Error setting filename on switch\n");
    return(-1);
  }

  /* set the module to 1 for now */
  ret=neo_snmp_set_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.5.1.5.3.0", "int", "1");
  if (ret) {
    printf("Error setting module number on switch\n");
    return(-1);
  }

  
  /* what kind of action? */
  action=-1;
  if (direction==NEO_COMMAND_DEVICE_LOAD_DOWNLOAD) {
    if (type==NEO_COMMAND_DEVICE_LOAD_CONFIG) {
      action=3;
    } else if (type==NEO_COMMAND_DEVICE_LOAD_IMAGE) {
      action=5;
    }
  } else if (direction==NEO_COMMAND_DEVICE_LOAD_UPLOAD) {
    if (type==NEO_COMMAND_DEVICE_LOAD_CONFIG) {
      action=2;
    } else if (type==NEO_COMMAND_DEVICE_LOAD_IMAGE) {
      action=4;
    }
  }
  if (action==-1) {
    printf("Internal error figuring out what kind of load to do.\n");
    return(-1);
  }
  
  sprintf(val, "%i", action);
  ret=neo_snmp_set_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.5.1.5.4.0", "int", val);
  return(ret);
}

int neo_device_cat5000_boardport_to_ifnum_one(neo_device *d, int boardnum, int portnum) {
  char obj[1024], val[1024];
  int ret;
  
  sprintf(obj, ".1.3.6.1.4.1.9.5.1.4.1.1.11.%i.%i", boardnum, portnum);
  ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
  if (ret) {
    if (neo_error==NEO_ERR_SNMP_NOVAR) {
      printf("Error looking up port number\n");
      return(-1);
    } else {
      printf("Unknown error looking up port number\n");
      return(-1);
    }
  }
  return(atoi(val));
}

int neo_device_cat5000_boardport_to_ifnum_two(neo_device *d, int boardnum, int portnum) {
  return((64*(boardnum-1))+portnum);
}


int neo_command_port_search_cat5000(neo_location *loc) {
  neo_device *d;
  int ret, ifnum;

  if (!neo_location_has_port(loc)) {
    printf("You must specify a port to search.\n");
    return(-1);
  }

  d=neo_location_get_first_device(loc);

  ifnum=neo_device_cat5000_boardport_to_ifnum_two(d, neo_location_get_boardnum(loc), neo_location_get_portnum(loc));
  if (ifnum<0) {
    printf("Error getting interface number\n");
    return(-1);
  }
  ret=neo_command_port_search_standardbridge_helper(d, ifnum);

  return(0);
}

void neo_command_device_info_cat5000(neo_device *d, int type) {
    int ret, i;
  char val[1024];

  if (type==NEO_COMMAND_DEVICE_INFO_POWER) {
    printf("Power info not yet supported on this device\n");
  } else if (type==NEO_COMMAND_DEVICE_INFO_WEATHER) {
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.5.1.2.9.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("Chassis Fan: ");
      if (i==2) {
	printf("ok\n");
      } else if (i==3) {
	printf("minor fault\n");
      } else if (i==4) {
	printf("major fault\n");
      } else if (i==1) {
	printf("other\n");
      } else {
	printf("unsupported vaule\n");
      }
      if (i==3 || i==4) {
	ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.5.1.2.10.0", val);
	if (ret) {
	  printf("Error getting info.\n");
	} else {
	  printf("   %s\n", val);
	}
      }
    }
  } else if (type==NEO_COMMAND_DEVICE_INFO_CPU) {
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.5.1.1.8.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("\nBandwidth Utilization: %i%%\n", i);
    }

  } else {
    printf("Internal Error\n");
  }

}
