#include <stdio.h>
#include <stdlib.h>
#include "neo.h"

int neo_command_locate_ciscowav(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink) {
  /* see docs for contract */
  neo_location *loc;
  int ret;
  char tmp[300];

  ret=neo_command_locate_standardbridge_helper(d, s);
  if (ret==-1) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
      return(-1);
    } else {
      return(0);
    }
  }

  if (ret != 1) {
    return(0);
  }
  
  loc=malloc(sizeof(neo_location));
  sprintf(tmp, "%s", neo_device_get_name(d));
  ret=neo_location_create_from_string(loc, tmp);
  if (ret) {
    printf("Internal error generating neo_location from answer\n");
    neo_error=NEO_ERR_INTERNAL;
    return(-1);
  }
  neo_locationlist_append_element(ans, loc);
  return(0);
}

int neo_command_port_search_ciscowav(neo_location *loc) {
  neo_device *d;
  int ret;

  d=neo_location_get_first_device(loc);

  ret=neo_command_port_search_standardbridge_helper(d, 1);

  return(0);
}
