#include <stdio.h>
#include <stdlib.h>
#include "neo.h"

int neo_device_extalp_boardport_to_ifnum(int boardnum, int portnum) {
  return((1000*boardnum)+portnum);
}

int neo_device_extalp_ifnum_to_boardnum(int ifnum) {
  return(ifnum/1000);
}

int neo_device_extalp_ifnum_to_portnum(int ifnum) {
  return(ifnum-(ifnum/1000));
}

int neo_command_port_sed_extalp(neo_location *loc, int command) {
  int board, port, ifport, ret;

  board=neo_location_get_boardnum(loc);
  port=neo_location_get_portnum(loc);

  if (board<1 || board>16) {
    printf("Invalid board.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  if (port<1 || port>64) {
    printf("Invalid port.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  /* figure out the port from the board/port */
  /* maybe of a hack, we could look it up if we have to */
  ifport=neo_device_extalp_boardport_to_ifnum(board, port);

  if (ifport==-1) {
    printf("Invalid board/port pair.\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  ret=neo_command_port_sed_standardbridge_helper(loc, command, ifport);
  return(ret);
}




int neo_command_locate_extalp(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink) {
  /* see docs for contract */
  neo_location *loc;
  int ret;
  char tmp[300];
  int board, port;

  ret=neo_command_locate_standardbridge_helper(d, s);
  if (ret==-1) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
      return(-1);
    } else {
      return(0);
    }
  }

  board=(ret/64)+1;
  port=ret%64;
  
  loc=malloc(sizeof(neo_location));
  sprintf(tmp, "%i/%i@%s", board, port, neo_device_get_name(d));
  ret=neo_location_create_from_string(loc, tmp);
  if (ret) {
    printf("Internal error generating neo_location from answer\n");
    neo_error=NEO_ERR_INTERNAL;
    return(-1);
  }
  neo_locationlist_append_element(ans, loc);
  return(0);
}

int neo_command_port_search_extalp(neo_location *loc) {
  neo_device *d;
  int ret, ifnum;

  if (!neo_location_has_port(loc)) {
    printf("You must specify a port to search.\n");
    return(-1);
  }

  d=neo_location_get_first_device(loc);

  ifnum=neo_device_cat5000_boardport_to_ifnum_two(d, neo_location_get_boardnum(loc), neo_location_get_portnum(loc));
  /* ifnum=neo_device_extalp_boardport_to_ifnum(neo_location_get_boardnum(loc), neo_location_get_portnum(loc)); */
  if (ifnum<0) {
    printf("Error getting interface number\n");
    return(-1);
  }
  ret=neo_command_port_search_standardbridge_helper(d, ifnum);

  return(0);
}



int neo_command_device_summary_extalp(neo_device *d, neo_location *loc, neo_list *out) {
  int high, low, board, i, j, ret, ifnum;
  neo_portlist *pl;
  neo_port *p;
  neo_boardlist *bl;
  neo_board *b;
  char *descr="Unknown";
  char buff[30], obj[1024];

  i=0; /* just to make -Wall shut up */
  if (neo_location_has_port(loc)) {
    /* do port summary */
    if (neo_location_star_board(loc)) {
      printf("Cannot currently summarize multiple ports on multiple boards at one time\n");
      return(-1);
    }
    board=neo_location_get_boardnum(loc);

    sprintf(obj, ".1.3.6.1.4.1.1916.1.1.2.2.1.4.%i", board);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
    if (ret) {
      printf("Error getting board type\n");
      return(-1);
    }
    j=atoi(buff);
    if (j==1) {
      printf("This board is empty.\n");
      return(-1);
    } else if (j==2) {
      descr="fe32";
      high=32;
    } else if (j==3) {
      descr="g4x";
      high=4;
    } else if (j==4) {
      descr="g6x";
      high=6;
    } else if (j==5) {
      descr="fe32fx";
      high=32;
    } else if (j==6) {
      descr="msm";
      high=48; /* ? */
    } else if (j==7) {
      descr="10/100TX";
      high=48;
    } else if (j==8) {
      descr="GBIC";
      high=8;
    } else if (j==9) {
      descr="g8ti";
      high=8;
    } else if (j==10) {
      descr="12 1000SX";
      high=12;
    } else if (j==11) {
      descr="g12ti";
      high=12;
    } else if (j==18) {
      descr="msm64i";
      high=64;
    } else if (j==19) {
      descr="mgmt3808";
      high=48; /* ? */
    } else if (j==20) {
      descr="mgmt3804";
      high=48; /* ? */
    } else if (j==21) {
      descr="10/100Tx";
      high=32;
    } else if (j==22) {
      descr="GBIC";
      high=4;
    } else if (j==23) {
      descr="gm4sx";
      high=4;
    } else if (j==24) {
      descr="gm4t";
      high=4;
    } else if (j==25) {
      descr="wdm8";
      high=8;
    } else if (j==26) {
      descr="fm24f";
      high=24;
    } else {
      descr=malloc(30);
      sprintf(descr, "Unknown(%i)", j);
      high=48; /* */
    }
    
    low=1;	      
    if (!neo_location_star_port(loc)) {
      high=low=neo_location_get_portnum(loc);
    }

    pl=out;
    for(i=low; i<=high; i++) {
      p=malloc(sizeof(neo_port));
      neo_portlist_append_element(pl, p);
      
      neo_port_create(p);
      neo_port_set_number(p, i);

      ifnum=neo_device_extalp_boardport_to_ifnum(board, i);
      neo_port_set_descr(p, descr);
      
      /* link */
      /* interfaces.ifTable.ifEntry.ifOperStatus.%i */
      sprintf(obj, ".1.3.6.1.2.1.2.2.1.8.%i", ifnum);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	continue;
      } else {
	if (atoi(buff)==1) {
	  neo_port_set_link_up(p);
	} else if (atoi(buff)==2) {
	  neo_port_set_link_down(p);
	} else {
	  neo_port_set_link_unknown(p);
	}
      }

      /* speed */
      /* interfaces.ifTable.ifEntry.ifSpeed.%i */
      sprintf(obj, ".1.3.6.1.2.1.2.2.1.5.%i", ifnum);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	continue;
      } else {
	neo_port_set_speed(p, atoi(buff));
      }

      /* admin status */
      sprintf(obj, ".1.3.6.1.2.1.2.2.1.7.%i", ifnum);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	continue;
      } else {
	if (atoi(buff)==1) {
	  neo_port_set_admin(p, 1);
	} else if (atoi(buff)==2) {
	  neo_port_set_admin(p, 0);
	} else {
	  neo_port_set_admin(p, -1);
	}
      }
    }
    
    return(NEO_TYPE_PORTLIST);
  } else {
    /* guess at the number of boards */
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.1916.1.1.2.1.0", buff);
    if (ret) {
      printf("Error getting numer of boards.\n");
      return(-1);
    }

    if (!neo_location_has_board(loc) || neo_location_star_board(loc)) {
      low=1;
      high=atoi(buff)-1;
    } else {
      low=high=neo_location_get_boardnum(loc);
    }
    
    bl=out;
    for(i=low; i<=high; i++) {
      b=malloc(sizeof(neo_board));
      neo_boardlist_append_element(bl, b);
      
      neo_board_create(b);
      neo_board_set_number(b, i);

      /* present and type */
      sprintf(obj, ".1.3.6.1.4.1.1916.1.1.2.2.1.4.%i", i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	printf("Error getting board type\n");
	return(-1);
      }
      j=atoi(buff);
      if (j==1) {
	neo_board_set_descr(b, "Empty");
	neo_board_set_notpresent(b);
	continue;
      }

      if (j==2) {
	neo_board_set_descr(b, "fe32");
      } else if (j==3) {
	neo_board_set_descr(b, "g4x");
      } else if (j==4) {
	neo_board_set_descr(b, "g6x");
      } else if (j==5) {
	neo_board_set_descr(b, "fe32fx");
      } else if (j==6) {
	neo_board_set_descr(b, "msm");
      } else if (j==7) {
	neo_board_set_descr(b, "48 10/100TX");
      } else if (j==8) {
	neo_board_set_descr(b, "8 GBIC");
      } else if (j==9) {
	neo_board_set_descr(b, "g8ti");
      } else if (j==10) {
	neo_board_set_descr(b, "12 1000SX");
      } else if (j==11) {
	neo_board_set_descr(b, "g12ti");
      } else if (j==18) {
	neo_board_set_descr(b, "msm64i");
      } else if (j==19) {
	neo_board_set_descr(b, "mgmt3808");
      } else if (j==20) {
	neo_board_set_descr(b, "mgmt3804");
      } else if (j==21) {
	neo_board_set_descr(b, "32 10/100Tx");
      } else if (j==22) {
	neo_board_set_descr(b, "4 GBIC");
      } else if (j==23) {
	neo_board_set_descr(b, "gm4sx");
      } else if (j==24) {
	neo_board_set_descr(b, "gm4t");
      } else if (j==25) {
	neo_board_set_descr(b, "wdm8");
      } else if (j==26) {
	neo_board_set_descr(b, "fm24f");
      } else {
	char ptr[30];
	sprintf(ptr, "Unknown(%i)", j);
	neo_board_set_descr(b, ptr);
      }
      
      neo_board_set_link_down(b);
      
    }
    return(NEO_TYPE_BOARDLIST);
  }
}



int neo_command_stats_extalp(neo_location *loc, neo_portlist *pl) {
  neo_statstransfer *st, *a, *b;
  neo_device *d;
  neo_list *stlist1, *stlist2, *stlistcur;
  neo_port *p;
  neo_stats *s;
  neo_sleeper sleeper;
  int i, j, portnum, ret, done;

  d=neo_location_get_first_device(loc);
  printf("Getting device summary ...\n");
  ret=neo_device_command_summary(d, loc, pl);
  if (ret==NEO_TYPE_BOARDLIST) {
    printf("--> Currently you may only get stats on ports or groups or ports, not boards <--\n");
    return(0);
  }

  j=neo_portlist_get_size(pl);
  stlist1=malloc(sizeof(neo_list));
  stlist2=malloc(sizeof(neo_list));
  neo_list_create(stlist1);
  neo_list_create(stlist2);

  neo_sleeper_create(&sleeper, neo_global_get_statsdelay(g));
  /* do it twice first with stlistcur=stlist1 then stlistcur=stlist2 */
  done=0;
  for (stlistcur=stlist1,done=0; done<2; stlistcur=stlist2, done++) {
    if (done==0) {
      printf("Getting first set of stats...\n");
    } else {
      printf("Getting second set of stats...\n");
    }


    /* this is from an old optimization we did for the cat5000, remove it */
    portnum=neo_device_extalp_boardport_to_ifnum(neo_location_get_boardnum(loc), 1);

    for (i=0; i<j; i++) {
      p=neo_portlist_get_element(pl, i);
      
      st=malloc(sizeof(neo_statstransfer));
      neo_list_append_element(stlistcur, st);

      neo_statstransfer_init(st);
      neo_command_stats_standardbridge_helper(d, st, portnum+neo_port_get_number(p)-1);
    }
    /* do the necessary delay here */
    if (done==0) {
      neo_sleeper_dowait(&sleeper);
    }
  }

  s=malloc(sizeof(neo_stats));
  /* now for each port do the stats transfer calculation */
  for (i=0; i<j; i++) {
    p=neo_portlist_get_element(pl, i);
    a=neo_list_get_element(stlist1, i);
    b=neo_list_get_element(stlist2, i);

    /* calculate and set for port */
    neo_statstransfer_compute_stats(a, b, s);
    neo_port_set_stats(p, s);
  }

  /* free the statstransfer lists */
  return(NEO_TYPE_PORTLIST);
}

void neo_command_device_info_extalp(neo_device *d, int type) {
  int ret, i;
  char val[1024], obj[1024];
  
  if (type==NEO_COMMAND_DEVICE_INFO_POWER) {
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.1916.1.1.1.10.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("Primary Power:     ");
      i=atoi(val);
      if (i==1) {
	printf("Running\n");
      } else {
	printf("Down\n");
      }
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.1916.1.1.1.11.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("Redundant Power:   ");
      i=atoi(val);
      if (i==1) {
	printf("Not installed.\n");
      } else if (i==2) {
	printf("Installed and running\n");
      } else if (i==3) {
	printf("Installed and down\n");
      }
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.1916.1.1.1.12.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("Power Alarm:       ");
      i=atoi(val);
      if (i==1) {
	printf("Alarm Condition Set\n");
      } else {
	printf("No Alarm\n");
      }
    }

  } else if (type==NEO_COMMAND_DEVICE_INFO_WEATHER) {

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.1916.1.1.1.7.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("Temp Alarm:    ");
      i=atoi(val);
      if (i==1) {
	printf("Alarm Condition Set\n");
      } else {
	printf("No Alarm\n");
      }
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.1916.1.1.1.8.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("Temperature:   %i C\n", atoi(val));
    }

    for (i=1;;i++) {
      sprintf(obj, ".1.3.6.1.4.1.1916.1.1.1.9.1.2.%i", i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
      if (ret) {
	if (neo_error==NEO_ERR_SNMP_NOVAR) break;
	printf("Error getting info.\n");
      } else {
	printf("Fan %i:         ", i);
	if (atoi(val)==1) {
	  printf("Running\n");
	} else {
	  printf("Down\n");
	}
      }
    }

    

  } else {
    printf("Internal error.\n");
  }
}
