#include <stdio.h>
#include <stdlib.h>
#include "neo.h"

int neo_command_port_sed_extsum24(neo_location *loc, int command) {
  int port;
  char obj[1024], val[30];
  int a, ret;
  char *device;
  
  port=neo_location_get_portnum(loc);

  if (port<1 || port>25) { /* check */
    printf("Invalid port\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }

  /* check */
  if (port==25) {
    printf("Warning, this port may be the uplink\n");
    if (!are_you_sure(NULL)) return(NEO_COMMAND_PORT_IS_SILENTERR);
  }
  
  device=neo_device_get_name(neo_location_get_first_device(loc));
  sprintf(obj, ".1.3.6.1.2.1.2.2.1.7.%i", port);

  if (command == NEO_COMMAND_PORT_STATUS) {
    ret=neo_snmp_request_by_variable(device, obj, val);
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
        printf("Could not contact device %s\n", device);
      } else {
        printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    a=atoi(val);
    if (a==1) return(NEO_COMMAND_PORT_IS_ENABLED);
    if (a==2) return(NEO_COMMAND_PORT_IS_DISABLED);
    return(NEO_COMMAND_PORT_IS_UNKNOWN);
  } else if (command == NEO_COMMAND_PORT_ENABLE) {
    ret=neo_snmp_set_by_variable(device, obj, "int", "1");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
        printf("Could not contact device %s\n", device);
      } else {
        printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_ENABLED);
  } else if (command == NEO_COMMAND_PORT_DISABLE) {
    ret=neo_snmp_set_by_variable(device, obj, "int", "2");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
        printf("Could not contact device %s\n", device);
      } else {
        printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_DISABLED);
  }
  return(0);
}

int neo_command_device_summary_extsum24(neo_device *d, neo_location *loc, neo_list *pl) {
  /* put everything into a port list */
  neo_port *p;
  char buff[30], obj[1024];
  int i, ret, low, high;

  if (neo_location_has_port(loc) && !neo_location_star_port(loc)) {
    low=high=neo_location_get_portnum(loc);
  } else {
    low=1;
    high=25;
  }

  for (i=low; i<=high; i++) {
    p=malloc(sizeof(neo_port));
    neo_port_create(p);
    neo_portlist_append_element(pl, p);

    /* number */
    neo_port_set_number(p, i);

    /* descr and uplink */
    /* this is cheating, we should come back to it */
    if (i<25) {
      neo_port_set_descr(p, "10/100");
      neo_port_set_uplink(p, 0);
    } else if (i==25) {
      neo_port_set_descr(p, "GBIC");
      neo_port_set_uplink(p, 1);
    }


    /* link */
    /* interfaces.ifTable.ifEntry.ifOperStatus.%i */
    sprintf(obj, ".1.3.6.1.2.1.2.2.1.8.%i", i);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
    if (ret) {
      continue;
    } else {
      if (atoi(buff)==1) {
	neo_port_set_link_up(p);
      } else if (atoi(buff)==2) {
	neo_port_set_link_down(p);
      } else {
	neo_port_set_link_unknown(p);
      }
    }

    /* speed */
    /* interfaces.ifTable.ifEntry.ifSpeed.%i */
    sprintf(obj, ".1.3.6.1.2.1.2.2.1.5.%i", i);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
    if (ret) {
      continue;
    } else {
      neo_port_set_speed(p, atoi(buff));
    }

    /* admin status */
    sprintf(obj, ".1.3.6.1.2.1.2.2.1.7.%i", i);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
    if (ret) {
      continue;
    } else {
      if (atoi(buff)==1) {
	neo_port_set_admin(p, 1);
      } else if (atoi(buff)==2) {
	neo_port_set_admin(p, 0);
      } else {
	neo_port_set_admin(p, -1);
      }
    }

  }
  return(NEO_TYPE_PORTLIST);
}

int neo_command_stats_extsum24(neo_location *loc, neo_portlist *pl) {
  neo_statstransfer *st, *a, *b;
  neo_device *d;
  neo_list *stlist1, *stlist2, *stlistcur;
  neo_port *p;
  neo_stats *s;
  neo_sleeper sleeper;
  int i, j, portnum, ret, done;

  d=neo_location_get_first_device(loc);
  ret=neo_command_device_summary_extsum24(d, loc, pl);
  j=neo_portlist_get_size(pl);
  stlist1=malloc(sizeof(neo_list));
  stlist2=malloc(sizeof(neo_list));
  neo_list_create(stlist1);
  neo_list_create(stlist2);

  neo_sleeper_create(&sleeper, neo_global_get_statsdelay(g));
  /* do it twice first with stlistcur=stlist1 then stlistcur=stlist2 */
  done=0;
  for (stlistcur=stlist1,done=0; done<2; stlistcur=stlist2, done++) {
    if (done==0) {
      printf("Getting first set of stats...\n");
    } else {
      printf("Getting second set of stats...\n");
    }
    for (i=0; i<j; i++) {
      p=neo_portlist_get_element(pl, i);
      portnum=neo_port_get_number(p);

      st=malloc(sizeof(neo_statstransfer));
      neo_list_append_element(stlistcur, st);

      neo_statstransfer_init(st);

      neo_command_stats_standardbridge_helper(d, st, portnum);
    }

    /* do the necessary delay here */
    if (done==0) {
      neo_sleeper_dowait(&sleeper);
    }
  }

  s=malloc(sizeof(neo_stats));
  /* now for each port do the stats transfer calculation */
  for (i=0; i<j; i++) {
    p=neo_portlist_get_element(pl, i);
    a=neo_list_get_element(stlist1, i);
    b=neo_list_get_element(stlist2, i);

    /* calculate and set for port */
    neo_statstransfer_compute_stats(a, b, s);
    neo_port_set_stats(p, s);
  }

  /* free the statstransfer lists */
  return(NEO_TYPE_PORTLIST);
}

int neo_command_locate_extsum24(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink) {
  /* see docs for contract */
  neo_location *loc;
  int ret;
  char tmp[300];

  ret=neo_command_locate_standardbridge_helper(d, s);
  if (ret==-1) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
      return(-1);
    } else {
      return(0);
    }
  }

  if (!uplink && ret>25) { /* check */
    return(0);
  }
  
  loc=malloc(sizeof(neo_location));
  sprintf(tmp, "%i@%s", ret, neo_device_get_name(d));
  ret=neo_location_create_from_string(loc, tmp);
  if (ret) {
    printf("Internal error generating neo_location from answer\n");
    neo_error=NEO_ERR_INTERNAL;
    return(-1);
  }
  neo_locationlist_append_element(ans, loc);
  return(0);
}
