#include <stdio.h>
#include <stdlib.h>
#include "neo.h"

int neo_command_port_sed_generic(neo_location *loc, int command) {
  int port;
  char obj[1024], val[30];
  int a, ret;
  char *device;

  printf("WARNING: Unknown device, trying standard bridge MIB\n");

  device=neo_device_get_name(neo_location_get_first_device(loc));
  port=neo_location_get_portnum(loc);
  sprintf(obj, ".1.3.6.1.2.1.2.2.1.7.%i", port);

  if (command == NEO_COMMAND_PORT_STATUS) {
    ret=neo_snmp_request_by_variable(device, obj, val);
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
        printf("Could not contact device %s\n", device);
      } else {
        printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    a=atoi(val);
    if (a==1) return(NEO_COMMAND_PORT_IS_ENABLED);
    if (a==2) return(NEO_COMMAND_PORT_IS_DISABLED);
    return(NEO_COMMAND_PORT_IS_UNKNOWN);
  } else if (command == NEO_COMMAND_PORT_ENABLE) {
    ret=neo_snmp_set_by_variable(device, obj, "int", "1");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
        printf("Could not contact device %s\n", device);
      } else {
        printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_ENABLED);
  } else if (command == NEO_COMMAND_PORT_DISABLE) {
    ret=neo_snmp_set_by_variable(device, obj, "int", "2");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
        printf("Could not contact device %s\n", device);
      } else {
        printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_DISABLED);
  }
  return(0);
}

int neo_command_locate_generic(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink) {
  /* see docs for contract */
  neo_location *loc;
  int ret;
  char tmp[300];

  printf("WARNING: Unknown device, trying standard bridge MIB\n");

  ret=neo_command_locate_standardbridge_helper(d, s);
  if (ret==-1) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s\n", neo_device_get_name(d));
      return(-1);
    } else {
      return(0);
    }
  }

  /* we would ordinarly check for the uplink here, but we have no way of knowing
     which port is the uplink at the moment */
  /*
  if (!uplink && ret>24) {
    return(0);
  }
  */
  
  loc=malloc(sizeof(neo_location));
  sprintf(tmp, "%i@%s", ret, neo_device_get_name(d));
  ret=neo_location_create_from_string(loc, tmp);
  if (ret) {
    printf("Internal error generating neo_location from answer\n");
    neo_error=NEO_ERR_INTERNAL;
    return(-1);
  }
  neo_locationlist_append_element(ans, loc);
  return(0);
}

int neo_command_device_summary_generic(neo_device *d, neo_location *loc, neo_list *pl) {
  /* put everything into a port list */
  neo_port *p;
  char buff[30], obj[1024];
  int i, x, j, ret, numports, ports[1000];
  neo_snmpresponselist *rl;

  printf("WARNING: Unknown device, trying standard bridge MIB\n");

  if (neo_location_has_port(loc) && !neo_location_star_port(loc)) {
    numports=1;
    ports[0]=neo_location_get_portnum(loc);
  } else {
    /* walk over the index to get all the port numbers */
    rl=neo_snmp_many_requests_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.2.2.1.1");
    if (rl==NULL) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", neo_device_get_name(d));
	neo_snmpresponselist_free_all(rl);
	return(-1);
      } else {
	return(0);
      }
    }

    /* stash all the port numbers in an array */
    j=neo_snmpresponselist_get_size(rl);
    numports=j;
    for (i=0; i<j; i++) {
      ports[i]=atoi(neo_snmpresponselist_get_val(rl, i));
    }

    /* free */
    neo_snmpresponselist_free_all(rl);
  }

  for (x=0; x<numports; x++) {
    i=ports[x];
    p=malloc(sizeof(neo_port));
    neo_port_create(p);
    neo_portlist_append_element(pl, p);

    /* number */
    neo_port_set_number(p, i);

    /* set the description here */
    sprintf(obj, ".1.3.6.1.2.1.2.2.1.2.%i", i);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
    if (ret) {
      continue;
    } else {
      neo_port_set_descr(p, buff);
    }

    /*
    if (i<25) {
      neo_port_set_descr(p, "10T");
      neo_port_set_uplink(p, 0);
    } else if (i==25 || i==26 || i==27) {
      neo_port_set_descr(p, "100TX");
      neo_port_set_uplink(p, 1);
    } else if (i==28) {
      neo_port_set_descr(p,"loop");
      neo_port_set_uplink(p, 0);
    }
    */

    /* link */
    /* interfaces.ifTable.ifEntry.ifOperStatus.%i */
    sprintf(obj, ".1.3.6.1.2.1.2.2.1.8.%i", i);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
    if (ret) {
      continue;
    } else {
      if (atoi(buff)==1) {
	neo_port_set_link_up(p);
      } else if (atoi(buff)==2) {
	neo_port_set_link_down(p);
      } else {
	neo_port_set_link_unknown(p);
      }
    }

    /* speed */
    /* interfaces.ifTable.ifEntry.ifSpeed.%i */
    sprintf(obj, ".1.3.6.1.2.1.2.2.1.5.%i", i);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
    if (ret) {
      continue;
    } else {
      neo_port_set_speed(p, atoi(buff));
    }

    /* admin status */
    sprintf(obj, ".1.3.6.1.2.1.2.2.1.7.%i", i);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
    if (ret) {
      continue;
    } else {
      if (atoi(buff)==1) {
	neo_port_set_admin(p, 1);
      } else if (atoi(buff)==2) {
	neo_port_set_admin(p, 0);
      } else {
	neo_port_set_admin(p, -1);
      }
    }

  }
  return(NEO_TYPE_PORTLIST);
}

int neo_command_stats_generic(neo_location *loc, neo_portlist *pl) {
  neo_statstransfer *st, *a, *b;
  neo_device *d;
  neo_list *stlist1, *stlist2, *stlistcur;
  neo_port *p;
  neo_stats *s;
  neo_sleeper sleeper;
  int i, j, portnum, ret, done;

  d=neo_location_get_first_device(loc);
  ret=neo_command_device_summary_generic(d, loc, pl);
  j=neo_portlist_get_size(pl);
  stlist1=malloc(sizeof(neo_list));
  stlist2=malloc(sizeof(neo_list));
  neo_list_create(stlist1);
  neo_list_create(stlist2);

  neo_sleeper_create(&sleeper, neo_global_get_statsdelay(g));
  /* do it twice first with stlistcur=stlist1 then stlistcur=stlist2 */
  done=0;
  for (stlistcur=stlist1,done=0; done<2; stlistcur=stlist2, done++) {
    if (done==0) {
      printf("Getting first set of stats...\n");
    } else {
      printf("Getting second set of stats...\n");
    }
    for (i=0; i<j; i++) {
      p=neo_portlist_get_element(pl, i);
      portnum=neo_port_get_number(p);

      st=malloc(sizeof(neo_statstransfer));
      neo_list_append_element(stlistcur, st);

      neo_statstransfer_init(st);

      neo_command_stats_standardbridge_helper(d, st, portnum);
    }

    /* do the necessary delay here */
    if (done==0) {
      neo_sleeper_dowait(&sleeper);
    }
  }

  s=malloc(sizeof(neo_stats));
  /* now for each port do the stats transfer calculation */
  for (i=0; i<j; i++) {
    p=neo_portlist_get_element(pl, i);
    a=neo_list_get_element(stlist1, i);
    b=neo_list_get_element(stlist2, i);

    /* calculate and set for port */
    neo_statstransfer_compute_stats(a, b, s);
    neo_port_set_stats(p, s);
  }

  /* free the statstransfer lists */
  return(NEO_TYPE_PORTLIST);


}

int neo_command_port_search_generic(neo_location *loc) {
  neo_device *d;
  int ret;

  printf("WARNING: Unknown device, trying standard bridge MIB\n");

  if (!neo_location_has_port(loc)) {
    printf("You must specify a port to search.\n");
    return(-1);
  }

  d=neo_location_get_first_device(loc);

  ret=neo_command_port_search_standardbridge_helper(d, neo_location_get_portnum(loc));

  return(0);
}

#if 0

int neo_function_getuplink_generic(neo_location *loc) {
  char *router, *this;
  char val[100];
  
  /* get the next hop ip with .1.3.6.1.2.1.4.21.1.7.0.0.0.0 */
  this=neo_device_get_name(neo_location_get_first_device(loc));
  ret=neo_snmp_request_by_variable(this, ".1.3.6.1.2.1.4.21.1.7.0.0.0.0", val);
  if (ret) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s\n", device);
    } else {
      printf("Error getting port status for %s\n", neo_location_get_instr(loc));
    }
    return(-1);
  }

  router=strdup(val);
  ret=neo_snmp_request_by_variable(this, ".1.3.6.1.2.1.4.21.1.7.0.0.0.0", val);
  if (ret) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s\n", device);
    } else {
      printf("Error getting port status for %s\n", neo_location_get_instr(loc));
    }
    free(router);
    return(-1);
  }


  free(router);
}

#endif

void neo_command_device_info_generic(neo_device *d, int type) {
  
  if (type==NEO_COMMAND_DEVICE_INFO_UPS || type==NEO_COMMAND_DEVICE_INFO_POWER) {
    neo_command_device_info_ups_generic(d);
  }
}

void neo_command_device_info_ups_generic(neo_device *d) {
  int ret, inputlines, outputlines, i, j;
  float f;
  char val[1024], obj[1024], timebuff[1024];

  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.1.1.0", val);
  if (ret) {
    printf("Error getting info.\n");
  } else {
    printf("  Type             : %s\n", val);
  }

  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.1.5.0", val);
  if (ret) {
    printf("Error getting info.\n");
  } else {
    printf("  Name             : %s\n", val);
  }

  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.6.1.0", val);
  if (ret) {
    printf("Error getting info.\n");
  } else {
    printf("  # Alarms Present : %i\n", atoi(val));
  }
  
  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.4.1.0", val);
  if (ret) {
    printf("Error getting info.\n");
  } else {
    i=atoi(val);
    printf("  Status           : ");
    if (i==1) {
      printf("Other\n");
    } else if (i==2) {
      printf("None\n");
    } else if (i==3) {
      printf("Normal\n");
    } else if (i==4) {
      printf("Bypass\n");
    } else if (i==5) {
      printf("Battery\n");
    } else if (i==6) {
      printf("Booster\n");
    } else if (i==7) {
      printf("Reducer\n");
    } else {
      printf("Unknown value (%i)\n",i);
    }
  }
  
  printf("\n");
  
  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.2.4.0", val);
  if (ret) {
    printf("Error getting info.\n");
  } else {
    i=atoi(val);
    printf("  Battery Capacity : %i%%\n", i);
  }
  
  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.2.3.0", val);
  if (ret) {
    printf("Error getting info.\n");
  } else {
    neo_timeformat(timebuff, atoi(val)*60);
    printf("  Battery Run Time : %s\n", timebuff);
  }
  
  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.2.2.0", val);
  if (ret) {
    printf("Error getting info.\n");
  } else {
    val[strlen(val)-2]='\0'; /* chop off last two digits */
    neo_timeformat(timebuff, atoi(val));
    printf("  Time On Battery  : %s\n", timebuff);
  }
  
  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.2.5.0", val);
  if (ret) {
    printf("Error getting info.\n");
  } else {
    f=atol(val)/10;
    printf("  Battery Voltage  : %-.1f V\n", f);
  }
  
  
  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.2.6.0", val);
  if (ret) {
    printf("Error getting info.\n");
  } else {
    f=atol(val)/10;
    printf("  Battery Current  : %-.1f V\n", f);
  }

  printf("\n");

  inputlines=0;
  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.3.2.0", val);
  if (ret) {
    printf("Error getting number of input lines.\n");
  } else {
    inputlines=atoi(val);
  }
  
  for (j=0; j<inputlines; j++) {
    sprintf(obj, ".1.3.6.1.2.1.33.1.3.3.1.3.%i", j+1);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("  Input %i Voltage  : %i.0 V\n", j+1, atoi(val));
    }
    
    sprintf(obj, ".1.3.6.1.2.1.33.1.3.3.1.4.%i", j+1);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("  Input %i Current  : %-.1f A\n", j+1, atof(val)/10);
    }
    
    
    sprintf(obj, ".1.3.6.1.2.1.33.1.3.3.1.2.%i", j+1);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("  Input %i Freq.    : %-.1f Hz\n", j+1, atof(val)/10);
    }
    
  }
  
  printf("\n");
  
  
  outputlines=0;
  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.4.3.0", val);
  if (ret) {
    printf("Error getting number of output lines.\n");
  } else {
    outputlines=atoi(val);
  }
  
  for (j=0; j<outputlines; j++) {
    sprintf(obj, ".1.3.6.1.2.1.33.1.4.4.1.2.%i", j+1);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("  Output %i Voltage : %i V\n", j+1, atoi(val));
    }
    
    sprintf(obj, ".1.3.6.1.2.1.33.1.4.4.1.3.%i", j+1);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("  Output %i Current : %-.1f A\n", j+1, atof(val)/10);
    }

    /* yes, this is the same every time */
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.33.1.4.2.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("  Output %i Freq.   : %-.1f Hz\n", j+1, atof(val)/10);
    }

    
    sprintf(obj, ".1.3.6.1.2.1.33.1.4.4.1.5.%i", j+1);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("  Output %i Load    : %i%%\n", j+1, atoi(val));
    }
    
  }
  
}
