#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "neo.h"

void neo_command_device_info_hpprinter(neo_device *d, int type) {
  int ret, i;
  char val[1024], obj[1024];

  if (type==NEO_COMMAND_DEVICE_INFO_PRINTER) {

    printf("  Model            : ");    
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.3.9.1.1.7.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      char *ptr, *ptr2, buff[1024];
      ptr=strstr(val, "MDL:");
      if (ptr) {
	ptr2=strchr(ptr, ';');
	if (ptr2) {
	  strncpy(buff, ptr+4, ptr2-ptr-4);
	  buff[ptr2-ptr-4]='\0';
	  printf("%s\n", buff);
	} else {
	  printf("Error getting model\n");
	}
      } else {
	printf("Error getting model\n");
      }
      printf("\n");
    }

    printf("  Op Status        : ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.25.3.2.1.5.1", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      if (i==1) {
	printf("Unknown");
      } else if (i==2) {
	printf("Running");
      } else if (i==3) {
	printf("Warning");
      } else if (i==4) {
	printf("Testing");
      } else if (i==5) {
	printf("Down");
      } else {
	printf("Unknown (%i)", i);
      }
      printf("\n");
    }

    /* need to tab out newlines on this one */
    printf("  Front Panel      : ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.3.9.1.1.3.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("%s\n", val);
    }

    printf("  Current Job      : ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.3.9.1.1.4.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("%s\n", val);
    }

    printf("\n");

    printf("  Toner Status     : ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.3.9.1.1.2.10.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      if (i==0) {
	printf("Normal");
      } else if (i==1) {
	printf("Low");
      } else if (i==2) {
	printf("No cartridge");
      } else {
	printf("Unknown (%i)", i);
      }
      printf("\n");
    }

    printf("  Jam Status       : ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.3.9.1.1.2.9.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      if (i==0) {
	printf("Normal");
      } else if (i==1) {
	printf("Paper Jam Detected");
      } else {
	printf("Unknown (%i)", i);
      }
      printf("\n");
    }

    printf("  Paper Status     : ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.3.9.1.1.2.8.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      if (i==0) {
	printf("Normal");
      } else if (i==1) {
	printf("Paper Out");
      } else if (i==2) {
	printf("Manul Feed Required");
      } else {
	printf("Unknown (%i)", i);
      }
      printf("\n");
    }

    printf("  Total Printed Pgs: ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.43.10.2.1.4.1.1", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("%s\n", val);
    }

    printf("\n");

    printf("  Idle Timeout     : ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.4.3.5.10.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("%s seconds\n", val);
    }

    printf("  Syslog Server    : ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.4.3.5.5.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("%s\n", val);
    }

    printf("  Syslog Facility  : ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.4.3.5.6.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      if (i==16<<3) {
	printf("Local0");
      } else if (i==17<<3) {
	printf("Local1");
      } else if (i==18<<3) {
	printf("Local2");
      } else if (i==19<<3) {
	printf("Local3");
      } else if (i==20<<3) {
	printf("Local4");
      } else if (i==21<<3) {
	printf("Local5");
      } else if (i==22<<3) {
	printf("Local6");
      } else if (i==23<<3) {
	printf("Local7");
      } else {
	printf("Unknown (%i)", i);
      }
      printf("\n");
    }

    printf("  Config Source    : ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.4.3.5.1.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      if (i==1) {
	printf("Front Panel");
      } else {
	printf("BOOTP");
      }
      printf("\n");
    }


    printf("  BOOTP Server     : ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.4.3.5.3.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      printf("%s\n", val);
    }

    printf("\n");
    printf("  Access List:\n");
    for (i=1;;i++) {
      sprintf(obj, ".1.3.6.1.4.1.11.2.4.3.5.9.1.2.%i", i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
      if (ret) {
	break;
      } else {
	printf("     %-15.15s ", val);
      }

      sprintf(obj, ".1.3.6.1.4.1.11.2.4.3.5.9.1.3.%i", i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, val);
      if (ret) {
	printf("Error getting mask.\n");
	break;
      } else {
	printf("%-15.15s\n", val);
      }
    }

    printf("\n");
    printf("  Current connection: ");
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.4.3.4.11.0", val);
    if (ret) {
      printf("Error getting current connection info\n");
    } else {
      printf("%s\n", val);
    }

  } else {
    printf("That subcommand is not functional on this device\n");
    return;
  }
}


int neo_command_device_reset_hpprinter(neo_device *d) {
  int ret;

  ret=neo_snmp_set_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.11.2.4.3.7.8.0", "int", "1");
  if (ret) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("Could not contact device %s.\n", neo_device_get_name(d));
    } else {
      printf("Error contacting device %s for reset.\n", neo_device_get_name(d));
    }
    return(-1);
  }
  return(0);
}
