#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include "neo.h"


int neo_command_port_sed_router(neo_location *loc, int command) {
  int port;
  char obj[1024], val[30];
  int a, ret, high;
  char *device;

  device=neo_device_get_name(neo_location_get_first_device(loc));

  ret=neo_snmp_request_by_variable(device, ".1.3.6.1.2.1.2.1.0", val);
  if (ret) {
    printf("Could not get number of interfaces from %s\n", device);
    neo_error_print(neo_error);
    return(-1);
  }
  high=atoi(val);

  port=neo_location_get_portnum(loc);
  if (port<1 || port>high) {
    printf("Invalid port\n");
    return(NEO_COMMAND_PORT_IS_SILENTERR);
  }


  sprintf(obj, ".1.3.6.1.2.1.2.2.1.7.%i", port);

  if (command == NEO_COMMAND_PORT_STATUS) {
    ret=neo_snmp_request_by_variable(device, obj, val);
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", device);
      } else {
	printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    a=atoi(val);
    if (a==1) return(NEO_COMMAND_PORT_IS_ENABLED);
    if (a==2) return(NEO_COMMAND_PORT_IS_DISABLED);
    return(NEO_COMMAND_PORT_IS_UNKNOWN);
  } else if (command == NEO_COMMAND_PORT_ENABLE) {
    ret=neo_snmp_set_by_variable(device, obj, "int", "1");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", device);
      } else {
	printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_ENABLED);
  } else if (command == NEO_COMMAND_PORT_DISABLE) {
    ret=neo_snmp_set_by_variable(device, obj, "int", "2");
    if (ret) {
      if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
	printf("Could not contact device %s\n", device);
      } else {
	printf("Error getting port status for %s\n", neo_location_get_instr(loc));
      }
      return(NEO_COMMAND_PORT_IS_UNKNOWN);
    }
    return(NEO_COMMAND_PORT_IS_DISABLED);
  }
  return(0);
}

int neo_command_device_summary_router(neo_device *d, neo_location *loc, neo_list *pl) {
  /* put everything into a port list */
  neo_port *p;
  char buff[30], obj[1024];
  int i, ret, low, high;

  /* get the number of interfaces */
  ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.2.1.2.1.0", buff);
  if (ret) {
    printf("Could not get number of interfaces from %s\n", neo_device_get_name(d));
    neo_error_print(neo_error);
    return(-1);
  }

  high=atoi(buff);

  /* override if specified */
  if (neo_location_has_port(loc) && !neo_location_star_port(loc)) {
    low=high=neo_location_get_portnum(loc);
  } else {
    low=1;
  }

  for (i=low; i<=high; i++) {
    p=malloc(sizeof(neo_port));
    neo_port_create(p);
    neo_portlist_append_element(pl, p);

    /* number */
    neo_port_set_number(p, i);

    sprintf(obj, ".1.3.6.1.2.1.2.2.1.2.%i", i);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
    if (!strncmp(buff, "Ethernet", 8)) {
      buff[7]='e';
      neo_port_set_descr(p, buff+7);
    } else if (!strncmp(buff, "FastEthernet", 12)) {
      buff[10]='f';
      buff[11]='e';
      neo_port_set_descr(p, buff+10);
    } else if (!strncmp(buff, "GigabitEthernet", 15)) {
      buff[13]='g';
      buff[14]='e';
      neo_port_set_descr(p, buff+13);
    } else if (!strncmp(buff, "Serial", 6)) {
      buff[5]='s';
      neo_port_set_descr(p, buff+5);
    } else {
      neo_port_set_descr(p, buff);
    }

    /* link */
    /* interfaces.ifTable.ifEntry.ifOperStatus.%i */
    sprintf(obj, ".1.3.6.1.2.1.2.2.1.8.%i", i);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
    if (ret) {
      continue;
    } else {
      if (atoi(buff)==1) {
	neo_port_set_link_up(p);
      } else if (atoi(buff)==2) {
	neo_port_set_link_down(p);
      } else {
	neo_port_set_link_unknown(p);
      }
    }

    /* speed */
    /* interfaces.ifTable.ifEntry.ifSpeed.%i */
    if (!strncasecmp(neo_port_get_descr(p), "Loopback", 8)) {
      neo_port_set_speed(p, 0);
    } else {
      sprintf(obj, ".1.3.6.1.2.1.2.2.1.5.%i", i);
      ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
      if (ret) {
	continue;
      } else {
	neo_port_set_speed(p, atoi(buff));
      }
    }

    /* admin status */
    sprintf(obj, ".1.3.6.1.2.1.2.2.1.7.%i", i);
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), obj, buff);
    if (ret) {
      continue;
    } else {
      if (atoi(buff)==1) {
	neo_port_set_admin(p, 1);
      } else if (atoi(buff)==2) {
	neo_port_set_admin(p, 0);
      } else {
	neo_port_set_admin(p, -1);
      }
    }

  }
  return(NEO_TYPE_PORTLIST);
}


int neo_command_stats_router(neo_location *loc, neo_portlist *pl) {
  neo_statstransfer *st, *a, *b;
  neo_device *d;
  neo_list *stlist1, *stlist2, *stlistcur;
  neo_port *p;
  neo_stats *s;
  neo_sleeper sleeper;
  int i, j, portnum, ret, done;

  d=neo_location_get_first_device(loc);

  printf("Getting device summary ...\n");
  ret=neo_command_device_summary_router(d, loc, pl);
  j=neo_portlist_get_size(pl);
  stlist1=malloc(sizeof(neo_list));
  stlist2=malloc(sizeof(neo_list));
  neo_list_create(stlist1);
  neo_list_create(stlist2);

  neo_sleeper_create(&sleeper, neo_global_get_statsdelay(g));
  /* do it twice first with stlistcur=stlist1 then stlistcur=stlist2 */
  done=0;
  for (stlistcur=stlist1,done=0; done<2; stlistcur=stlist2, done++) {
    if (done==0) {
      printf("Getting first set of stats...\n");
    } else {
      printf("Getting second set of stats...\n");
    }
    for (i=0; i<j; i++) {
      p=neo_portlist_get_element(pl, i);
      portnum=neo_port_get_number(p);

      st=malloc(sizeof(neo_statstransfer));
      neo_list_append_element(stlistcur, st);

      neo_statstransfer_init(st);

      neo_command_stats_standardbridge_helper(d, st, portnum);
    }

    /* do the necessary delay here */
    if (done==0) {
      neo_sleeper_dowait(&sleeper);
    }
  }

  s=malloc(sizeof(neo_stats));
  /* now for each port do the stats transfer calculation */
  for (i=0; i<j; i++) {
    p=neo_portlist_get_element(pl, i);
    a=neo_list_get_element(stlist1, i);
    b=neo_list_get_element(stlist2, i);

    /* calculate and set for port */
    neo_statstransfer_compute_stats(a, b, s);
    neo_port_set_stats(p, s);
  }

  /* free the statstransfer lists */
  return(NEO_TYPE_PORTLIST);
}


int neo_command_locate_router(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink) {
  printf("Locate commands can not be run on a router.\n");
  return(0);
}

int neo_command_port_search_router(neo_location *loc) {
  printf("Port searches can not be run on a router.\n");
  return(0);
}


void neo_command_device_info_router_old(neo_device *d, int type) {
  int ret, i;
  char val[1024];

  if (type==NEO_COMMAND_DEVICE_INFO_POWER) {
    printf("Power info not yet supported on this device\n");
  } else if (type==NEO_COMMAND_DEVICE_INFO_WEATHER) {
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.9.13.1.3.1.3.1", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("Intake temp: %iC / %iF\n", i, (i*9/5)+32);
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.9.13.1.3.1.3.2", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("Hotpoint   : %iC / %iF\n", i, (i*9/5)+32);
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.9.13.1.3.1.3.3", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("Exhaust    : %iC / %iF\n", i, (i*9/5)+32);
    }
  } else if (type==NEO_COMMAND_DEVICE_INFO_CPU) {
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.2.1.56.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("5 Sec CPU: %i%%\n", i);
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.2.1.57.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("1 Min CPU: %i%%\n", i);
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.2.1.58.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("5 Min CPU: %i%%\n", i);
    }
  } else {
    printf("Internal Error\n");
  }
 
}


void neo_command_device_info_router_new(neo_device *d, int type) {
  int ret, i;
  char val[1024];

  if (type==NEO_COMMAND_DEVICE_INFO_POWER) {
    printf("Power info is not yet supported on this device\n");
  } else if (type==NEO_COMMAND_DEVICE_INFO_WEATHER) {
    printf("Weather info is not yet supported on this device\n");
  } else if (type==NEO_COMMAND_DEVICE_INFO_CPU) {
    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.2.1.56.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("5 Sec CPU: %i%%\n", i);
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.2.1.57.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("1 Min CPU: %i%%\n", i);
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.2.1.58.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("5 Min CPU: %i%%\n", i);
    }

    ret=neo_snmp_request_by_variable(neo_device_get_name(d), ".1.3.6.1.4.1.9.5.1.1.8.0", val);
    if (ret) {
      printf("Error getting info.\n");
    } else {
      i=atoi(val);
      printf("\nBandwidth Utilization: %i%%\n", i);
    }

    
  } else {
    printf("Internal Error\n");
  }
}
