#include "neo.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

neo_devicelist *neo_devicelist_create_from_string(char *in, neo_global *g) {
  char *ptr;
  neo_devicelist *out;
  neo_device *d;
  int ret;

  ptr=in;
  if (ptr[0]=='@') ptr++;
  
  if (!strncasecmp(ptr, "k:", 2) || !strncasecmp(ptr, "key:", 4)) {
    char *cptr;
    cptr=strchr(ptr, ':')+1;

    out=devicelist_create_from_key(g, cptr);
    return(out);
  } else if (!strncasecmp(ptr, "f:", 2) || !strncasecmp(ptr, "file:", 5)) {
    
  } else {
    /* it's hosts */
    char *cptr;
    char host[1024];

    cptr=strchr(ptr, ',');
    out=malloc(sizeof(neo_devicelist));
    neo_devicelist_create(out);
    while (1) {
      memset(host, 0, 1024);
      if (cptr) {
	strncpy(host, ptr, cptr-ptr);
      } else {
	strcpy(host, ptr);
      }
      d=malloc(sizeof(neo_device));
      ret=neo_device_create_by_name(d, host);
      neo_devicelist_append_element(out, d);
      if (cptr==NULL) break;
      ptr=cptr+1;
      cptr=strchr(ptr, ',');
    }
    return(out);
  }
  return(NULL);
}

void neo_devicelist_set_deviceconsts(neo_devicelist *dl, neo_global *g) {
  int i, j;

  j=neo_devicelist_get_size(dl);
  for (i=0; i<j; i++) {
    neo_device_set_const_from_probe(neo_devicelist_get_element(dl, i), g);
  }
}

void neo_devicelist_debugprint(neo_list *list) {
  int i, j;
  neo_device *d;

  j=neo_list_get_size(list);
  for (i=0; i<j; i++) {
    d=neo_list_get_element(list, i);
    printf("%s\n", neo_device_get_name(d));
  }
}


neo_devicelist *devicelist_create_from_key(neo_global *g, char *key) {
  FILE *file;
  char *foo, buff[1024];
  neo_devicelist *out;
  neo_device *d;

  out=malloc(sizeof(neo_devicelist));
  neo_devicelist_create(out);

  file=fopen(neo_global_get_keyfile(g), "r");
  if (!file) {
    perror("opening keyfile");
    return(out);
  }

  
  while (fgets(buff, 1024, file)!=NULL) {
    if (buff[0]=='#') continue;
    foo=strtok(buff,"|\n\r");

    /* it's not ours */
    if (!foo || strcasecmp(foo, key)) continue;

    /* screwed up line */
    foo=strtok(NULL, "\n\r");
    if (!foo) {
      fprintf(stderr, "Warning: missing value for key %s in keyfile.\n", key);
      continue;
    }

    /* it's us, fill it in */
    d=malloc(sizeof(neo_device));
    neo_device_create_by_name(d, foo);
    neo_devicelist_append_element(out, d);
  }
  
  fclose(file);
  return(out);
}
