#include <stdio.h>
#include <netdb.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include "neo.h"

int neo_function_arpfind(neo_macaddr *outmac, char *hostname, char *router) {
  neo_searchable s;
  int ret;
  char buff[1024], val[500];
  char *ipaddr;
  int k, numints;

  /* translate the ip */
  neo_searchable_create_from_string(&s, hostname);
  
  if (neo_searchable_primary_is_macaddr(&s)) {
    printf("arpfind: You must supply an IP address or hostname\n");
    return(-1);
  }
  
  /* we want the ip addr if we have the host */
  if (neo_searchable_primary_is_hostname(&s)) {
    ret=neo_searchable_expand_hostip(&s);
    if (ret) {
      printf("arpfind: Could not find ip address for host %s\n", hostname);
      return(-1);
    }
  }
  
  ipaddr=neo_searchable_get_ipaddr(&s);
  
  /* interfaces.ifNumber.0 */
  ret=neo_snmp_request_by_variable(router, ".1.3.6.1.2.1.2.1.0", val);
  if (ret) {
    printf("arpfind: Could not get number of interfaces from %s\n", router);
    /* neo_error_print(neo_error); */
    return(-1);
  }
  
  numints=atoi(val);
  
  for(k=1; k<=numints; k++) {
    sprintf(buff,".1.3.6.1.2.1.3.1.1.2.%i.1.%s", k, ipaddr);
    ret=neo_snmp_request_by_variable(router, buff, val);
    if (ret && (neo_error!=NEO_ERR_SNMP_NOVAR)) {
      printf("arpfind: Error while talking to %s\n", router);
      return(-1);
    } else if (ret && (neo_error==NEO_ERR_SNMP_NOVAR)) {
      /* just go to the next one */
    } else {
      ret=neo_macaddr_create_from_string(outmac, val);
      if (ret) {
	printf("arpfind: Error parsing response into mac address (%s)\n", val);
	return(-1);
      } else {
	return(0);
      }
    }
  }
  printf("arpfind: %s can not find entry for %s\n", router, ipaddr);
  return(-1);
}


int neo_function_get_uplink(neo_locationlist *ans, char *devicename) {
  int ret;
  neo_searchable s;
  char val[100], buff[1024];
  neo_macaddr m;
  neo_device d;

  /* get the next hop ip with .1.3.6.1.2.1.4.21.1.7.0.0.0.0 */
  ret=neo_snmp_request_by_variable(devicename, ".1.3.6.1.2.1.4.21.1.7.0.0.0.0", val);
  if (ret) {
    if (neo_error==NEO_ERR_TIMEOUT || neo_error==NEO_ERR_CONTACT) {
      printf("function_get_uplink: Could not contact device %s\n", devicename);
    }
    return(-1);
  }

  /* on the router, look up the mac address of it's own ip address */
  ret=neo_function_arpfind(&m, val, val);
  if (ret) {
    printf("function_get_uplink: failed arpfind\n");
    return(-1);
  }
  neo_macaddr_to_string(&m, buff);

  /* now locate that address on this device */
  neo_searchable_create_from_string(&s, buff);
  neo_device_create_and_set_const(&d, g, devicename);
  ret=neo_device_command_locate(&d, &s, ans, 1);

  return(0);
}
