#include "neo.h"
#include <strings.h>
#include <string.h>

void neo_global_create(neo_global *g) {
  neo_global_set_argv0(g, "");
  neo_global_set_burst(g, 1);
  neo_global_set_readcom(g, "public");
  neo_global_set_writecom(g, "public");
  neo_global_set_keyfile(g, "/afs/.net/tools/lib/port/agent_lists.kretch");
  neo_global_set_version(g, NEO_VERSION_STRING);
  neo_global_set_statsdelay(g, 5);
  neo_global_set_areyousure_ask(g);
  neo_global_set_timeout(g, 8);
  g->macmode=NEO_GLOBAL_MACMODE_STANDARD;
}

void neo_global_set_macmode(neo_global *g, int mode) {
  g->macmode=mode;
}

int neo_global_set_macmode_from_string(neo_global *g, char *in) {
  if (!strcmp(in, "standard")) {
    g->macmode=NEO_GLOBAL_MACMODE_STANDARD;
  } else if (!strcmp(in, "cisco")) {
    g->macmode=NEO_GLOBAL_MACMODE_CISCO;
  } else if (!strcmp(in, "dash")) {
    g->macmode=NEO_GLOBAL_MACMODE_DASH;
  } else {
    return(-1);
  }
  return(0);
}

int neo_global_get_macmode(neo_global *g) {
  return(g->macmode);
}

char *neo_global_get_macmode_string(neo_global *g) {
  if (g->macmode==NEO_GLOBAL_MACMODE_STANDARD) {
    return("standard");
  } else if (g->macmode==NEO_GLOBAL_MACMODE_CISCO) {
    return("cisco");
  } else if (g->macmode==NEO_GLOBAL_MACMODE_DASH) {
    return("dash");
  }
  return("invalid");
}

void neo_global_set_argv0(neo_global *g, char *in) {
  strcpy(g->argv0, in);
}

char *neo_global_get_argv0(neo_global *g) {
  return(g->argv0);
}

void neo_global_set_burst(neo_global *g, int burst) {
  g->burst=burst;
}

int neo_global_get_burst(neo_global *g) {
  return(g->burst);
}

void neo_global_set_readcom(neo_global *g, char *in) {
  strcpy(g->readcom, in);
}

char *neo_global_get_readcom(neo_global *g) {
  return(g->readcom);
}

void neo_global_set_writecom(neo_global *g, char *in) {
  strcpy(g->writecom, in);
}

char *neo_global_get_writecom(neo_global *g) {
  return(g->writecom);
}

void neo_global_set_keyfile(neo_global *g, char *in) {
  strcpy(g->keyfile, in);
}

char *neo_global_get_keyfile(neo_global *g) {
  return(g->keyfile);
}

void neo_global_set_version(neo_global *g, char *in) {
  strcpy(g->version, in);
}

char *neo_global_get_version(neo_global *g) {
  return(g->version);
}

void neo_global_set_statsdelay(neo_global *g, int d) {
  g->statsdelay=d;
}

int neo_global_get_statsdelay(neo_global *g) {
  return(g->statsdelay);
}

void neo_global_set_areyousure_ask(neo_global *g) {
  g->areyousure=0;
}

void neo_global_set_areyousure_yes(neo_global *g) {
  g->areyousure=1;
}

void neo_global_set_areyousure_no(neo_global *g) {
  g->areyousure=-1;
}

int neo_global_is_areyousure_ask(neo_global *g) {
  if (g->areyousure==0) return(1);
  return(0);
}

int neo_global_is_areyousure_yes(neo_global *g) {
  if (g->areyousure==1) return(1);
  return(0);
}

int neo_global_is_areyousure_no(neo_global *g) {
  if (g->areyousure==-1) return(1);
  return(0);
}
 
int neo_global_get_timeout(neo_global *g) {
  return(g->snmptimeout);
}

void neo_global_set_timeout(neo_global *g, int i) {
  g->snmptimeout=i;
}
