#include "neo.h"
#include <stdlib.h>

#define INITSIZE 30
#define GROWAT 2
#define GROWBY 1.5

#define MAGIC 155987

int neo_list_create(neo_list *l) {
  l->size=0;
  l->list=(void **)malloc(INITSIZE*sizeof(void *));
  l->avail=INITSIZE;
  if (l->list==NULL) return(-1);
  return(0);
}

int neo_list_get_size(neo_list *l) {
  return(l->size);
}

void *neo_list_get_element(neo_list *l, int n) {
  if (n>l->size-1) return(NULL);
  return(l->list[n]);
}

int neo_list_append_element(neo_list *l, void *element) {
  if ((l->size+1) > (l->avail/GROWAT)) {
    l->list=realloc(l->list, l->avail*GROWBY*sizeof(void *));
    l->avail=l->avail*GROWBY;
    if (l->list==NULL) return(-1);
  }

  l->list[l->size]=element;
  l->size++;
  return(0);
}

void neo_list_free_all(neo_list *l, void (*elefree)(void *)) {
  int i;

  for (i=0; i<l->size; i++) {
    (elefree)(l->list[i]);
  }
  free(l->list);
}

void neo_list_free_simple(neo_list *l) {
  if (l->list) free(l->list);
}
   
