#include "neo.h"
#include <stdlib.h>

/* the point here is mostly to provide strong typing for lists used in neo */

/* devicelist */
int neo_devicelist_create(neo_devicelist *list) {
  return(neo_list_create(list));
}

int neo_devicelist_append_element(neo_devicelist *list, neo_device *device) {
  return(neo_list_append_element(list, device));
}

neo_device *neo_devicelist_get_element(neo_devicelist *list, int index) {
  return(neo_list_get_element(list, index));
}

int neo_devicelist_get_size(neo_devicelist *list) {
  return(neo_list_get_size(list));
}

void neo_devicelist_free_all(neo_devicelist *list) {
  void (*func)();

  func=&neo_device_free_complete;
  neo_list_free_all(list, func);
}

/* locationlist */
int neo_locationlist_create(neo_locationlist *list) {
  return(neo_list_create(list));
}

int neo_locationlist_append_element(neo_locationlist *list, neo_location *loc) {
  return(neo_list_append_element(list, loc));
}

neo_location *neo_locationlist_get_element(neo_locationlist *list, int index) {
  return(neo_list_get_element(list, index));
}

int neo_locationlist_get_size(neo_locationlist *list) {
  return(neo_list_get_size(list));
}

void neo_locationlist_free_all(neo_locationlist *list) {
  void (*func)();

  func=&neo_location_free_complete;
  neo_list_free_all(list, func);
}

/* boardlist */
int neo_boardlist_create(neo_boardlist *list) {
  return(neo_list_create(list));
}

int neo_boardlist_append_element(neo_boardlist *list, neo_board *board) {
  return(neo_list_append_element(list, board));
}

neo_board *neo_boardlist_get_element(neo_boardlist *list, int index) {
  return(neo_list_get_element(list, index));
}

int neo_boardlist_get_size(neo_boardlist *list) {
  return(neo_list_get_size(list));
}

void neo_boardlist_free_all(neo_boardlist *list) {
  void (*func)();

  func=&neo_board_free_complete;
  neo_list_free_all(list, func);
}


/* portlist */
int neo_portlist_create(neo_portlist *list) {
  return(neo_list_create(list));
}

int neo_portlist_append_element(neo_portlist *list, neo_port *port) {
  return(neo_list_append_element(list, port));
}

neo_port *neo_portlist_get_element(neo_portlist *list, int index) {
  return(neo_list_get_element(list, index));
}

int neo_portlist_get_size(neo_portlist *list) {
  return(neo_list_get_size(list));
}

void neo_portlist_free_all(neo_portlist *list) {
  void (*func)();

  func=&free;
  neo_list_free_all(list, func);
}

