#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include "neo.h"

int neo_location_create_from_string(neo_location *loc, char *in) {
  char *atptr, *ptr;
  char board[1024], port[1024];

  strcpy(loc->instring, in);

  loc->starboard=0;
  loc->starport=0;
  atptr=strchr(in, '@');
  if (atptr==NULL) {
    loc->hasboard=0;
    loc->hasport=0;
  } else if (atptr!=in) {
    /* there's something before the @, i.e. a board or port etc. */
    ptr=strchr(in, '/');
    if ((ptr==NULL) || (ptr>atptr)) { /* no / or the / is after the @ */
      /* it's only a port */
      strncpy(port, in, atptr-in);
      port[atptr-in]='\0';
      if (!strcmp(port, "*") || !strcmp(port, ".")) {
	loc->hasport=1;
	loc->starport=1;
      } else {
	loc->hasport=1;
        loc->port=atoi(port);
      }
      loc->hasboard=0;
    } else {
      /* first get the board */
      strncpy(board, in, ptr-in);
      board[ptr-in]='\0';
      if (!strcmp(board, "*") || !strcmp(board, ".")) {
        loc->hasboard=1;
	loc->starboard=1;
      } else {
	loc->hasboard=1;
        loc->board=atoi(board);
      }

      /* now get the port if there is one */
      if (ptr+1 == atptr) {
        /* no port */
	loc->hasport=0;
      } else {
        strncpy(port, ptr+1, atptr-(ptr+1));
        port[atptr-(ptr+1)]='\0';
        if (!strcmp(port, "*") || !strcmp(port, ".")) {
	  loc->hasport=1;
	  loc->starport=1;
        } else {
	  loc->hasport=1;
          loc->port=atoi(port);
        }
      }
    }
  } else {
    /* there's no board or port (nothing before the @) */
    loc->hasboard=0;
    loc->hasport=0;
  }

  /* if there's no @ we'll assume it's a host */
  if (atptr==NULL) atptr=in;

  /* now get the devices */
  loc->devicelist=neo_devicelist_create_from_string(atptr, g);
  if (!loc->devicelist) {
    neo_error=NEO_ERR_BADFORMAT;
    return(-1);
  }
  
  /* just incase, shouldn't need this */
  if (loc->starport) loc->hasport=1;
  if (loc->starboard) loc->hasboard=1;
  return(0);

}

int neo_location_num_hosts(neo_location *loc) {
  return(neo_devicelist_get_size(loc->devicelist));
}

neo_device *neo_location_get_device_n(neo_location *loc, int n) {
  return(neo_devicelist_get_element(loc->devicelist, n));
}

neo_device *neo_location_get_first_device(neo_location *loc) {
  return(neo_devicelist_get_element(loc->devicelist, 0));
}

int neo_location_is_simplehost(neo_location *loc) {
  if ((neo_location_num_hosts(loc) == 1) &&
      (!neo_location_has_board(loc)) &&
      (!neo_location_has_port(loc))) {
    return(1);
  }
  return(0);
}

int neo_location_has_port(neo_location *loc) {
  return(loc->hasport);
}

int neo_location_has_board(neo_location *loc) {
  return(loc->hasboard);
}

int neo_location_star_port(neo_location *loc) {
  return(loc->starport);
}

int neo_location_star_board(neo_location *loc) {
  return(loc->starboard);
}

int neo_location_get_portnum(neo_location *loc) {
  if (loc->hasport) return(loc->port);
  return(-1);
}

int neo_location_get_boardnum(neo_location *loc) {
  if (loc->hasboard) return(loc->board);
  return(-1);
}

char *neo_location_get_instr(neo_location *loc) {
  return(loc->instring);
}

int neo_location_to_string(neo_location *loc, char *buff) {
  /* NEED TO IMPLEMENT */
  return(0);
}

void neo_location_set_deviceconsts(neo_location *loc, neo_global *g) {
  int i, j, ret;

  j=neo_location_num_hosts(loc);
  for (i=0; i<j; i++) {
    ret=neo_device_set_const_from_probe(neo_location_get_device_n(loc, i), g);
    if (ret==-1) {
      printf("Could not contact device %s\n", neo_device_get_name(neo_location_get_device_n(loc, i)));
    }
  }
}

void neo_location_copy(neo_location *src, neo_location *dst) {
  memcpy(dst, src, sizeof(neo_location));
}

int neo_location_debugprint(neo_location *loc) {
  printf("hasboard: %i\n", loc->hasboard);
  printf("board: %i\n", loc->board);
  printf("hasport: %i\n", loc->hasport);
  printf("port: %i\n", loc->port);
  if (loc->devicelist) {
    neo_devicelist_debugprint(loc->devicelist);
  }
  return(0);
}

void neo_location_free_elements(neo_location *loc) {
  if (loc==NULL) return;

  neo_devicelist_free_all(loc->devicelist);
}

void neo_location_free_complete(neo_location *loc) {
  if (loc==NULL) return;

  neo_location_free_elements(loc);
  free(loc);
}

