#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "neo.h"

void neo_macaddr_create_from_ints(neo_macaddr *m, int a, int b, int c, int d, int e, int f) {
  m->a=a;
  m->b=b;
  m->c=c;
  m->d=d;
  m->e=e;
  m->f=f;
}


int neo_macaddr_create_from_string(neo_macaddr *m, char *in) {
  /* this should probably get cleaned up.  It should also be changed
     to accept single digit components */
  char *ptr, *endptr, buff[5];
  int i, j, num[10], len;

  ptr=strstr(in, "Hex:");
  if (ptr) {
    ptr+=strlen("Hex:");
  } else {
    ptr=in;
  }

  /* remove up to 5 leading spaces */
  for (i=0; i<5; i++) {
    if (ptr[0]==' ') ptr++;
  }

  len=strlen(ptr);
  endptr=ptr+len-1;

  if (len<12) {
    neo_error=NEO_ERR_BADFORMAT;
    return(-1);
  }

  /* restrict to xxxx.xxxx.xxxx,  xx:xx:xx:xx:xx:xx or xx xx xx xx xx xx for now */
  if (! ((ptr[4]=='.' && ptr[9]=='.') ||
	 (ptr[2]==':' && ptr[5]==':' && ptr[8]==':' && ptr[11]==':' && ptr[14]==':') ||
	 (ptr[2]==' ' && ptr[5]==' ' && ptr[8]==' ' && ptr[11]==' ' && ptr[14]==' '))) {
    neo_error=NEO_ERR_BADFORMAT;
    return(-1);
  }
  
  num[0]=num[1]=num[2]=num[3]=num[4]=num[5]=-1;
  for (i=0; i<6; i++) {
    if (ptr>endptr-1) {
      neo_error=NEO_ERR_BADFORMAT;
      return(-1);
    }
    buff[0]=ptr[0];
    buff[1]=ptr[1];
    buff[2]='\0';
    sscanf(buff, "%x", &j);
    num[i]=j;

    ptr+=2;
    if (i!=5 && !isxdigit((int) ptr[0])) ptr++;
  }

  /* was there more string we didn't read? */
  /*
  if (ptr!=endptr+1) {
      neo_error=NEO_ERR_BADFORMAT;
      return(-1);
  }
  */
  
  /* check if any weren't set */
  for (i=0; i<6; i++) {
    if (num[i]==-1) {
      neo_error=NEO_ERR_BADFORMAT;
      return(-1);
    }
  }

  neo_macaddr_create_from_ints(m, num[0], num[1], num[2], num[3], num[4], num[5]);
  return(0);
}


int neo_macaddr_create_from_dotted_ints(neo_macaddr *m, char *in) {
  int num[6], count;
  char *ptr;
  
  count=0;
  ptr=in;
  while(1) {
    num[count]=atoi(ptr);
    ptr=strchr(ptr, '.');
    if (!ptr) break;
    ptr++;
    count++;
  }
  
  neo_macaddr_create_from_ints(m, num[0], num[1], num[2], num[3], num[4], num[5]);
  return(0);
}


void neo_macaddr_to_string(neo_macaddr *m, char *buff) {
  if (neo_global_get_macmode(g)==NEO_GLOBAL_MACMODE_STANDARD) {
    sprintf(buff, "%2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X", m->a, m->b, m->c, m->d, m->e, m->f);
  } else if (neo_global_get_macmode(g)==NEO_GLOBAL_MACMODE_CISCO) {
    sprintf(buff, "%2.2X%2.2X.%2.2X%2.2X.%2.2X%2.2X", m->a, m->b, m->c, m->d, m->e, m->f);
  } else if (neo_global_get_macmode(g)==NEO_GLOBAL_MACMODE_DASH) {
    sprintf(buff, "%2.2X-%2.2X-%2.2X-%2.2X-%2.2X-%2.2X", m->a, m->b, m->c, m->d, m->e, m->f);
  } else {
    sprintf(buff, "%2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X", m->a, m->b, m->c, m->d, m->e, m->f);
  }
}


void neo_macaddr_to_dotted_ints_string(neo_macaddr *m, char *buff) {
  sprintf(buff, "%i.%i.%i.%i.%i.%i", m->a, m->b, m->c, m->d, m->e, m->f);
}


int neo_macaddr_is_equal(neo_macaddr *a, neo_macaddr *b) {
  if (a->a != b->a) return(0);
  if (a->b != b->b) return(0);
  if (a->c != b->c) return(0);
  if (a->d != b->d) return(0);
  if (a->e != b->e) return(0);
  if (a->f != b->f) return(0);
  return(1);
}
