#include <stdlib.h>
#include "msnmp.h"

/* if there are no elements in a list then list->next = list */

msnmp_list *msnmp_list_create() {
  msnmp_list *out;

  out=malloc(sizeof(msnmp_list));
  out->element=NULL;
  out->next=out;
  return(out);
}

void msnmp_list_append_element(msnmp_list *list, void *in) {
  msnmp_list *tmp;

  if (list->next == list) {
    list->element=in;
    list->next=NULL; /* shouldn't really be necessary */
  } else {
    tmp=list;
    while (tmp->next) {
      tmp=tmp->next;
    }
    tmp->next=malloc(sizeof(msnmp_list));
    tmp=tmp->next;
    tmp->element=in;
    tmp->next=NULL;
  }
}

void *msnmp_list_get_element(msnmp_list *list, int index) {
  /* return the item indexed by "index", if it doesn't exist then return NULL */
  int count = 0;
  msnmp_list *tmp;

  if (list->next == list) return(NULL);
  
  tmp=list;
  while(tmp) {
    if (count==index) return(tmp->element);
    tmp=tmp->next;
    count++;
  }
  return(NULL);
}

int msnmp_list_get_size(msnmp_list *list) {
  int count = 0;
  msnmp_list *tmp;

  if (list->next == list) return(0);

  tmp=list;
  while (tmp) {
    count++;
    tmp=tmp->next;
  }
  return(count);
}

void msnmp_list_free_all(msnmp_list *list, void (*elefree)(void *)) {
  msnmp_list *tmp, *next;

  if (!list) return;
  
  if (list->next == list) {
    (*elefree)(list->element);
    free(list);
    return;
  }

  tmp=list;
  while (tmp) {
    next=tmp->next;
    (*elefree)(tmp->element);
    free(tmp);
    tmp=next;
  }
}
