#define DEBUG 0

int msnmp_errno;

typedef struct _msnmp_oid {
  int size;
  int obj[128];
} msnmp_oid;

typedef struct _msnmp_request {
  int type;
  msnmp_oid oid;
  int valtype;
  char val[1024];
  int seq;
  char community[1024];
} msnmp_request;

typedef struct _msnmp_response {
  int type;
  int parsevar;
  msnmp_oid var;
  char val[1024];
  int seq;
  char community[1024];
} msnmp_response;

typedef struct _msnmp_list {
  void *element;
  struct _msnmp_list *next;
} msnmp_list;

enum {
  MSNMP_ERR_NOERROR,
  MSNMP_ERR_BADOID,
  MSNMP_ERR_NOHOST,
  MSNMP_ERR_TIMEOUT,
  MSNMP_ERR_BAD_RESPONSE,

  MSNMP_ERR_NOSUCHVAR,
  MSNMP_ERR_TOOBIG,
  MSNMP_ERR_BADSETVAL,
  MSNMP_ERR_READONLY,
  MSNMP_ERR_GENERR
};

enum {
  MSNMP_REQ_GET,
  MSNMP_REQ_GETNEXT,
  MSNMP_REQ_SET
};

enum {
  MSNMP_TYP_OCTSTR,
  MSNMP_TYP_INT,
  MSNMP_TYP_OBJ,
  MSNMP_TYP_TIME,
  MSNMP_TYP_OCTETS,
  MSNMP_TYP_GAUGE,
  MSNMP_TYP_IPADDR
};

#include <sys/types.h>
#include <sys/socket.h>
#include "msnmp_prototypes.h"
#include "config.h"
