/* -------------------------------- list.c -------------------------------- */
msnmp_list *msnmp_list_create();
void msnmp_list_append_element(msnmp_list *list, void *in);
void *msnmp_list_get_element(msnmp_list *list, int index);
int msnmp_list_get_size(msnmp_list *list);
void msnmp_list_free_all(msnmp_list *list, void (*elefree)(void *));

/* -------------------------------- main.c -------------------------------- */

/* -------------------------------- msnmpget.c -------------------------------- */
int main(int argc, char **argv);

/* -------------------------------- msnmpset.c -------------------------------- */
int main(int argc, char **argv);

/* -------------------------------- msnmpwalk.c -------------------------------- */
int main(int argc, char **argv);

/* -------------------------------- oid.c -------------------------------- */
int msnmp_oid_create_from_string(msnmp_oid *oid, char *str);
void msnmp_oid_create_from_bytes(msnmp_oid *oid, unsigned char *buff);
int msnmp_oid_get_size(msnmp_oid *oid);
char *msnmp_oid_to_string(msnmp_oid *oid);
void msnmp_oid_to_bytes(msnmp_oid *oid, char *buff);

/* -------------------------------- request.c -------------------------------- */
int msnmp_request_create_get(msnmp_request *r, char *object, char *community);
int msnmp_request_create_getnext(msnmp_request *r, char *object, char *community);
int msnmp_request_create_set(msnmp_request *r, char *object, char *community, char *type, char *val);
int _msnmp_request_create_internal(msnmp_request *r, char *object, char *community);
int msnmp_request_get_sequence(msnmp_request *r);
char *msnmp_request_get_var(msnmp_request *r);
int msnmp_request_to_packet(msnmp_request *r, unsigned char *buff);

/* -------------------------------- response.c -------------------------------- */
int msnmp_response_create_from_bytes(msnmp_response *r, unsigned char *buff, int parsevar);
int msnmp_response_get_sequence(msnmp_response *r);
char *msnmp_response_to_string(msnmp_response *r);
int msnmp_response_get_type(msnmp_response *r);
char *msnmp_response_get_var(msnmp_response *r);

/* -------------------------------- util.c -------------------------------- */
int len_bytes(unsigned char *b, int *len);
int send_with_timeout(int sockfd, struct sockaddr *addr, int addrsize, msnmp_request *req, msnmp_response *resp, int parsevar, int timeout, int burst);
int msnmp_get(char *host, char *community, char *object, char *response, int timeout, int burst);
msnmp_list *msnmp_walk(char *host, char *community, char *object, int timeout, int burst);
int msnmp_set(char *host, char *community, char *object, char *type, char *val, char *response, int timeout, int burst);

