#include <stdio.h>
#include <stdlib.h>
#include "msnmp.h"

int main(int argc, char **argv) {
  char buff[1024];
  int ret;

  if (argc<6) {
    printf("Usage: client <host> <community> <variable> <type> <value>\n");
    exit(1);
  }
  
  ret=msnmp_set(argv[1], argv[2], argv[3], argv[4], argv[5], buff, 4, 1);
  if (ret) {
    if (msnmp_errno==MSNMP_ERR_TIMEOUT) {
      printf("Timeout: no reply.\n");
    } else if (msnmp_errno==MSNMP_ERR_NOSUCHVAR) {
      printf("No such variable.\n");
    } else if (msnmp_errno==MSNMP_ERR_BADOID) {
      printf("Bad object id.\n");
    } else if (msnmp_errno==MSNMP_ERR_NOHOST) {
      printf("Could not find host.\n");
    } else if (msnmp_errno==MSNMP_ERR_READONLY) {
      printf("Variable is read-only.\n");
    } else if (msnmp_errno==MSNMP_ERR_BADSETVAL) {
      printf("Bad value for variable.\n");
    } else {
      printf("Error.\n");
    }
    return(1);
  }
  
  printf("Got \"%s\"\n", buff);
  return(0);
}
