#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include "msnmp.h"

int main(int argc, char **argv) {
  msnmp_response *resp;
  struct hostent *hent;
  int sockfd, ret, i, len;
  struct sockaddr_in servaddr;
  msnmp_request req;
  char *host, *object, *community;

  if (argc<4) {
    printf("Usage: msnmpwalk <host> <community> <variable>\n");
    exit(1);
  }

  host=argv[1];
  community=argv[2];
  object=argv[3];

  hent=gethostbyname(host);
  if (!hent) {
    printf("Could not find host.\n");
    exit(1);
  }
  
  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family=AF_INET;
  servaddr.sin_port=htons(161);
  memcpy(&(servaddr.sin_addr.s_addr), hent->h_addr, hent->h_length);

  sockfd=socket(AF_INET, SOCK_DGRAM, 0);
  i=fcntl(sockfd, F_GETFL, 0);
  ret=fcntl(sockfd, F_SETFL, i|O_NONBLOCK);

  ret=msnmp_request_create_getnext(&req, object, community);
  if (ret) {
    if (msnmp_errno==MSNMP_ERR_TIMEOUT) {
      printf("Timeout: no reply.\n");
    } else if (msnmp_errno==MSNMP_ERR_NOSUCHVAR) {
      printf("No such variable.\n");
    } else if (msnmp_errno==MSNMP_ERR_BADOID) {
      printf("Bad object id.\n");
    } else if (msnmp_errno==MSNMP_ERR_NOHOST) {
      printf("Could not find host.\n");
    } else {
      printf("Error.\n");
    }
    exit(1);
  }

  len=strlen(object);
  while (1) {
    resp=malloc(sizeof(msnmp_response));
    ret=send_with_timeout(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr), &req, resp, 1, 4, 1);
    if (ret<0) {
      break;
    }

    if (strncmp(msnmp_response_get_var(resp), object, len)) {
      free(resp);
      exit(0);
    }
    printf("%s = %s\n", msnmp_response_get_var(resp), msnmp_response_to_string(resp));

    ret=msnmp_request_create_getnext(&req, msnmp_response_get_var(resp), community);
    if (ret) {
      break;
    }
  }

  if (msnmp_errno==MSNMP_ERR_TIMEOUT) {
    printf("Timeout: no reply.\n");
  } else if (msnmp_errno==MSNMP_ERR_NOSUCHVAR) {
    printf("No such variable.\n");
  } else if (msnmp_errno==MSNMP_ERR_BADOID) {
    printf("Bad object id.\n");
  } else if (msnmp_errno==MSNMP_ERR_NOHOST) {
    printf("Could not find host.\n");
  } else {
    printf("Error.\n");
  }
  exit(1);
}
