#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "msnmp.h"

/* for now we only support numbers less than 16384 */

int msnmp_oid_create_from_string(msnmp_oid *oid, char *str) {
  char *ptr;
  int i;
  
  if (strncmp(str, ".1.3.6.", 7)) {
    msnmp_errno=MSNMP_ERR_BADOID;
    return(-1);
  }

  oid->obj[0]=1;
  oid->obj[1]=3;
  oid->obj[2]=6;
  oid->size=3;
  ptr=str+7;

  while (1) {
    i=atoi(ptr);
    if (i>16383) {
      msnmp_errno=MSNMP_ERR_BADOID;
      return(-1);
    }
    if (i<128) {
      oid->obj[oid->size]=i;
      oid->size++;
    } else {
      oid->obj[oid->size]=((int) (i/128))+128;
      oid->obj[oid->size+1]=i%128;
      oid->size+=2;
    }
    ptr=strchr(ptr, '.');
    if (ptr==NULL) break;
    ptr++;
  }
  return(0);
}


void msnmp_oid_create_from_bytes(msnmp_oid *oid, unsigned char *buff) {
  /* we start at the length */
  int len, c, i;

  c=0;
  c+=len_bytes(buff, &len);

  /* we just assume that the first byte is going to be 0x2b */
  oid->obj[0]=1;
  oid->obj[1]=3;
  oid->size=2;
  c++;

  for (i=2; i<len+1; i++) {
    if (buff[c]<128) {
      oid->obj[i]=buff[c];
      c++;
    } else {
      oid->obj[i]=((buff[c]-128)*128)+buff[c+1];
      c+=2;
      len--;
    }
    oid->size++;
  }
}

int msnmp_oid_get_size(msnmp_oid *oid) {
  return(oid->size);
}

char *msnmp_oid_to_string(msnmp_oid *oid) {
  int i;
  char *out;

  out=malloc(1024);

  strcpy(out, "");
  for (i=0; i<oid->size; i++) {
    sprintf(out, "%s.%i", out, oid->obj[i]);
  }
  return(out);
}


void msnmp_oid_to_bytes(msnmp_oid *oid, char *buff) {
  int i, b;

  buff[0]=0x2b;
  b=1;

  for (i=2; i<oid->size; i++) {
    buff[b]=oid->obj[i];
    b++;
  }
}

