#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "msnmp.h"

int msnmp_request_create_get(msnmp_request *r, char *object, char *community) {
  int ret;
  
  ret=_msnmp_request_create_internal(r, object, community);
  if (ret) return(ret);
  r->type=MSNMP_REQ_GET;
  return(0);
}

int msnmp_request_create_getnext(msnmp_request *r, char *object, char *community) {
  int ret;
  
  ret=_msnmp_request_create_internal(r, object, community);
  if (ret) return(ret);
  r->type=MSNMP_REQ_GETNEXT;
  return(0);
}

int msnmp_request_create_set(msnmp_request *r, char *object, char *community, char *type, char *val) {
  int ret;
  
  ret=_msnmp_request_create_internal(r, object, community);
  if (ret) return(ret);
  r->type=MSNMP_REQ_SET;
  if (!strcasecmp(type, "int")) {
    r->valtype=MSNMP_TYP_INT;
  } else if (!strcasecmp(type, "string")) {
    r->valtype=MSNMP_TYP_OCTSTR;
  } else if (!strcasecmp(type, "oid")) {
    r->valtype=MSNMP_TYP_OBJ;
  } else if (!strcasecmp(type, "time")) {
    r->valtype=MSNMP_TYP_TIME;
  } else {
    return(-1);
  }
  strcpy(r->val, val);

  return(0);
}

int _msnmp_request_create_internal(msnmp_request *r, char *object, char *community) {
  int ret;
  static int first;

  if (first!=12345) {
    srand(time(NULL));
    first=12345;
  }
  
  strcpy(r->community, community);
  r->seq=rand()%32767;
  ret=msnmp_oid_create_from_string(&(r->oid), object);
  if (ret) return(-1);
  return(0);
}

int msnmp_request_get_sequence(msnmp_request *r) {
  return(r->seq);
}

char *msnmp_request_get_var(msnmp_request *r) {
  return(msnmp_oid_to_string(&(r->oid)));
}

int msnmp_request_to_packet(msnmp_request *r, unsigned char *buff) {
  /* creates a packet in buff, the length of the packet is returned */
  int c, oidlen, vallen=0, seq;
  char valbuff[1024];

  /* if we're doing a set figure out the value and length first so we
     know the earlier lengths */
  if (r->type==MSNMP_REQ_SET) {
    if (r->valtype==MSNMP_TYP_OCTSTR) {
      valbuff[0]=0x04;
      valbuff[1]=strlen(r->val); /* check that it's less than 128!!! */
      strcpy(valbuff+2, r->val);
      vallen=strlen(r->val)+2;
    } else if (r->valtype==MSNMP_TYP_INT) {
      int tmp;

      tmp=atoi(r->val);
      valbuff[0]=0x02;
      valbuff[1]=0x04;
      valbuff[2]=(tmp & 0xff000000) >> (8*3);
      valbuff[3]=(tmp & 0x00ff0000) >> (8*2);
      valbuff[4]=(tmp & 0x0000ff00) >> (8*1);
      valbuff[5]=(tmp & 0x000000ff);
      vallen=6;
    }
  } else {
    /* r->type==MSNMP_REQ_GET || r->type==MSNMP_REQ_GETNEXT */
    valbuff[0]=0x05;
    valbuff[1]=0;
    vallen=2;
  }

  c=0;
  oidlen=msnmp_oid_get_size(&(r->oid))-1; /* first byte is two nums */
  
  /* over all sequence + seq length */
  buff[c]=0x30; c++;
  buff[c]=0x82; c++;
  buff[c]=0x00; c++;
  buff[c]=29+strlen(r->community)+oidlen+vallen; c++;
     
  /* version */
  buff[c]=0x02; 
  buff[c+1]=1;
  buff[c+2]=0;
  c+=3;

  /* community */
  buff[c]=0x04;
  buff[c+1]=strlen(r->community);
  c+=2;
  strcpy(buff+c, r->community);
  c+=strlen(r->community);

  /* pdu type */
  if (r->type==MSNMP_REQ_GET) {
    buff[c]=0xa0;
  } else if (r->type==MSNMP_REQ_GETNEXT) {
    buff[c]=0xa1;
  } else if (r->type==MSNMP_REQ_SET) {
    buff[c]=0xa3;
  }
  buff[c+1]=0x82;
  buff[c+2]=0x00;
  buff[c+3]=20+oidlen+vallen;
  c+=4;

  /* id */
  seq=htons(r->seq);
  buff[c]=0x02;
  buff[c+1]=0x02;

  buff[c+2]=(seq & 0xff00)>>8;
  buff[c+3]=(seq & 0x00ff);
  c+=4;

  /* status */
  buff[c]=0x02;
  buff[c+1]=1;
  buff[c+2]=0;
  c+=3;

  /* error index */
  buff[c]=0x02;
  buff[c+1]=1;
  buff[c+2]=0;
  c+=3;

  /* requests */
  buff[c]=0x30;
  buff[c+1]=0x82;
  buff[c+2]=0x00;
  buff[c+3]=6+oidlen+vallen;

  buff[c+4]=0x30;
  buff[c+5]=0x82;
  buff[c+6]=0x00;
  buff[c+7]=2+oidlen+vallen;
  c+=8;

  /* obj id */
  buff[c]=0x06;
  /* obj len */
  buff[c+1]=oidlen;
  c+=2;

  /* obj */
  msnmp_oid_to_bytes(&(r->oid), buff+c);
  c+=oidlen;

  memcpy(buff+c, valbuff, vallen);
  c+=vallen;

  return(c);
}
