#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "msnmp.h"

/* note that var is only set for getnext! */

int msnmp_response_create_from_bytes(msnmp_response *r, unsigned char *buff, int parsevar) {
  int c, len, i;

  r->parsevar=parsevar;
  
  c=0;
  if (buff[c] != 0x30) {
    msnmp_errno=MSNMP_ERR_BAD_RESPONSE;
    return(-1);
  }
  c+=1+len_bytes(buff+c+1, &len); /* skip the length */
  
  /* must be version 1 */
  if (! (buff[c]==0x02 &&
	 buff[c+1]==1 &&
	 buff[c+2]==0)) {
    msnmp_errno=MSNMP_ERR_BAD_RESPONSE;
    return(-1);
  }
  c+=3;

  /* community */
  if (buff[c]!=4) {
    msnmp_errno=MSNMP_ERR_BAD_RESPONSE;
    return(-1);
  }
  c+=1;
  i=len_bytes(buff+c, &len);
  c+=i;
  memcpy(r->community, buff+c, len);
  c+=len;
  if (DEBUG) printf("DEBUG: got community %s\n", r->community);

  /* pdu type */
  if (buff[c] != 0xa2) {
    msnmp_errno=MSNMP_ERR_BAD_RESPONSE;
    return(-1);
  }
  c+=1+len_bytes(buff+c+1, &len); /* skip length */

  /* sequence number */
  /* int may not be big enough to ensure no wrap around, we'll just
     live with that for now.  we probably shouldn't convert to int,
     just leave as bits */
  if (buff[c]!=0x02) {
    msnmp_errno=MSNMP_ERR_BAD_RESPONSE;
    return(-1);
  }
  c+=1+len_bytes(buff+c+1, &len);
  
  r->seq=0;
  for (i=0; i<len; i++) {
    if (i!=0) r->seq=r->seq<<8;
    r->seq+=buff[c+i];
  }
  r->seq=ntohs(r->seq);

  c+=len;
  if (DEBUG) printf("DEBUG: got %i, len was %i\n", r->seq, len);

  /* status */
  if (!(buff[c]==0x02 && buff[c+1]==1)) {
    msnmp_errno=MSNMP_ERR_BAD_RESPONSE;
    return(-1);
  }
  c+=2;
  if (buff[c]!=0) {
    if (DEBUG) printf("DEBUG: Response error set!\n");
    if (buff[c]==1) {
      msnmp_errno=MSNMP_ERR_TOOBIG;
    } else if (buff[c]==2) {
      msnmp_errno=MSNMP_ERR_NOSUCHVAR;
    } else if (buff[c]==3) {
      msnmp_errno=MSNMP_ERR_BADSETVAL;
    } else if (buff[c]==4) {
      msnmp_errno=MSNMP_ERR_READONLY;
    } else if (buff[c]==5) {
      msnmp_errno=MSNMP_ERR_GENERR;
    }
    return(-1);
  }
  c+=1;

  /* error index */
  if (!(buff[c]==0x02 && buff[c+1]==1)) {
    msnmp_errno=MSNMP_ERR_BAD_RESPONSE;
    return(-1);
  }
  
  c+=3; /* ignore the index for now */

  /* requests */
  if (buff[c]!=0x30) {
    msnmp_errno=MSNMP_ERR_BAD_RESPONSE;
    return(-1);
  }
  c+=1+len_bytes(buff+c+1, &len); /* skip size */

  /* request */
  if (buff[c]!=0x30) {
    msnmp_errno=MSNMP_ERR_BAD_RESPONSE;
    return(-1);
  }
  c+=1+len_bytes(buff+c+1, &len); /* skip size */

  /* object */
  if (buff[c]!=0x06) {
    msnmp_errno=MSNMP_ERR_BAD_RESPONSE;
    return(-1);
  }
  c++;
  if (parsevar==1) {
    msnmp_oid_create_from_bytes((&r->var), buff+c);
    if (DEBUG) printf("DEBUG: got %s\n", msnmp_oid_to_string(&(r->var)));
  }
  c+=len_bytes(buff+c, &len);
  c+=len;

  i=len_bytes(buff+c+1, &len);
  if (buff[c]==0x04) { /* string */
    int j, hex;
    c+=1+i;
    r->type=MSNMP_TYP_OCTSTR;
    for (j=0, hex=0; j<len; j++) {
      /* we used to use isalnum etc. but I don't want it to be locale
	 dependant, which is under linux */
      if (buff[c+j]>'~' || buff[c+j]<'\007') {
	hex=1;
	break;
      } else if (buff[c+j]<' ') {
	if (buff[c+j]!='\0' &&
	    buff[c+j]!='\n' &&
	    buff[c+j]!='\r') {
	  hex=1;
	  break;
	}
      }
    }
    
    if (!hex) {
      strncpy(r->val, buff+c, len);
      r->val[len]='\0';
    } else {
      strcpy(r->val, "Hex:");
      for (j=0; j<len; j+=1) {
	sprintf(r->val, "%s %02X", r->val, buff[c+j]);
      }
    }
  } else if (buff[c]==0x02) { /* int */
    unsigned int tmp=0;
    
    c+=1+i;
    r->type=MSNMP_TYP_INT;
    for (i=0; i<len; i++) {
      if (i!=0) tmp=tmp<<8;
      tmp+=buff[c+i];
    }
    c+=len;
    sprintf(r->val, "%u", tmp);
  } else if (buff[c]==0x40) { /* IP addr */
    c+=1+i;
    r->type=MSNMP_TYP_IPADDR;
    strcpy(r->val, "");
    for (i=0; i<len; i++) {
      sprintf(r->val, "%s%i", r->val, buff[c+i]);
      if (i!=len-1) strcat(r->val, ".");
    }
    c+=len;
  } else if (buff[c]==0x43) { /* timeticks */
    unsigned int tmp=0;
    
    c+=1+i;
    r->type=MSNMP_TYP_TIME;
    for (i=0; i<len; i++) {
      if (i!=0) tmp=tmp<<8;
      tmp+=buff[c+i];
    }
    c+=len;
    sprintf(r->val, "%u", tmp);
  } else if (buff[c]==0x41) { /* octets ? */
    int tmp=0;
    c+=1+i;
    r->type=MSNMP_TYP_OCTETS;
    for (i=0; i<len; i++) {
      if (i!=0) tmp=tmp<<8;
      tmp+=buff[c+i];
    }
    c+=len;
    sprintf(r->val, "%i", tmp);
  } else if (buff[c]==0x42) {
    int tmp=0;
    c+=1+i;
    r->type=MSNMP_TYP_GAUGE;
    for (i=0; i<len; i++) {
      if (i!=0) tmp=tmp<<8;
      tmp+=buff[c+i];
    }
    c+=len;
    sprintf(r->val, "%i", tmp);
  } else if (buff[c]==0x06) { /* oject */
    c+=1+i;
    r->type=MSNMP_TYP_OBJ;

    /* this is wrong for >= 16511 */
    for (i=0; i<len; i++) {
      if (i==0) {
	strcpy(r->val, ".1.3");
      } else {
	if (buff[c+i]<128) {
	  sprintf(r->val, "%s.%i", r->val, buff[c+i]);
	} else {
	  int foo;
	  foo=(((unsigned char) buff[c+i]) & 127)<<7;
	  foo+=(unsigned char) buff[c+i+1];
	  sprintf(r->val, "%s.%i", r->val, foo);
	  i++;
	}
      }
    }
    c+=len;
  } else { /* unknown */
    if (DEBUG) printf("DEBUG: Unknown!\n");
  }

  return(0);
}

int msnmp_response_get_sequence(msnmp_response *r) {
  return(r->seq);
}

char *msnmp_response_to_string(msnmp_response *r) {
  return(r->val);
}

int msnmp_response_get_type(msnmp_response *r) {
  return(r->type);
}

char *msnmp_response_get_var(msnmp_response *r) {
  if (r->parsevar) return(msnmp_oid_to_string(&(r->var)));
  return(NULL);
}
