#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include "msnmp.h"

int len_bytes(unsigned char *b, int *len) {
  /* returns the number of bytes taken up by the length starting at b,
     and places the value of the length in len */
     
  int i, j;
  if (b[0] < 128) {
    *len=b[0];
    return(1);
  }
  *len=0;
  j=(int)b[0]-128+1;
  for (i=1; i<j; i++) {
    if (i!=1)  (*len=*len<<8);
    *len=*len+b[i];
  }
  return(j);
}

int send_with_timeout(int sockfd, struct sockaddr *addr, int addrsize, msnmp_request *req, msnmp_response *resp, int parsevar, int timeout, int burst) {
  int ret, t, second, i, j;
  unsigned char rbuff[1500], sbuff[1500];

  i=msnmp_request_to_packet(req, sbuff);
  if (i<0) {
    return(-1);
  }

  if (burst>1) {
    for (j=0; j<burst; j++) {
      usleep(20);
      sendto(sockfd, sbuff, i, 0, addr, addrsize);
    }
  } else {
    sendto(sockfd, sbuff, i, 0, addr, addrsize);
  }

  while (1) {
    t=time(NULL);
    second=0;
    while (1) {
      /* we should time out on this loop too, incase we keep getting bad sequence ID's */
      ret=recvfrom(sockfd, rbuff, 1500, 0, NULL, NULL);

      if (ret>=0) break;

      if (errno!=EAGAIN) {
	msnmp_errno=MSNMP_ERR_GENERR; /* maybe something better ? */
	perror("");
	return(-1);
      }
      usleep(5);

      /* send more packets half way to the timeout if we haven't gotten an answer yet */
      if (!second && (((int) time(NULL)-t) >= (timeout/2))) {
	if (burst>1) {
	  for (j=0; j<burst; j++) {
	    usleep(20);
	    sendto(sockfd, sbuff, i, 0, addr, addrsize);
	  }
	} else {
	  sendto(sockfd, sbuff, i, 0, addr, addrsize);
	}
	second=1;
      }

      /* if the time has expired then we bail */
      if (((int) time(NULL)-t) >= timeout) {
	msnmp_errno=MSNMP_ERR_TIMEOUT;
	return(-1);
      }
    }
    ret=msnmp_response_create_from_bytes(resp, rbuff, parsevar);
    if (msnmp_response_get_sequence(resp) == msnmp_request_get_sequence(req)) break;
  }
  if (ret<0) return(ret);
  return(0);
}

int msnmp_get(char *host, char *community, char *object, char *response, int timeout, int burst) {
  msnmp_response resp;
  msnmp_request req;
  struct hostent *hent;
  int sockfd, ret, i;
  struct sockaddr_in servaddr;

  hent=gethostbyname(host);
  if (!hent) {
    msnmp_errno=MSNMP_ERR_NOHOST;
    return(-1);
  }
  
  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family=AF_INET;
  servaddr.sin_port=htons(161);
  memcpy(&(servaddr.sin_addr.s_addr), hent->h_addr, hent->h_length);

  sockfd=socket(AF_INET, SOCK_DGRAM, 0);
  i=fcntl(sockfd, F_GETFL, 0);
  ret=fcntl(sockfd, F_SETFL, i|O_NONBLOCK);
  
  ret=msnmp_request_create_get(&req, object, community);
  if (ret) {
    close(sockfd);
    return(-1);
  }

  ret=send_with_timeout(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr), &req, &resp, 0, timeout, burst);
  if (ret<0) {
    if (msnmp_errno==MSNMP_ERR_TIMEOUT) {
      printf("Error - timed out on one snmp query for %s.\n", host);
    } else {
      /* printf("Error - not able to receive one snmp response from %s (for %s).\n", host, object); */
    }
    close(sockfd);
    return(ret);
  }

  strcpy(response, msnmp_response_to_string(&resp));

  close(sockfd);
  return(0);
}


msnmp_list *msnmp_walk(char *host, char *community, char *object, int timeout, int burst) {
  /* return NULL on error */
  struct hostent *hent;
  int sockfd, ret, i, len;
  struct sockaddr_in servaddr;
  msnmp_response *resp;
  msnmp_request req;
  msnmp_list *out;

  out=msnmp_list_create();

  hent=gethostbyname(host);
  if (!hent) {
    msnmp_errno=MSNMP_ERR_NOHOST;
    return(NULL);
  }
  
  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family=AF_INET;
  servaddr.sin_port=htons(161);
  memcpy(&(servaddr.sin_addr.s_addr), hent->h_addr, hent->h_length);

  sockfd=socket(AF_INET, SOCK_DGRAM, 0);
  i=fcntl(sockfd, F_GETFL, 0);
  ret=fcntl(sockfd, F_SETFL, i|O_NONBLOCK);

  ret=msnmp_request_create_getnext(&req, object, community);
  if (ret) {
    close(sockfd);
    return(NULL);
  }

  len=strlen(object);
  while (1) {
    resp=malloc(sizeof(msnmp_response));
    ret=send_with_timeout(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr), &req, resp, 1, timeout, burst);
    if (ret<0) {
      if (msnmp_errno==MSNMP_ERR_TIMEOUT) {
	printf("Error - timed out on snmp query during walk of %s.\n", host);
      } else {
	printf("Error - unable to receive snmp response during walk of %s.\n", host);
      }
      close(sockfd);
      return(out); /* return partial results */
      continue;
    }

    if (strncmp(msnmp_response_get_var(resp), object, len)) {
      free(resp);
      close(sockfd);
      return(out);
    }
    msnmp_list_append_element(out, resp);
    /* printf("DEBUG: got %s = %s\n", msnmp_response_get_var(resp), msnmp_response_to_string(resp)); */

    ret=msnmp_request_create_getnext(&req, msnmp_response_get_var(resp), community);
    if (ret) {
      close(sockfd);
      return(NULL);
    }
  }
}

int msnmp_set(char *host, char *community, char *object, char *type, char *val, char *response, int timeout, int burst) {
  msnmp_response resp;
  msnmp_request req;
  struct hostent *hent;
  int sockfd, ret, i;
  struct sockaddr_in servaddr;

  hent=gethostbyname(host);
  if (!hent) {
    msnmp_errno=MSNMP_ERR_NOHOST;
    return(-1);
  }
  
  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family=AF_INET;
  servaddr.sin_port=htons(161);
  memcpy(&(servaddr.sin_addr.s_addr), hent->h_addr, hent->h_length);

  sockfd=socket(AF_INET, SOCK_DGRAM, 0);
  i=fcntl(sockfd, F_GETFL, 0);
  ret=fcntl(sockfd, F_SETFL, i|O_NONBLOCK);

  ret=msnmp_request_create_set(&req, object, community, type, val);
  if (ret) {
    close(sockfd);
    return(-1);
  }

  ret=send_with_timeout(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr), &req, &resp, 0, timeout, burst);
  if (ret<0) {
    close(sockfd);
    return(ret);
  }

  strcpy(response, msnmp_response_to_string(&resp));
  
  return(0);
}
