#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/times.h>
#include <limits.h>
#include <msnmp.h>
#include <setjmp.h>

#ifdef linux
#include <linux/stddef.h>
#endif

#define NEO_VERSION 1.2.12
#define NEO_VERSION_STRING "1.2.12 (Atropine)"

#define LINE 1024
#define SHRTBUF 200


enum {
  NEO_ERR_NONE,
  NEO_ERR_GENERIC,
  NEO_ERR_INTERNAL,
  NEO_ERR_BADFORMAT,
  NEO_ERR_NOHOST,
  NEO_ERR_TIMEOUT,
  NEO_ERR_CONTACT,
  NEO_ERR_INCAPABLE,

  NEO_ERR_SNMP_NOVAR,
  NEO_ERR_SNMP_BADSET,
  NEO_ERR_SNMP_GENERIC,
  NEO_ERR_SNMP_NOHOST,

  NEO_TYPE_PORTLIST,
  NEO_TYPE_BOARDLIST,

  NEO_COMMAND_PORT_ENABLE,
  NEO_COMMAND_PORT_DISABLE,
  NEO_COMMAND_PORT_STATUS,
  NEO_COMMAND_PORT_IS_DISABLED,
  NEO_COMMAND_PORT_IS_ENABLED,
  NEO_COMMAND_PORT_IS_UNKNOWN,
  NEO_COMMAND_PORT_IS_SILENTERR,

  NEO_COMMAND_DEVICE_LOAD_UPLOAD,
  NEO_COMMAND_DEVICE_LOAD_DOWNLOAD,
  NEO_COMMAND_DEVICE_LOAD_IMAGE,
  NEO_COMMAND_DEVICE_LOAD_CONFIG,

  NEO_COMMAND_DEVICE_INFO_POWER,
  NEO_COMMAND_DEVICE_INFO_WEATHER,
  NEO_COMMAND_DEVICE_INFO_CPU,
  NEO_COMMAND_DEVICE_INFO_PRINTER,
  NEO_COMMAND_DEVICE_INFO_UPS,

  NEO_GLOBAL_MACMODE_STANDARD,
  NEO_GLOBAL_MACMODE_CISCO,
  NEO_GLOBAL_MACMODE_DASH,
  
  NEO_S_INKBS, NEO_S_OUTKBS, NEO_S_TOTALKBS,
  NEO_S_INPPS, NEO_S_OUTPPS, NEO_S_TOTALPPS,
  NEO_S_INERRPS, NEO_S_OUTERRPS, NEO_S_TOTALERRPS,

  NEO_S_INT,
  NEO_S_UNAVAIL,
  NEO_S_ERROR,
  NEO_S_ERRORUNAVAIL,

  NEO_ST_INKBS, NEO_ST_OUTKBS,
  NEO_ST_INPPSU, NEO_ST_OUTPPSU,
  NEO_ST_INPPSNU, NEO_ST_OUTPPSNU,
  NEO_ST_INERRPS, NEO_ST_OUTERRPS,

  NEO_ST_INT,
  NEO_ST_UNAVAIL,
  NEO_ST_ERROR,
  NEO_ST_ERRORUNAVAIL
};

typedef struct _neo_global {
  char argv0[LINE];
  int burst;
  char readcom[200];
  char writecom[200];
  char keyfile[LINE];
  char version[200];
  int statsdelay;
  int areyousure;
  int snmptimeout;
  int macmode;
} neo_global;

typedef msnmp_response neo_snmpresponse;
typedef msnmp_list neo_snmpresponselist;

typedef struct _neo_list {
  int size;
  int avail;
  void **list;
} neo_list;

typedef neo_list neo_boardlist;

typedef neo_list neo_portlist;

typedef neo_list neo_devicelist;

typedef neo_list neo_locationlist;

typedef struct _neo_stats {
  unsigned long inkbs, outkbs, totalkbs;
  unsigned long inpps, outpps, totalpps;
  unsigned long inerrps, outerrps, totalerrps;
} neo_stats;

typedef struct _neo_statstransfer {
  unsigned long inkbs, outkbs;
  unsigned long inppsu, outppsu;
  unsigned long inppsnu, outppsnu;
  unsigned long inerrps, outerrps;
  clock_t clk_inkbs, clk_outkbs;
  clock_t clk_inppsu, clk_outppsu;
  clock_t clk_inppsnu, clk_outppsnu;
  clock_t clk_inerrps, clk_outerrps;
} neo_statstransfer;

typedef struct _neo_location {
  neo_devicelist *devicelist;
  int board;
  int port;
  int hasboard;
  int hasport;
  int starboard;
  int starport;
  char instring[LINE];
} neo_location;

/* this leverages off neo_location but is only allowed one device */
typedef struct _neo_onelocation {
  neo_location loc;
} neo_onelocation;

typedef struct _neo_board {
  int number;
  int present; 
  char descr[1024];
  int hasseg;
  int seg;
  int link;
  int speed;
  int admin;
  int uplink;
  char uplinkdescr[1024];
  neo_portlist *portlist;
  neo_stats stats;
} neo_board;

typedef struct _neo_port {
  int number;
  char descr[1024];
  int link;
  int speed;
  int admin;
  int uplink;
  int duplex;
  neo_stats stats;
} neo_port;

typedef struct _neo_macaddr {
  int a, b, c, d, e, f;
} neo_macaddr;

typedef struct _neo_searchable {
  int primary_ip, primary_mac, primary_host;
  int has_ip, has_mac, has_host;
  neo_macaddr macaddr;
  char ipaddr[50];
  char hostname[300];
} neo_searchable;

typedef struct _neo_device {
  char name[300];

  /* constants */
  int constset;
  int type;
  char devname[300];
  char fullname[300];
  char descrmatch[LINE];
  int hasboards;
  int (*func_port_sed) (neo_location *, int command);
  int (*func_port_search) (neo_location *);
  int (*func_locate) (struct _neo_device *, neo_searchable *, neo_locationlist *, int uplink);
  int (*func_summary) (struct _neo_device *, neo_location *, neo_list *);
  int (*func_stats) (neo_location *, neo_list *);
  int (*func_devicestats) (neo_location *, neo_stats *);
  int (*func_reset) ();
  int (*func_load) (neo_location *, int type, int direction, char *host, char *file);
  void (*func_info) (struct _neo_device *, int type);
  neo_boardlist *boardlist;
  neo_portlist *portlist;
  neo_stats stats;
  neo_statstransfer statstrasfer;
} neo_device;

typedef struct _neo_sleeper {
  clock_t start;
  int waittime;
} neo_sleeper;


#include "neo_prototypes.h"

/* GLOBALS */
neo_global *g;
int neo_error;
sigjmp_buf jb;
