/* -------------------------------- board.c -------------------------------- */
void neo_board_create(neo_board *b);
void neo_board_set_number(neo_board *b, int in);
int neo_board_get_number(neo_board *b);
void neo_board_set_present(neo_board *b);
void neo_board_set_notpresent(neo_board *b);
int neo_board_is_present(neo_board *b);
void neo_board_set_descr(neo_board *b, char *descr);
char *neo_board_get_descr(neo_board *b);
void neo_board_set_uplinkdescr(neo_board *b, char *descr);
char *neo_board_get_uplinkdescr(neo_board *b);
void neo_board_set_link_up(neo_board *b);
void neo_board_set_link_down(neo_board *b);
void neo_board_set_link_unknown(neo_board *b);
int neo_board_link_is_up(neo_board *b);
int neo_board_link_is_down(neo_board *b);
int neo_board_link_is_unknown(neo_board *b);
void neo_board_set_speed(neo_board *b, int speed);
int neo_board_get_speed(neo_board *b);
void neo_board_set_admin_up(neo_board *b);
void neo_board_set_admin_down(neo_board *b);
void neo_board_set_admin_unknown(neo_board *b);
int neo_board_admin_is_up(neo_board *b);
int neo_board_admin_is_down(neo_board *b);
int neo_board_admin_is_unknown(neo_board *b);
void neo_board_set_uplink(neo_board *b);
void neo_board_set_notuplink(neo_board *b);
int neo_board_is_uplink(neo_board *b);
void neo_board_set_segment(neo_board *b, int seg);
int neo_board_get_segment(neo_board *b);
void neo_board_free_elements(neo_board *b);
void neo_board_free_complete(neo_board *b);
void neo_board_set_stats(neo_board *b, neo_stats *s);
neo_stats *neo_board_get_stats(neo_board *b);

/* -------------------------------- command_arpfind.c -------------------------------- */
void command_arpfind(int argc, char **argv);

/* -------------------------------- command_board.c -------------------------------- */
void command_board(int argc, char **argv);

/* -------------------------------- command_device.c -------------------------------- */
void command_device(int argc, char **argv);
void neo_command_device_type(neo_global *g, int argc, char **argv);
void neo_command_device_set(int argc, char **argv);
void neo_command_device_reset(neo_global *g, int argc, char **argv);
void neo_command_device_uplink(int argc, char **argv);

/* -------------------------------- command_device_info.c -------------------------------- */
void neo_command_device_info(int argc, char **argv);
void neo_command_device_info_system(int argc, char **argv);

/* -------------------------------- command_device_load.c -------------------------------- */
void neo_command_device_load(char *op, int argc, char **argv);

/* -------------------------------- command_device_summary.c -------------------------------- */
void neo_command_device_summary(neo_global *g, int argc, char **argv);
void summary_print_boards(neo_boardlist *s);
void summary_print_ports(neo_portlist *s);

/* -------------------------------- command_exec.c -------------------------------- */
void command_exec(int argc, char **argv);

/* -------------------------------- command_help.c -------------------------------- */
void command_help(int argc, char **argv);

/* -------------------------------- command_hostinfo.c -------------------------------- */
void command_hostinfo(int argc, char **argv);

/* -------------------------------- command_locate.c -------------------------------- */
void command_locate(int argc, char **argv);
int neo_command_locate_standardbridge_helper(neo_device *d, neo_searchable *s);

/* -------------------------------- command_location.c -------------------------------- */
void command_location(int argc, char **argv);
void command_location_print(int argc, char **argv);

/* -------------------------------- command_port.c -------------------------------- */
void command_port(int argc, char **argv);
void command_port_sed(neo_global *g, int argc, char **argv);
int neo_command_port_sed_standardbridge_helper(neo_location *loc, int command, int ifnum);

/* -------------------------------- command_port_search.c -------------------------------- */
void command_port_search(neo_global *g, int argc, char **argv);
int neo_command_port_search_standardbridge_helper(neo_device *d, int ifnum);

/* -------------------------------- command_print.c -------------------------------- */
void command_print(int argc, char **argv);

/* -------------------------------- command_set.c -------------------------------- */
void command_set(int argc, char **argv);

/* -------------------------------- command_stats.c -------------------------------- */
void command_stats(int argc, char **argv);
void neo_command_stats_print_portstats(neo_portlist *pl);
void neo_command_stats_print_boardstats(neo_boardlist *bl);
int neo_command_stats_standardbridge_helper(neo_device *d, neo_statstransfer *st, int ifnum);

/* -------------------------------- device.c -------------------------------- */
int neo_device_create_by_name(neo_device *d, char *name);
int neo_device_set_const_from_probe(neo_device *d, neo_global *g);
int neo_device_create_and_set_const(neo_device *d, neo_global *g, char *name);
int neo_device_has_boards(neo_device *d);
char *neo_device_get_name(neo_device *d);
char *neo_device_get_devname(neo_device *d);
char *neo_device_get_fullname(neo_device *d);
neo_boardlist *neo_device_get_boardlist(neo_device *d);
neo_portlist *neo_device_get_portlist(neo_device *d);
int neo_device_is_probed(neo_device *d);
void neo_device_free_elements(neo_device *d);
void neo_device_free_complete(neo_device *d);
void neo_device_debugprint(neo_device *d);
int neo_device_command_port_sed(neo_device *d, neo_location *loc, int command);
int neo_device_command_port_search(neo_device *d, neo_location *loc);
int neo_device_command_locate(neo_device *d, neo_searchable *s, neo_locationlist *l, int uplink);
int neo_device_command_summary(neo_device *d, neo_location *loc, neo_list *ret);
int neo_device_command_reset(neo_device *d);
int neo_device_command_load(neo_device *d, neo_location *loc, int type, int direction, char *host, char *file);
int neo_device_command_stats(neo_device *d, neo_location *loc, neo_list *list);
int neo_device_command_info(neo_device *d, int type);
int _neo_device_setconsts_from_oid(neo_device *d, char *oid);

/* -------------------------------- device_1012.c -------------------------------- */
int neo_command_port_sed_1012(neo_location *loc, int command);
int neo_command_device_summary_1012(neo_device *d, neo_location *loc, neo_list *out);
int neo_command_stats_1012(neo_location *loc, neo_list *out);

/* -------------------------------- device_2072.c -------------------------------- */
int neo_command_port_sed_2072(neo_location *loc, int command);
int neo_command_locate_2072(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);
int neo_command_device_summary_2072(neo_device *d, neo_location *loc, neo_list *out);
int neo_command_stats_2072(neo_location *loc, neo_list *out);
int neo_command_device_reset_2072(neo_device *d);
int neo_command_port_search_2072(neo_location *loc);

/* -------------------------------- device_5324.c -------------------------------- */
int neo_command_port_sed_5324(neo_location *loc, int command);
int neo_command_locate_5324(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);
int neo_command_device_summary_5324(neo_device *d, neo_location *loc, neo_list *pl);
int neo_command_stats_5324(neo_location *loc, neo_portlist *pl);
int neo_command_port_search_5324(neo_location *loc);

/* -------------------------------- device_apcups.c -------------------------------- */
void neo_command_device_info_apcups(neo_device *d, int type);

/* -------------------------------- device_c2200.c -------------------------------- */
int neo_command_port_sed_c2200(neo_location *loc, int command);
int neo_command_locate_c2200(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);
int neo_command_stats_c2200(neo_location *loc, neo_portlist *pl);
int neo_command_device_summary_c2200(neo_device *d, neo_location *loc, neo_list *pl);
int neo_command_port_search_c2200(neo_location *loc);

/* -------------------------------- device_cat2948.c -------------------------------- */
int neo_command_port_sed_cat2948(neo_location *loc, int command);
int neo_command_locate_cat2948(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);

/* -------------------------------- device_cat4000.c -------------------------------- */
int neo_command_port_sed_cat4000(neo_location *loc, int command);
int neo_command_device_summary_cat4000(neo_device *d, neo_location *loc, neo_list *out);

/* -------------------------------- device_cat5000.c -------------------------------- */
int neo_command_port_sed_cat5000(neo_location *loc, int command);
int neo_command_locate_cat5000(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);
int neo_command_device_summary_cat5000(neo_device *d, neo_location *loc, neo_list *out);
int neo_command_stats_cat5000(neo_location *loc, neo_portlist *pl);
int neo_command_device_load_cat5000(neo_location *loc, int type, int direction, char *host, char *file);
int neo_device_cat5000_boardport_to_ifnum_one(neo_device *d, int boardnum, int portnum);
int neo_device_cat5000_boardport_to_ifnum_two(neo_device *d, int boardnum, int portnum);
int neo_command_port_search_cat5000(neo_location *loc);
void neo_command_device_info_cat5000(neo_device *d, int type);

/* -------------------------------- device_ciscowav.c -------------------------------- */
int neo_command_locate_ciscowav(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);
int neo_command_port_search_ciscowav(neo_location *loc);

/* -------------------------------- device_extalp.c -------------------------------- */
int neo_device_extalp_boardport_to_ifnum(int boardnum, int portnum);
int neo_device_extalp_ifnum_to_boardnum(int ifnum);
int neo_device_extalp_ifnum_to_portnum(int ifnum);
int neo_command_port_sed_extalp(neo_location *loc, int command);
int neo_command_locate_extalp(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);
int neo_command_port_search_extalp(neo_location *loc);
int neo_command_device_summary_extalp(neo_device *d, neo_location *loc, neo_list *out);
int neo_command_stats_extalp(neo_location *loc, neo_portlist *pl);
void neo_command_device_info_extalp(neo_device *d, int type);

/* -------------------------------- device_extsum1.c -------------------------------- */
int neo_command_port_sed_extsum1(neo_location *loc, int command);
int neo_command_device_summary_extsum1(neo_device *d, neo_location *loc, neo_list *pl);
int neo_command_stats_extsum1(neo_location *loc, neo_portlist *pl);
int neo_command_locate_extsum1(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);
int neo_command_port_search_extsum1(neo_location *loc);

/* -------------------------------- device_extsum24.c -------------------------------- */
int neo_command_port_sed_extsum24(neo_location *loc, int command);
int neo_command_device_summary_extsum24(neo_device *d, neo_location *loc, neo_list *pl);
int neo_command_stats_extsum24(neo_location *loc, neo_portlist *pl);
int neo_command_locate_extsum24(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);

/* -------------------------------- device_extsum48.c -------------------------------- */
int neo_command_port_sed_extsum48(neo_location *loc, int command);
int neo_command_device_summary_extsum48(neo_device *d, neo_location *loc, neo_list *pl);
int neo_command_stats_extsum48(neo_location *loc, neo_portlist *pl);
int neo_command_locate_extsum48(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);
int neo_command_port_search_extsum48(neo_location *loc);

/* -------------------------------- device_generic.c -------------------------------- */
int neo_command_port_sed_generic(neo_location *loc, int command);
int neo_command_locate_generic(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);
int neo_command_device_summary_generic(neo_device *d, neo_location *loc, neo_list *pl);
int neo_command_stats_generic(neo_location *loc, neo_portlist *pl);
int neo_command_port_search_generic(neo_location *loc);
int neo_function_getuplink_generic(neo_location *loc);
void neo_command_device_info_generic(neo_device *d, int type);
void neo_command_device_info_ups_generic(neo_device *d);

/* -------------------------------- device_hp2524.c -------------------------------- */
int neo_command_port_sed_hp2524(neo_location *loc, int command);
int neo_command_device_summary_hp2524(neo_device *d, neo_location *loc, neo_list *pl);
int neo_command_stats_hp2524(neo_location *loc, neo_portlist *pl);
int neo_command_port_search_hp2524(neo_location *loc);
int neo_command_locate_hp2524(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);

/* -------------------------------- device_hpprinter.c -------------------------------- */
void neo_command_device_info_hpprinter(neo_device *d, int type);
int neo_command_device_reset_hpprinter(neo_device *d);

/* -------------------------------- device_lucentwav.c -------------------------------- */
int neo_command_locate_lucentwav(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);
int neo_command_device_reset_lucentwav(neo_device *d);
int neo_command_port_search_lucentwav(neo_location *loc);

/* -------------------------------- device_null.c -------------------------------- */
int neo_command_device_summary_null(neo_device *d, neo_location *loc, neo_list *out);
int neo_command_device_load_null(neo_location *d, int type, int direction, char *host, char *file);
int neo_command_device_reset_null();
int neo_command_locate_null(neo_device *d, neo_searchable *s, neo_locationlist *l, int uplink);
int neo_command_port_sed_null(neo_location *loc, int command);
int neo_command_stats_null(neo_location *loc, neo_list *list);
int neo_command_port_search_null(neo_location *loc);
void neo_command_device_info_null(neo_device *d, int type);

/* -------------------------------- device_router.c -------------------------------- */
int neo_command_port_sed_router(neo_location *loc, int command);
int neo_command_device_summary_router(neo_device *d, neo_location *loc, neo_list *pl);
int neo_command_stats_router(neo_location *loc, neo_portlist *pl);
int neo_command_locate_router(neo_device *d, neo_searchable *s, neo_locationlist *ans, int uplink);
int neo_command_port_search_router(neo_location *loc);
void neo_command_device_info_router_old(neo_device *d, int type);
void neo_command_device_info_router_new(neo_device *d, int type);

/* -------------------------------- devicelist.c -------------------------------- */
neo_devicelist *neo_devicelist_create_from_string(char *in, neo_global *g);
void neo_devicelist_set_deviceconsts(neo_devicelist *dl, neo_global *g);
void neo_devicelist_debugprint(neo_list *list);
neo_devicelist *devicelist_create_from_key(neo_global *g, char *key);

/* -------------------------------- functions.c -------------------------------- */
int neo_function_arpfind(neo_macaddr *outmac, char *hostname, char *router);
int neo_function_get_uplink(neo_locationlist *ans, char *devicename);

/* -------------------------------- global.c -------------------------------- */
void neo_global_create(neo_global *g);
void neo_global_set_macmode(neo_global *g, int mode);
int neo_global_set_macmode_from_string(neo_global *g, char *in);
int neo_global_get_macmode(neo_global *g);
char *neo_global_get_macmode_string(neo_global *g);
void neo_global_set_argv0(neo_global *g, char *in);
char *neo_global_get_argv0(neo_global *g);
void neo_global_set_burst(neo_global *g, int burst);
int neo_global_get_burst(neo_global *g);
void neo_global_set_readcom(neo_global *g, char *in);
char *neo_global_get_readcom(neo_global *g);
void neo_global_set_writecom(neo_global *g, char *in);
char *neo_global_get_writecom(neo_global *g);
void neo_global_set_keyfile(neo_global *g, char *in);
char *neo_global_get_keyfile(neo_global *g);
void neo_global_set_version(neo_global *g, char *in);
char *neo_global_get_version(neo_global *g);
void neo_global_set_statsdelay(neo_global *g, int d);
int neo_global_get_statsdelay(neo_global *g);
void neo_global_set_areyousure_ask(neo_global *g);
void neo_global_set_areyousure_yes(neo_global *g);
void neo_global_set_areyousure_no(neo_global *g);
int neo_global_is_areyousure_ask(neo_global *g);
int neo_global_is_areyousure_yes(neo_global *g);
int neo_global_is_areyousure_no(neo_global *g);
int neo_global_get_timeout(neo_global *g);
void neo_global_set_timeout(neo_global *g, int i);

/* -------------------------------- list.c -------------------------------- */
int neo_list_create(neo_list *l);
int neo_list_get_size(neo_list *l);
void *neo_list_get_element(neo_list *l, int n);
int neo_list_append_element(neo_list *l, void *element);
void neo_list_free_all(neo_list *l, void (*elefree)(void *));
void neo_list_free_simple(neo_list *l);

/* -------------------------------- listcasts.c -------------------------------- */
int neo_devicelist_create(neo_devicelist *list);
int neo_devicelist_append_element(neo_devicelist *list, neo_device *device);
neo_device *neo_devicelist_get_element(neo_devicelist *list, int index);
int neo_devicelist_get_size(neo_devicelist *list);
void neo_devicelist_free_all(neo_devicelist *list);
int neo_locationlist_create(neo_locationlist *list);
int neo_locationlist_append_element(neo_locationlist *list, neo_location *loc);
neo_location *neo_locationlist_get_element(neo_locationlist *list, int index);
int neo_locationlist_get_size(neo_locationlist *list);
void neo_locationlist_free_all(neo_locationlist *list);
int neo_boardlist_create(neo_boardlist *list);
int neo_boardlist_append_element(neo_boardlist *list, neo_board *board);
neo_board *neo_boardlist_get_element(neo_boardlist *list, int index);
int neo_boardlist_get_size(neo_boardlist *list);
void neo_boardlist_free_all(neo_boardlist *list);
int neo_portlist_create(neo_portlist *list);
int neo_portlist_append_element(neo_portlist *list, neo_port *port);
neo_port *neo_portlist_get_element(neo_portlist *list, int index);
int neo_portlist_get_size(neo_portlist *list);
void neo_portlist_free_all(neo_portlist *list);

/* -------------------------------- location.c -------------------------------- */
int neo_location_create_from_string(neo_location *loc, char *in);
int neo_location_num_hosts(neo_location *loc);
neo_device *neo_location_get_device_n(neo_location *loc, int n);
neo_device *neo_location_get_first_device(neo_location *loc);
int neo_location_is_simplehost(neo_location *loc);
int neo_location_has_port(neo_location *loc);
int neo_location_has_board(neo_location *loc);
int neo_location_star_port(neo_location *loc);
int neo_location_star_board(neo_location *loc);
int neo_location_get_portnum(neo_location *loc);
int neo_location_get_boardnum(neo_location *loc);
char *neo_location_get_instr(neo_location *loc);
int neo_location_to_string(neo_location *loc, char *buff);
void neo_location_set_deviceconsts(neo_location *loc, neo_global *g);
void neo_location_copy(neo_location *src, neo_location *dst);
int neo_location_debugprint(neo_location *loc);
void neo_location_free_elements(neo_location *loc);
void neo_location_free_complete(neo_location *loc);

/* -------------------------------- macaddr.c -------------------------------- */
void neo_macaddr_create_from_ints(neo_macaddr *m, int a, int b, int c, int d, int e, int f);
int neo_macaddr_create_from_string(neo_macaddr *m, char *in);
int neo_macaddr_create_from_dotted_ints(neo_macaddr *m, char *in);
void neo_macaddr_to_string(neo_macaddr *m, char *buff);
void neo_macaddr_to_dotted_ints_string(neo_macaddr *m, char *buff);
int neo_macaddr_is_equal(neo_macaddr *a, neo_macaddr *b);

/* -------------------------------- neo.c -------------------------------- */
int main(int argc, char **argv);
void interactive();
int dispatch(neo_global *g, int argc, char **argv);
void command_ktest(int argc, char **argv);
void command_winky(int argc, char **argv);
void neo_error_print(int n);
void neo_sig_handler(int sig);

/* -------------------------------- onelocation.c -------------------------------- */
int neo_onelocation_create_from_string(neo_onelocation *ol, char *in);
neo_device *neo_onelocation_get_device(neo_onelocation *ol);
int neo_onelocation_has_port(neo_onelocation *ol);
int neo_onelocation_has_board(neo_onelocation *ol);
int neo_onelocation_star_port(neo_onelocation *ol);
int neo_onelocation_star_board(neo_onelocation *ol);
int neo_onelocation_get_portnum(neo_onelocation *ol);
int neo_onelocation_get_boardnum(neo_onelocation *ol);
char *neo_onelocation_get_instr(neo_onelocation *ol);
int neo_onelocation_to_string(neo_onelocation *ol, char *buff);
void neo_onelocation_set_deviceconsts(neo_onelocation *ol);
int neo_onelocation_debugprint(neo_onelocation *ol);
void neo_onelocation_free_elements(neo_onelocation *ol);
void neo_onelocation_free_complete(neo_onelocation *ol);

/* -------------------------------- port.c -------------------------------- */
void neo_port_create(neo_port *p);
void neo_port_set_number(neo_port *p, int in);
int neo_port_get_number(neo_port *p);
void neo_port_set_descr(neo_port *p, char *descr);
char *neo_port_get_descr(neo_port *p);
void neo_port_set_link_up(neo_port *p);
void neo_port_set_link_down(neo_port *p);
void neo_port_set_link_autopart(neo_port *p);
void neo_port_set_link_unknown(neo_port *p);
int neo_port_link_is_up(neo_port *p);
int neo_port_link_is_down(neo_port *p);
int neo_port_link_is_autopart(neo_port *p);
int neo_port_link_is_unknown(neo_port *p);
void neo_port_set_speed(neo_port *p, int speed);
int neo_port_get_speed(neo_port *p);
void neo_port_set_admin(neo_port *p, int in);
int neo_port_get_admin(neo_port *p);
void neo_port_set_uplink(neo_port *p, int in);
int neo_port_get_uplink(neo_port *p);
void neo_port_set_duplex(neo_port *p, int duplex);
int neo_port_get_duplex(neo_port *p);
void neo_port_set_stats(neo_port *p, neo_stats *s);
neo_stats *neo_port_get_stats(neo_port *p);

/* -------------------------------- searchable.c -------------------------------- */
void neo_searchable_create_from_string(neo_searchable *s, char *in);
int neo_searchable_has_ipaddr(neo_searchable *s);
int neo_searchable_has_hostname(neo_searchable *s);
int neo_searchable_has_macaddr(neo_searchable *s);
void neo_searchable_create_by_ipaddr(neo_searchable *s, char *ip);
void neo_searchable_create_by_hostname(neo_searchable *s, char *hostname);
void neo_searchable_create_by_macaddr(neo_searchable *s, char *macaddr);
int neo_searchable_primary_is_ipaddr(neo_searchable *s);
int neo_searchable_primary_is_hostname(neo_searchable *s);
int neo_searchable_primary_is_macaddr(neo_searchable *s);
char *neo_searchable_get_hostname(neo_searchable *s);
char *neo_searchable_get_ipaddr(neo_searchable *s);
neo_macaddr *neo_searchable_get_macaddr(neo_searchable *s);
char *neo_searchable_to_string(neo_searchable *s);
int neo_searchable_expand_hostip(neo_searchable *s);

/* -------------------------------- sleeper.c -------------------------------- */
void neo_sleeper_create(neo_sleeper *s, int time);
void neo_sleeper_dowait(neo_sleeper *s);

/* -------------------------------- snmp.c -------------------------------- */
int neo_snmp_request_by_variable(char *host, char *variable, char *r);
neo_snmpresponselist *neo_snmp_many_requests_by_variable(char *host, char *variable);
int neo_snmp_set_by_variable(char *host, char *variable, char *type, char *value);

/* -------------------------------- snmpresponse.c -------------------------------- */
char *neo_snmpresponse_get_var(neo_snmpresponse *r);
char *neo_snmpresponse_get_val(neo_snmpresponse *r);
void neo_snmpresponselist_append_element(neo_snmpresponselist *list, neo_snmpresponse *resp);
neo_snmpresponse *neo_snmpresponselist_get_element(neo_snmpresponselist *list, int index);
char *neo_snmpresponselist_get_var(neo_snmpresponselist *list, int index);
char *neo_snmpresponselist_get_val(neo_snmpresponselist *list, int index);
int neo_snmpresponselist_get_size(neo_snmpresponselist *list);
void neo_snmpresponselist_free_all(neo_snmpresponselist *list);

/* -------------------------------- stats.c -------------------------------- */
void neo_stats_init(neo_stats *s);
int neo_stats_set_generic(neo_stats *s, int field, int type, int val);
int neo_stats_get_generic(neo_stats *s, int field, int type);

/* -------------------------------- statstransfer.c -------------------------------- */
void neo_statstransfer_init(neo_statstransfer *a);
void neo_statstransfer_compute_stats(neo_statstransfer *a, neo_statstransfer *b, neo_stats *s);
int neo_statstransfer_set_generic(neo_statstransfer *s, int field, int type, unsigned long val);
unsigned long int neo_statstransfer_get_generic(neo_statstransfer *s, int field, int type);
void neo_statstransfer_set_clk_inkbs(neo_statstransfer *s);
clock_t neo_statstransfer_get_clk_inkbs(neo_statstransfer *s);
void neo_statstransfer_set_clk_outkbs(neo_statstransfer *s);
clock_t neo_statstransfer_get_clk_outkbs(neo_statstransfer *s);
void neo_statstransfer_set_clk_inppsu(neo_statstransfer *s);
clock_t neo_statstransfer_get_clk_inppsu(neo_statstransfer *s);
void neo_statstransfer_set_clk_outppsu(neo_statstransfer *s);
clock_t neo_statstransfer_get_clk_outppsu(neo_statstransfer *s);
void neo_statstransfer_set_clk_inppsnu(neo_statstransfer *s);
clock_t neo_statstransfer_get_clk_inppsnu(neo_statstransfer *s);
void neo_statstransfer_set_clk_outppsnu(neo_statstransfer *s);
clock_t neo_statstransfer_get_clk_outppsnu(neo_statstransfer *s);
void neo_statstransfer_set_clk_inerrps(neo_statstransfer *s);
clock_t neo_statstransfer_get_clk_inerrps(neo_statstransfer *s);
void neo_statstransfer_set_clk_outerrps(neo_statstransfer *s);
clock_t neo_statstransfer_get_clk_outerrps(neo_statstransfer *s);

/* -------------------------------- util.c -------------------------------- */
int are_you_sure(char *str);
int get_pass(char *prompt, char *buff, int len);
int commatch(char *in, ...);
char **atokenize(char *buffer, char *sep, int *i);
int is_ipaddr(char *in);
void neo_register(char *msg);
void neo_timeformat(char *buff, int in_seconds);

