#include <stdio.h>
#include "neo.h"

int neo_onelocation_create_from_string(neo_onelocation *ol, char *in) {
  neo_location tmploc;
  int ret;
  
  ret=neo_location_create_from_string(&tmploc, in);
  if (ret!=0) return(ret);

  if (neo_location_num_hosts(&tmploc)>1) {
    neo_error=NEO_ERR_GENERIC;
    return(-1);
  }
  neo_location_copy(&(ol->loc), &tmploc);
  return(0);
}

neo_device *neo_onelocation_get_device(neo_onelocation *ol) {
  return(neo_location_get_first_device(&(ol->loc)));
}

int neo_onelocation_has_port(neo_onelocation *ol) {
  return(neo_location_has_port(&(ol->loc)));
}

int neo_onelocation_has_board(neo_onelocation *ol) {
  return(neo_location_has_board(&(ol->loc)));
}

int neo_onelocation_star_port(neo_onelocation *ol) {
  return(neo_location_star_port(&(ol->loc)));
}

int neo_onelocation_star_board(neo_onelocation *ol) {
  return(neo_location_star_board(&(ol->loc)));
}

  
int neo_onelocation_get_portnum(neo_onelocation *ol) {
  return(neo_location_get_portnum(&(ol->loc)));
}

int neo_onelocation_get_boardnum(neo_onelocation *ol) {
  return(neo_location_get_boardnum(&(ol->loc)));
}

char *neo_onelocation_get_instr(neo_onelocation *ol) {
  return(neo_location_get_instr(&(ol->loc)));
}

int neo_onelocation_to_string(neo_onelocation *ol, char *buff) {
  return(neo_location_to_string(&(ol->loc), buff));
}

void neo_onelocation_set_deviceconsts(neo_onelocation *ol) {
  return(neo_location_set_deviceconsts(&(ol->loc), g));
}

int neo_onelocation_debugprint(neo_onelocation *ol) {
  return(neo_location_debugprint(&(ol->loc)));
}

void neo_onelocation_free_elements(neo_onelocation *ol) {
  return(neo_location_free_elements(&(ol->loc)));
}

void neo_onelocation_free_complete(neo_onelocation *ol) {
  return(neo_location_free_complete(&(ol->loc)));
}
