#include <strings.h>
#include <string.h>
#include "neo.h"

void neo_port_create(neo_port *p) {
  neo_port_set_number(p, 0);
  neo_port_set_descr(p, "");
  neo_port_set_link_down(p);
  neo_port_set_speed(p, 0);
  neo_port_set_admin(p, -1);
  neo_port_set_uplink(p, -1);
  neo_port_set_duplex(p, -1);
}

void neo_port_set_number(neo_port *p, int in) {
  p->number=in;
}

int neo_port_get_number(neo_port *p) {
  return(p->number);
}

void neo_port_set_descr(neo_port *p, char *descr) {
  strcpy(p->descr, descr);
}

char *neo_port_get_descr(neo_port *p) {
  return(p->descr);
}

void neo_port_set_link_up(neo_port *p) {
  p->link=1;
}

void neo_port_set_link_down(neo_port *p) {
  p->link=0;
}

void neo_port_set_link_autopart(neo_port *p) {
  p->link=2;
}

void neo_port_set_link_unknown(neo_port *p) {
  p->link=-1;
}

int neo_port_link_is_up(neo_port *p) {
  if (p->link==1) return(1);
  return(0);
}

int neo_port_link_is_down(neo_port *p) {
  if (p->link==0) return(1);
  return(0);
}

int neo_port_link_is_autopart(neo_port *p) {
  if (p->link==2) return(1);
  return(0);
}

int neo_port_link_is_unknown(neo_port *p) {
  if (p->link==-1) return(1);
  return(0);
}

void neo_port_set_speed(neo_port *p, int speed) {
  p->speed=speed;
}

int neo_port_get_speed(neo_port *p) {
  return(p->speed);
}

void neo_port_set_admin(neo_port *p, int in) {
  p->admin=in;
}

int neo_port_get_admin(neo_port *p) {
  return(p->admin);
}

void neo_port_set_uplink(neo_port *p, int in) {
  if (in==1) {
    p->uplink=1;
  } else {
    p->uplink=0;
  }
}

int neo_port_get_uplink(neo_port *p) {
  return(p->uplink);
}

void neo_port_set_duplex(neo_port *p, int duplex) {
    p->duplex=duplex;
}

int neo_port_get_duplex(neo_port *p) {
  return(p->duplex);
}

void neo_port_set_stats(neo_port *p, neo_stats *s) {
  memcpy(&(p->stats), s, sizeof(neo_stats));
}

neo_stats *neo_port_get_stats(neo_port *p) {
  return(&(p->stats));
}
		   
  
