#include "neo.h"
#include <stdlib.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <strings.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>

void neo_searchable_create_from_string(neo_searchable *s, char *in) {
  int ret;
  
  s->primary_ip=0;
  s->primary_mac=0;
  s->primary_host=0;
  s->has_ip=0;
  s->has_mac=0;
  s->has_host=0;
  
  /* is it an ip address? */
  if (is_ipaddr(in)) {
    s->primary_ip=1;
    s->has_ip=1;
    strcpy(s->ipaddr, in);
    return;
  }

  /* how about a mac address? */
  ret=neo_macaddr_create_from_string(&(s->macaddr), in);
  if (!ret) {
    s->primary_mac=1;
    s->has_mac=1;
    return;
  }

  /* otherwise we assume it's a hostname */
  strcpy(s->hostname, in);
  s->primary_host=1;
  s->has_host=1;
  return;
}

int neo_searchable_has_ipaddr(neo_searchable *s) {
  return(s->has_ip);
}

int neo_searchable_has_hostname(neo_searchable *s) {
  return(s->has_host);
}

int neo_searchable_has_macaddr(neo_searchable *s) {
  return(s->has_mac);

}

void neo_searchable_create_by_ipaddr(neo_searchable *s, char *ip) {
  strcpy(s->ipaddr, ip);
  s->primary_ip=1;
  s->primary_mac=0;
  s->primary_host=0;
  s->has_ip=1;
  s->has_mac=0;
  s->has_host=0;
}

void neo_searchable_create_by_hostname(neo_searchable *s, char *hostname) {
  strcpy(s->hostname, hostname);
  s->primary_ip=0;
  s->primary_mac=0;
  s->primary_host=1;
  s->has_ip=0;
  s->has_mac=0;
  s->has_host=1;
}

void neo_searchable_create_by_macaddr(neo_searchable *s, char *macaddr) {
  neo_macaddr_create_from_string(&(s->macaddr), macaddr);
  s->primary_ip=0;
  s->primary_mac=1;
  s->primary_host=0;
  s->has_ip=0;
  s->has_mac=1;
  s->has_host=0;
}

int neo_searchable_primary_is_ipaddr(neo_searchable *s) {
  return(s->primary_ip);
}

int neo_searchable_primary_is_hostname(neo_searchable *s) {
  return(s->primary_host);
}

int neo_searchable_primary_is_macaddr(neo_searchable *s) {
  return(s->primary_mac);
}

char *neo_searchable_get_hostname(neo_searchable *s) {
  return(s->hostname);
}

char *neo_searchable_get_ipaddr(neo_searchable *s) {
  return(s->ipaddr);
}

neo_macaddr *neo_searchable_get_macaddr(neo_searchable *s) {
  return(&(s->macaddr));
}

char *neo_searchable_to_string(neo_searchable *s) {
  char *foo;
  
  if (s->primary_ip) return(s->ipaddr);
  if (s->primary_host) return(s->hostname);
  if (s->primary_mac) {
    foo=malloc(40);
    neo_macaddr_to_string(&(s->macaddr), foo);
    return(foo);
  }
  return("");
}

int neo_searchable_expand_hostip(neo_searchable *s) {
  /* if the primary is host then fill in the ip addr, if
   * the primary is ip addr then fill in the hostname */
  struct hostent *hent;
  struct sockaddr_in addr;

  hent=gethostbyname(s->hostname);
  if (!hent) {
    neo_error=NEO_ERR_NOHOST;
    return(-1);
  }

  if (s->primary_ip) {
    strcpy(s->hostname, hent->h_name);
    s->has_host=1;
  } else if (s->primary_host) {
    memset((char *) &(addr), 0, sizeof(struct sockaddr_in));
    addr.sin_family=AF_INET;
    memcpy(&(addr.sin_addr.s_addr), hent->h_addr, hent->h_length);

    strcpy(s->ipaddr, inet_ntoa(addr.sin_addr));
    s->has_ip=1;
  } else {
    return(-1);
  }
  
  return(0);
}
