#include "neo.h"
#include <stdlib.h>

/*
    MSNMP_ERR_BADOID,
  MSNMP_ERR_NOHOST,
  MSNMP_ERR_TIMEOUT,
  MSNMP_ERR_BAD_RESPONSE,

  MSNMP_ERR_NOSUCHVAR,
  MSNMP_ERR_TOOBIG,
  MSNMP_ERR_BADSETVAL,
  MSNMP_ERR_READONLY,
  MSNMP_ERR_GENERR
*/

int neo_snmp_request_by_variable(char *host, char *variable, char *r) {
  if (!msnmp_get(host, neo_global_get_readcom(g), variable, r, neo_global_get_timeout(g), neo_global_get_burst(g))) return(0);

  if (msnmp_errno==MSNMP_ERR_NOSUCHVAR) {
    neo_error=NEO_ERR_SNMP_NOVAR;
  } else if (msnmp_errno==MSNMP_ERR_NOHOST) {
    neo_error=NEO_ERR_SNMP_NOHOST;
  } else {
    neo_error=NEO_ERR_SNMP_GENERIC;
  }
  return(-1);
}  

neo_snmpresponselist *neo_snmp_many_requests_by_variable(char *host, char *variable) {
  msnmp_list *response;

  response=msnmp_walk(host, neo_global_get_readcom(g), variable, neo_global_get_timeout(g), neo_global_get_burst(g));
  if (response==NULL) {
    neo_error=NEO_ERR_SNMP_GENERIC;
    return(NULL);
  }

  return(response);
  
  /* return(ucdsnmpgetmany(host, variable, community, burst)); */
}

int neo_snmp_set_by_variable(char *host, char *variable, char *type, char *value) {
  int ret;
  char response[1024];

  ret=msnmp_set(host, neo_global_get_writecom(g), variable, type, value, response, neo_global_get_timeout(g), neo_global_get_burst(g));
  if (ret<0) {
    if (msnmp_errno==MSNMP_ERR_NOSUCHVAR) {
      neo_error=NEO_ERR_SNMP_NOVAR;
    } else if (msnmp_errno==MSNMP_ERR_BADSETVAL) {
      neo_error=NEO_ERR_SNMP_BADSET;
    } else if (msnmp_errno==MSNMP_ERR_READONLY) {
      neo_error=NEO_ERR_SNMP_BADSET;
    } else if (msnmp_errno==MSNMP_ERR_NOHOST) {
      neo_error=NEO_ERR_SNMP_NOHOST;
    } else {
      neo_error=NEO_ERR_SNMP_GENERIC;
    }

    return(-1);
    /* set the neo error */
  }
  return(0);

  /* create an actual response later? or just check it against the set internally? */
}
