#include "neo.h"

#define SVAL_ERROR -1
#define SVAL_UNAVAIL -2

void neo_stats_init(neo_stats *s) {
  s->inkbs=0;
  s->outkbs=0;
  s->totalkbs=0;
  s->inpps=0;
  s->outpps=0;
  s->totalpps=0;
  s->inerrps=0;
  s->outerrps=0;
  s->totalerrps=0;
}

int neo_stats_set_generic(neo_stats *s, int field, int type, int val) {
  int repval;
  
  if (val<0) return(-1);

  if (type==NEO_S_INT) {
    repval=val;
  } else if (type==NEO_S_ERROR) {
    repval=SVAL_ERROR;
  } else if (type==NEO_S_UNAVAIL) {
    repval=SVAL_UNAVAIL;
  } else {
    neo_error=NEO_ERR_INTERNAL;
    return(-1);
  }
  
  if (field==NEO_S_INKBS) {
    s->inkbs=repval;
  } else if (field==NEO_S_OUTKBS) {
    s->outkbs=repval;
  } else if (field==NEO_S_TOTALKBS) {
    s->totalkbs=repval;
  } else if (field==NEO_S_INPPS) {
    s->inpps=repval;
  } else if (field==NEO_S_OUTPPS) {
    s->outpps=repval;
  } else if (field==NEO_S_TOTALPPS) {
    s->totalpps=repval;
  } else if (field==NEO_S_INERRPS) {
    s->inerrps=repval;
  } else if (field==NEO_S_OUTERRPS) {
    s->outerrps=repval;
  } else if (field==NEO_S_TOTALERRPS) {
    s->totalerrps=repval;
  } else {
    neo_error=NEO_ERR_INTERNAL;
    return(-1);
  }
  return(0);

}

int neo_stats_get_generic(neo_stats *s, int field, int type) {
  /* returns -3 on error */
  int repval;
  
  if (field==NEO_S_INKBS) {
    repval=s->inkbs;
  } else if (field==NEO_S_OUTKBS) {
    repval=s->outkbs;
  } else if (field==NEO_S_TOTALKBS) {
    repval=s->totalkbs;
  } else if (field==NEO_S_INPPS) {
    repval=s->inpps;
  } else if (field==NEO_S_OUTPPS) {
    repval=s->outpps;
  } else if (field==NEO_S_TOTALPPS) {
    repval=s->totalpps;
  } else if (field==NEO_S_INERRPS) {
    repval=s->inerrps;
  } else if (field==NEO_S_OUTERRPS) {
    repval=s->outerrps;
  } else if (field==NEO_S_TOTALPPS) {
    repval=s->totalpps;
  } else {
    neo_error=NEO_ERR_INTERNAL;
    return(-3);
  } 

  if (type==NEO_S_INT) {
    return(repval);
  } else if (type==NEO_S_ERROR) {
    if (repval==SVAL_ERROR) {
      return(1);
    } else {
      return(0);
    }
  } else if (type==NEO_S_UNAVAIL) {
    if (repval==SVAL_UNAVAIL) {
      return(1);
    } else {
      return(0);
    }
  } else if (type==NEO_S_ERRORUNAVAIL) {
    if (repval==SVAL_ERROR || repval==SVAL_UNAVAIL) {
      return(1);
    } else {
      return(0);
    }
  } else {
    neo_error=NEO_ERR_INTERNAL;
    return(-3);
  }
  neo_error=NEO_ERR_INTERNAL;
  return(-3);
}
