#include "neo.h"
#include <time.h>

#define STVAL_ERROR -1
#define STVAL_UNAVAIL -2


void neo_statstransfer_init(neo_statstransfer *a) {
  a->inkbs=-1;
  a->outkbs=-1;
  a->inppsu=-1;
  a->outppsu=-1;
  a->inppsnu=-1;
  a->outppsnu=-1;
  a->inerrps=-1;
  a->outerrps=-1;
  a->clk_inkbs=-1;
  a->clk_outkbs=-1;
  a->clk_inppsu=-1;
  a->clk_outppsu=-1;
  a->clk_inppsnu=-1;
  a->clk_outppsnu=-1;
  a->clk_inerrps=-1;
  a->clk_outerrps=-1;
}

void neo_statstransfer_compute_stats(neo_statstransfer *a, neo_statstransfer *b, neo_stats *s) {
  float delay, delay1, delay2;

  neo_stats_init(s);

  /* kbs */
  if (neo_statstransfer_get_generic(a, NEO_ST_INKBS, NEO_ST_ERROR) ||
      neo_statstransfer_get_generic(b, NEO_ST_INKBS, NEO_ST_ERROR)) {
    neo_stats_set_generic(s, NEO_S_INKBS, NEO_S_ERROR, 0);
  } else if (neo_statstransfer_get_generic(a, NEO_ST_INKBS, NEO_ST_UNAVAIL) ||
	     neo_statstransfer_get_generic(b, NEO_ST_INKBS, NEO_ST_UNAVAIL)) {
    neo_stats_set_generic(s, NEO_S_INKBS, NEO_S_UNAVAIL, 0);
  } else {
    delay=(b->clk_inkbs - a->clk_inkbs)/(double)CLK_TCK;
    neo_stats_set_generic(s, NEO_S_INKBS, NEO_S_INT, (b->inkbs - a->inkbs)/delay);
  }

  if (neo_statstransfer_get_generic(a, NEO_ST_OUTKBS, NEO_ST_ERROR) ||
      neo_statstransfer_get_generic(b, NEO_ST_OUTKBS, NEO_ST_ERROR)) {
    neo_stats_set_generic(s, NEO_S_OUTKBS, NEO_S_ERROR, 0);
  } else if (neo_statstransfer_get_generic(a, NEO_ST_OUTKBS, NEO_ST_UNAVAIL) ||
	     neo_statstransfer_get_generic(b, NEO_ST_OUTKBS, NEO_ST_UNAVAIL)) {
    neo_stats_set_generic(s, NEO_S_OUTKBS, NEO_S_UNAVAIL, 0);
  } else {
    delay=(b->clk_outkbs - a->clk_outkbs)/(double)CLK_TCK;
    neo_stats_set_generic(s, NEO_S_OUTKBS, NEO_S_INT, (b->outkbs - a->outkbs)/delay);
  }

  if (neo_stats_get_generic(s, NEO_S_INKBS, NEO_S_ERROR) ||
      neo_stats_get_generic(s, NEO_S_OUTKBS, NEO_S_ERROR)) {
    neo_stats_set_generic(s, NEO_S_TOTALKBS, NEO_S_ERROR, 0);
  } else if (neo_stats_get_generic(s, NEO_S_INKBS, NEO_S_UNAVAIL) ||
	     neo_stats_get_generic(s, NEO_S_OUTKBS, NEO_S_UNAVAIL)) {
    neo_stats_set_generic(s, NEO_S_TOTALKBS, NEO_S_UNAVAIL, 0);
  } else {
    neo_stats_set_generic(s, NEO_S_TOTALKBS, NEO_S_INT,
			  neo_stats_get_generic(s, NEO_S_INKBS, NEO_S_INT) +
			  neo_stats_get_generic(s, NEO_S_OUTKBS, NEO_S_INT));
  }
  
  /* pps */
  if (neo_statstransfer_get_generic(a, NEO_ST_INPPSU, NEO_ST_ERROR) ||
      neo_statstransfer_get_generic(a, NEO_ST_INPPSNU, NEO_ST_ERROR) ||
      neo_statstransfer_get_generic(b, NEO_ST_INPPSU, NEO_ST_ERROR) ||
      neo_statstransfer_get_generic(b, NEO_ST_INPPSNU, NEO_ST_ERROR)) {
    neo_stats_set_generic(s, NEO_S_INPPS, NEO_S_ERROR, 0);
  } else if (neo_statstransfer_get_generic(a, NEO_ST_INPPSU, NEO_ST_UNAVAIL) ||
	     neo_statstransfer_get_generic(a, NEO_ST_INPPSNU, NEO_ST_UNAVAIL) ||
	     neo_statstransfer_get_generic(b, NEO_ST_INPPSU, NEO_ST_UNAVAIL) ||
	     neo_statstransfer_get_generic(b, NEO_ST_INPPSNU, NEO_ST_UNAVAIL)) {
    neo_stats_set_generic(s, NEO_S_INPPS, NEO_S_UNAVAIL, 0);
  } else {
    delay1=(b->clk_inppsu - a->clk_inppsu)/(double)CLK_TCK;
    delay2=(b->clk_inppsnu - a->clk_inppsnu)/(double)CLK_TCK;
    neo_stats_set_generic(s, NEO_S_INPPS, NEO_S_INT, ((b->inppsu - a->inppsu)/delay1) + ((b->inppsnu - a->inppsnu)/delay2));
  }

  if (neo_statstransfer_get_generic(a, NEO_ST_OUTPPSU, NEO_ST_ERROR) ||
      neo_statstransfer_get_generic(a, NEO_ST_OUTPPSNU, NEO_ST_ERROR) ||
      neo_statstransfer_get_generic(b, NEO_ST_OUTPPSU, NEO_ST_ERROR) ||
      neo_statstransfer_get_generic(b, NEO_ST_OUTPPSNU, NEO_ST_ERROR)) {
    neo_stats_set_generic(s, NEO_S_OUTPPS, NEO_S_ERROR, 0);
  } else if (neo_statstransfer_get_generic(a, NEO_ST_OUTPPSU, NEO_ST_UNAVAIL) ||
	     neo_statstransfer_get_generic(a, NEO_ST_OUTPPSNU, NEO_ST_UNAVAIL) ||
	     neo_statstransfer_get_generic(b, NEO_ST_OUTPPSU, NEO_ST_UNAVAIL) ||
	     neo_statstransfer_get_generic(b, NEO_ST_OUTPPSNU, NEO_ST_UNAVAIL)) {
    neo_stats_set_generic(s, NEO_S_OUTPPS, NEO_S_UNAVAIL, 0);
  } else {
    delay1=(b->clk_outppsu - a->clk_outppsu)/(double)CLK_TCK;
    delay2=(b->clk_outppsnu - a->clk_outppsnu)/(double)CLK_TCK;
    neo_stats_set_generic(s, NEO_S_OUTPPS, NEO_S_INT, ((b->outppsu - a->outppsu)/delay1) + ((b->outppsnu - a->outppsnu)/delay2));
  }

  if (neo_stats_get_generic(s, NEO_S_INPPS, NEO_S_ERROR) ||
      neo_stats_get_generic(s, NEO_S_OUTPPS, NEO_S_ERROR)) {
    neo_stats_set_generic(s, NEO_S_TOTALPPS, NEO_S_ERROR, 0);
  } else if (neo_stats_get_generic(s, NEO_S_INPPS, NEO_S_UNAVAIL) ||
	     neo_stats_get_generic(s, NEO_S_OUTPPS, NEO_S_UNAVAIL)) {
    neo_stats_set_generic(s, NEO_S_TOTALPPS, NEO_S_UNAVAIL, 0);
  } else {
    neo_stats_set_generic(s, NEO_S_TOTALPPS, NEO_S_INT,
			  neo_stats_get_generic(s, NEO_S_INPPS, NEO_S_INT) +
			  neo_stats_get_generic(s, NEO_S_OUTPPS, NEO_S_INT));
  }
  
  /* errors */
  
  /* maybe conditionalize */
  if (neo_statstransfer_get_generic(a, NEO_ST_INERRPS, NEO_ST_ERROR) ||
      neo_statstransfer_get_generic(b, NEO_ST_INERRPS, NEO_ST_ERROR)) {
    neo_stats_set_generic(s, NEO_S_INERRPS, NEO_S_ERROR, 0);
  } else if (neo_statstransfer_get_generic(a, NEO_ST_INERRPS, NEO_ST_UNAVAIL) ||
	     neo_statstransfer_get_generic(b, NEO_ST_INERRPS, NEO_ST_UNAVAIL)) {
    neo_stats_set_generic(s, NEO_S_INERRPS, NEO_S_UNAVAIL, 0);
  } else {
    delay=(b->clk_inerrps - a->clk_inerrps)/(double)CLK_TCK;
    neo_stats_set_generic(s, NEO_S_INERRPS, NEO_S_INT, (b->inerrps - a->inerrps)/delay);
  }

  if (neo_statstransfer_get_generic(a, NEO_ST_OUTERRPS, NEO_ST_ERROR) ||
      neo_statstransfer_get_generic(b, NEO_ST_OUTERRPS, NEO_ST_ERROR)) {
    neo_stats_set_generic(s, NEO_S_OUTERRPS, NEO_S_ERROR, 0);
  } else if (neo_statstransfer_get_generic(a, NEO_ST_OUTERRPS, NEO_ST_UNAVAIL) ||
	     neo_statstransfer_get_generic(b, NEO_ST_OUTERRPS, NEO_ST_UNAVAIL)) {
    neo_stats_set_generic(s, NEO_S_OUTERRPS, NEO_S_UNAVAIL, 0);
  } else {
    delay=(b->clk_outerrps - a->clk_outerrps)/(double)CLK_TCK;
    neo_stats_set_generic(s, NEO_S_OUTERRPS, NEO_S_INT, (b->outerrps - a->outerrps)/delay);
  }

  if (neo_stats_get_generic(s, NEO_S_INERRPS, NEO_S_ERROR) ||
      neo_stats_get_generic(s, NEO_S_OUTERRPS, NEO_S_ERROR)) {
    neo_stats_set_generic(s, NEO_S_TOTALERRPS, NEO_S_ERROR, 0);
  } else if (neo_stats_get_generic(s, NEO_S_INERRPS, NEO_S_UNAVAIL) ||
	     neo_stats_get_generic(s, NEO_S_OUTERRPS, NEO_S_UNAVAIL)) {
    neo_stats_set_generic(s, NEO_S_TOTALERRPS, NEO_S_UNAVAIL, 0);
  } else {
    neo_stats_set_generic(s, NEO_S_TOTALERRPS, NEO_S_UNAVAIL,
			  neo_stats_get_generic(s, NEO_S_INERRPS, NEO_S_INT) +
			  neo_stats_get_generic(s, NEO_S_OUTERRPS, NEO_S_INT));
  }

}

int neo_statstransfer_set_generic(neo_statstransfer *s, int field, int type, unsigned long val) {
  unsigned long repval;

  if (val<0) return(-1);

  if (type==NEO_ST_INT) {
    repval=val;
  } else if (type==NEO_ST_ERROR) {
    repval=STVAL_ERROR;
  } else if (type==NEO_ST_UNAVAIL) {
    repval=STVAL_UNAVAIL;
  } else {
    neo_error=NEO_ERR_INTERNAL;
    return(-1);
  }
  
  if (field==NEO_ST_INKBS) {
    s->inkbs=repval;
  } else if (field==NEO_ST_OUTKBS) {
    s->outkbs=repval;
  } else if (field==NEO_ST_INPPSU) {
    s->inppsu=repval;
  } else if (field==NEO_ST_OUTPPSU) {
    s->outppsu=repval;
  } else if (field==NEO_ST_INPPSNU) {
    s->inppsnu=repval;
  } else if (field==NEO_ST_OUTPPSNU) {
    s->outppsnu=repval;
  } else if (field==NEO_ST_INERRPS) {
    s->inerrps=repval;
  } else if (field==NEO_ST_OUTERRPS) {
    s->outerrps=repval;
  } else {
    neo_error=NEO_ERR_INTERNAL;
    return(-1);
  }
  return(0);
}

unsigned long int neo_statstransfer_get_generic(neo_statstransfer *s, int field, int type) {
  /* returns -3 on error */
  unsigned long int repval;
  
  if (field==NEO_ST_INKBS) {
    repval=s->inkbs;
  } else if (field==NEO_ST_OUTKBS) {
    repval=s->outkbs;
  } else if (field==NEO_ST_INPPSU) {
    repval=s->inppsu;
  } else if (field==NEO_ST_OUTPPSU) {
    repval=s->outppsu;
  } else if (field==NEO_ST_INPPSNU) {
    repval=s->inppsnu;
  } else if (field==NEO_ST_OUTPPSNU) {
    repval=s->outppsnu;
  } else if (field==NEO_ST_INERRPS) {
    repval=s->inerrps;
  } else if (field==NEO_ST_OUTERRPS) {
    repval=s->outerrps;
  } else {
    neo_error=NEO_ERR_INTERNAL;
    return(-3);
  }

  if (type==NEO_ST_INT) {
    return(repval);
  } else if (type==NEO_ST_ERROR) {
    if (repval==STVAL_ERROR) {
      return(1);
    } else {
      return(0);
    }
  } else if (type==NEO_ST_UNAVAIL) {
    if (repval==STVAL_UNAVAIL) {
      return(1);
    } else {
      return(0);
    }
  } else if (type==NEO_ST_ERRORUNAVAIL) {
    if (repval==STVAL_ERROR || repval==STVAL_UNAVAIL) {
      return(1);
    } else {
      return(0);
    }
  } else {
    neo_error=NEO_ERR_INTERNAL;
    return(-3);
  }
  neo_error=NEO_ERR_INTERNAL;
  return(-3);
}


/* Clocks */

/* clock for inkbs */

void neo_statstransfer_set_clk_inkbs(neo_statstransfer *s) {
  struct tms foo;
  s->clk_inkbs=times(&foo);
}

clock_t neo_statstransfer_get_clk_inkbs(neo_statstransfer *s) {
  return(s->clk_inkbs);
}

void neo_statstransfer_set_clk_outkbs(neo_statstransfer *s) {
  struct tms foo;
  s->clk_outkbs=times(&foo);
}

clock_t neo_statstransfer_get_clk_outkbs(neo_statstransfer *s) {
  return(s->clk_outkbs);
}

void neo_statstransfer_set_clk_inppsu(neo_statstransfer *s) {
  struct tms foo;
  s->clk_inppsu=times(&foo);
}

clock_t neo_statstransfer_get_clk_inppsu(neo_statstransfer *s) {
  return(s->clk_inppsu);
}

void neo_statstransfer_set_clk_outppsu(neo_statstransfer *s) {
  struct tms foo;
  s->clk_outppsu=times(&foo);
}

clock_t neo_statstransfer_get_clk_outppsu(neo_statstransfer *s) {
  return(s->clk_outppsu);
}

void neo_statstransfer_set_clk_inppsnu(neo_statstransfer *s) {
  struct tms foo;
  s->clk_inppsnu=times(&foo);
}

clock_t neo_statstransfer_get_clk_inppsnu(neo_statstransfer *s) {
  return(s->clk_inppsnu);
}

void neo_statstransfer_set_clk_outppsnu(neo_statstransfer *s) {
  struct tms foo;
  s->clk_outppsnu=times(&foo);
}

clock_t neo_statstransfer_get_clk_outppsnu(neo_statstransfer *s) {
  return(s->clk_outppsnu);
}

void neo_statstransfer_set_clk_inerrps(neo_statstransfer *s) {
  struct tms foo;
  s->clk_inerrps=times(&foo);
}

clock_t neo_statstransfer_get_clk_inerrps(neo_statstransfer *s) {
  return(s->clk_inerrps);
}

void neo_statstransfer_set_clk_outerrps(neo_statstransfer *s) {
  struct tms foo;
  s->clk_outerrps=times(&foo);
}

clock_t neo_statstransfer_get_clk_outerrps(neo_statstransfer *s) {
  return(s->clk_outerrps);
}
