#include "neo.h"
#include <stdlib.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netdb.h>
#include <strings.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <termios.h>
#include <pwd.h>


int are_you_sure(char *str) {
  char buff[1024];

  if (neo_global_is_areyousure_yes(g)) return(1);
  if (neo_global_is_areyousure_no(g)) return(0);

  if (str==NULL) {
    printf("Would you like to continue? [y/N]: ");
  } else {
    printf("%s", str);
  }
  fgets(buff, 1024, stdin);

  /* nuke the newline */
  buff[strlen(buff)-1]='\0';
  
  if (!strcasecmp(buff, "y") || !strcasecmp(buff, "yes")) {
    return(1);
  }
  printf("Aborting.\n");
  return(0);
}

int get_pass(char *prompt, char *buff, int len) {
  struct termios tsave, t;
  FILE *file;
  char *ptr;
  int c;

  file=fopen(ctermid(NULL), "r+");
  if (!file) {
    perror("opening terminal");
    return(-1);
  }
  setbuf(file, NULL);

  tcgetattr(fileno(file), &tsave);

  memcpy(&t, &tsave, sizeof(tsave));
  t.c_lflag &= ~(ECHO|ECHOE|ECHOK|ECHONL);
  tcsetattr(fileno(file), TCSAFLUSH, &t);
  if (!prompt) {
    fputs("password: ", file);
  } else {
    fprintf(file, "%s", prompt);
  }

  ptr=buff;
  while((c=getc(file)) != EOF && c!= '\n') {
    if (ptr<&buff[len]) {
      *ptr++=c;
    }
  }

  *ptr=0;
  putc('\n', file);
  
  tcsetattr(fileno(file), TCSAFLUSH, &tsave);

  fclose(file);
  return(0);
}

int commatch(char *in, ...) {
  char *b;
  va_list ap;

  va_start(ap, in);
  while(1) {
    b=va_arg(ap, char *);
    if (b==NULL) break;
    if (!strcmp(in, b)) {
      va_end(ap);
      return(1);
    }
  }
  va_end(ap);
  return(0);
}

char **atokenize(char *buffer, char *sep, int *i) {
  /* each element of return must be freed by user */
  char **args;
  char *workbuff, *foo;
  int done=0, first=1, count=0;

  workbuff=malloc(strlen(buffer)+1);
  memcpy(workbuff, buffer, strlen(buffer)+1);

  args=NULL;
  while (!done) {
    if (first) {
      first=0;
      foo=(char *)strtok(workbuff, sep);
    } else {
      foo=(char *)strtok(NULL, sep);
    }
    if (foo==NULL) {
      done=1;
    } else {
      args=(char **)realloc(args, sizeof(char *) * (count+1));
      args[count]=malloc(strlen(foo)+1);
      strcpy(args[count], foo);
      count++;
    }
  }
  *i=count;
  free(workbuff);
  return(args);
}

int is_ipaddr(char *in) {
#ifdef linux
  unsigned long int ipaddr;
#else
  in_addr_t ipaddr;
#endif
  char *ptr;

  ipaddr=inet_addr(in);
  if (ipaddr == -1) return(0);

  ptr=strchr(in, '.');
  if (!ptr || ptr==in) return(0);
  ptr=strchr(ptr+2, '.');
  if (!ptr) return(0);
  ptr=strchr(ptr+2, '.');
  if (!ptr) return(0);
  if (ptr[1]=='\0') return(0);
  
  return(1);
}
#if 0

          /*   execl is called by
                    execl(file, arg1, arg2, ..., (char *)0);
          */
          execl(va_alist)
          va_dcl
          {
               va_list ap;
               char *file;
               char *args[MAXARGS];          /* assumed big enough*/
               int argno = 0;

               va_start(ap);
               file = va_arg(ap, char *);
               while ((args[argno++] = va_arg(ap, char *)) != 0)
                    ;
               va_end(ap);
               return execv(file, args);
          }
#endif

void neo_register(char *msg) {
  struct hostent *hent;
  struct sockaddr_in servaddr;
  int sockfd;
  char buff[1024], tmpbuff[1024];
  struct passwd *pw;

  pw=getpwuid(getuid());
  sprintf(buff, "User: %s (%i)\n", pw->pw_name, (int) getuid());

  gethostname(tmpbuff, 1024);
  sprintf(buff, "%sHostname: %s\n", buff, tmpbuff);

  sprintf(buff, "%sNeo Version: %s\n", buff, neo_global_get_version(g));

  getcwd(tmpbuff, 1023);
  sprintf(buff, "%sCwd: %s\nArgv[0]: %s\n", buff, tmpbuff, neo_global_get_argv0(g));

  if (msg) {
    sprintf(buff, "%sMessage: %s\n", buff, msg);
  } else {
    sprintf(buff, "%sMessage:\n", buff);
  }

  hent=gethostbyname("spatula-city.mit.edu");
  if (!hent) return;

  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family=AF_INET;
  servaddr.sin_port=htons(8878);
  memcpy(&(servaddr.sin_addr.s_addr), hent->h_addr, hent->h_length);

  sockfd=socket(AF_INET, SOCK_DGRAM, 0);

  sendto(sockfd, buff, strlen(buff)+1, 0, (struct sockaddr *) &servaddr, sizeof(servaddr));
}

void neo_timeformat(char *buff, int in_seconds) {
  int days, minutes, hours;
  long run;

  run=in_seconds;

  days=run/86400;
  run-=days*86400;
  hours=run/3600;
  run-=hours*3600;
  minutes=run/60;
  run-=minutes*60;

  sprintf(buff, "%i d %2.2i:%2.2i:%2.2li", days, hours, minutes, run);
}
